/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.jcajce.spec;

import io.gatling.recorder.internal.bouncycastle.crypto.util.RadixConverter;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class FPEParameterSpec
implements AlgorithmParameterSpec {
    private final RadixConverter radixConverter;
    private final byte[] tweak;
    private final boolean useInverse;

    public FPEParameterSpec(int n, byte[] byArray) {
        this(n, byArray, false);
    }

    public FPEParameterSpec(int n, byte[] byArray, boolean bl) {
        this(new RadixConverter(n), byArray, bl);
    }

    public FPEParameterSpec(RadixConverter radixConverter, byte[] byArray, boolean bl) {
        this.radixConverter = radixConverter;
        this.tweak = Arrays.clone(byArray);
        this.useInverse = bl;
    }

    public int getRadix() {
        return this.radixConverter.getRadix();
    }

    public int getRadixConverter() {
        return this.radixConverter.getRadix();
    }

    public byte[] getTweak() {
        return Arrays.clone(this.tweak);
    }

    public boolean isUsingInverseFunction() {
        return this.useInverse;
    }
}

