package io.gatling.recorder.internal.bouncycastle.cms;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.KEMRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.RecipientIdentifier;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;

public class KEMRecipientInformation
    extends RecipientInformation
{
    private KEMRecipientInfo info;

    KEMRecipientInformation(
        KEMRecipientInfo        info,
        AlgorithmIdentifier     messageAlgorithm,
        CMSSecureReadable       secureReadable)
    {
        super(info.getKem(), messageAlgorithm, secureReadable);

        this.info = info;

        RecipientIdentifier r = info.getRecipientIdentifier();

        if (r.isTagged())
        {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());

            rid = new KEMRecipientId(octs.getOctets());
        }
        else
        {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());

            rid = new KEMRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    public AlgorithmIdentifier getKdfAlgorithm()
    {
        return info.getKdf();
    }

    public byte[] getUkm()
    {
        return Arrays.clone(info.getUkm());
    }

    public byte[] getEncapsulation()
    {
        return Arrays.clone(info.getKemct().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient)
        throws CMSException
    {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(keyEncAlg.getAlgorithm(), info), messageAlgorithm, info.getEncryptedKey().getOctets());
    }
}
