package io.gatling.recorder.internal.bouncycastle.crypto.agreement;

import java.math.BigInteger;

import io.gatling.recorder.internal.bouncycastle.crypto.BasicAgreement;
import io.gatling.recorder.internal.bouncycastle.crypto.CipherParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.RawAgreement;
import io.gatling.recorder.internal.bouncycastle.util.BigIntegers;

public final class BasicRawAgreement
    implements RawAgreement
{
    public final BasicAgreement basicAgreement;

    public BasicRawAgreement(BasicAgreement basicAgreement)
    {
        if (basicAgreement == null)
        {
            throw new NullPointerException("'basicAgreement' cannot be null");
        }

        this.basicAgreement = basicAgreement;
    }

    public void init(CipherParameters parameters)
    {
        basicAgreement.init(parameters);
    }

    public int getAgreementSize()
    {
        return basicAgreement.getFieldSize();
    }

    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off)
    {
        BigInteger z = basicAgreement.calculateAgreement(publicKey);
        BigIntegers.asUnsignedByteArray(z, buf, off, getAgreementSize());
    }
}
