package io.gatling.recorder.internal.bouncycastle.operator.bc;

import java.io.IOException;

import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.gatling.recorder.internal.bouncycastle.crypto.Signer;
import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.operator.OperatorCreationException;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.util.PublicKeyFactory;

/**
 * Builder for creating content verifier providers that support the HSS/LMS Hash-Based Signature Algorithm.
 *
 * <b>Reference:</b> Use of the HSS/LMS Hash-Based Signature Algorithm in the Cryptographic Message Syntax (CMS)
 * <a href="https://datatracker.ietf.org/doc/rfc9708/">RFC 9708</a>.
 * </p>
 */
public class BcHssLmsContentVerifierProviderBuilder
    extends BcContentVerifierProviderBuilder
{
    public BcHssLmsContentVerifierProviderBuilder()
    {
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId)
        throws OperatorCreationException
    {
        return new BcHssLmsContentSignerBuilder.HssSigner();
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo)
        throws IOException
    {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}
