package io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc;

import io.gatling.recorder.internal.bouncycastle.util.Arrays;

public class HQCPrivateKeyParameters
    extends HQCKeyParameters
{
    private byte[] sk;

    public HQCPrivateKeyParameters(HQCParameters params, byte[] sk)
    {
        super(true, params);
        this.sk = Arrays.clone(sk);
    }

    public byte[] getPrivateKey()
    {
        return Arrays.clone(this.sk);
    }

    public byte[] getEncoded()
    {
        return Arrays.clone(this.sk);
    }
}
