/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.config.GatlingFiles$;
import io.gatling.core.filter.BlackList;
import io.gatling.core.filter.WhiteList;
import io.gatling.core.util.ConfigHelper$;
import io.gatling.core.util.IO$;
import io.gatling.core.util.StringHelper;
import io.gatling.core.util.StringHelper$;
import io.gatling.recorder.config.ConfigKeys$;
import io.gatling.recorder.config.ConfigKeys$core$;
import io.gatling.recorder.config.ConfigKeys$filters$;
import io.gatling.recorder.config.ConfigKeys$http$;
import io.gatling.recorder.config.ConfigKeys$netty$;
import io.gatling.recorder.config.ConfigKeys$proxy$;
import io.gatling.recorder.config.ConfigKeys$proxy$outgoing$;
import io.gatling.recorder.config.CoreConfiguration;
import io.gatling.recorder.config.FilterStrategy$;
import io.gatling.recorder.config.FiltersConfiguration;
import io.gatling.recorder.config.HttpConfiguration;
import io.gatling.recorder.config.NettyConfiguration;
import io.gatling.recorder.config.OutgoingProxyConfiguration;
import io.gatling.recorder.config.ProxyConfiguration;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderConfiguration$IntOption$;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.package$;
import scala.util.Properties$;
import scala.util.matching.Regex;

public final class RecorderConfiguration$
implements StrictLogging,
Serializable {
    public static final RecorderConfiguration$ MODULE$;
    private final Regex Remove4SpacesRegex;
    private final ConfigRenderOptions RenderOptions;
    private Option<File> configFile;
    private RecorderConfiguration configuration;
    private final Logger logger;

    static {
        new RecorderConfiguration$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int IntOption(int value) {
        return value;
    }

    public Regex Remove4SpacesRegex() {
        return this.Remove4SpacesRegex;
    }

    public ConfigRenderOptions RenderOptions() {
        return this.RenderOptions;
    }

    public Option<File> configFile() {
        return this.configFile;
    }

    public void configFile_$eq(Option<File> x$1) {
        this.configFile = x$1;
    }

    public RecorderConfiguration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(RecorderConfiguration x$1) {
        this.configuration = x$1;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Config getDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.parseResources((ClassLoader)classLoader, (String)"recorder-defaults.conf");
    }

    public RecorderConfiguration fakeConfig(scala.collection.immutable.Map<String, Object> props) {
        Config defaultConfig = this.getDefaultConfig(this.getClassLoader());
        return this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.parseMap((Map)JavaConversions$.MODULE$.mapAsJavaMap(props)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{defaultConfig})));
    }

    public void initialSetup(scala.collection.immutable.Map<String, Object> props, Option<scala.reflect.io.File> recorderConfigFile) {
        ClassLoader classLoader = this.getClassLoader();
        Config defaultConfig = this.getDefaultConfig(classLoader);
        this.configFile_$eq((Option<File>)recorderConfigFile.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(scala.reflect.io.File x$1) {
                return x$1.jfile();
            }
        }).orElse((Function0)new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader classLoader$1;

            public final Option<File> apply() {
                return Option$.MODULE$.apply((Object)this.classLoader$1.getResource("recorder.conf")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply(URL url) {
                        return new File(url.getFile());
                    }
                });
            }
            {
                this.classLoader$1 = classLoader$1;
            }
        }));
        Config customConfig = (Config)this.configFile().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(File x$1) {
                return ConfigFactory.parseFile((File)x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply() {
                Predef$.MODULE$.println((Object)"Maven archetype or SBT template outdated: Please create a new one or check the migration guide on how to update it.");
                Predef$.MODULE$.println((Object)"Recorder preferences won't be saved until then.");
                return ConfigFactory.empty();
            }
        });
        Config propertiesConfig = ConfigFactory.parseMap((Map)JavaConversions$.MODULE$.mapAsJavaMap(props));
        try {
            this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, customConfig, defaultConfig}))));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configured ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configuration()})));
            }
        }
        catch (Exception exception) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading configuration crashed: ", ". Probable cause is a format change, resetting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})));
            }
            this.configFile().foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.delete();
                }
            });
            this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultConfig}))));
        }
    }

    public Option<scala.reflect.io.File> initialSetup$default$2() {
        return None$.MODULE$;
    }

    public void reload(scala.collection.immutable.Map<String, Object> props) {
        Config frameConfig = ConfigFactory.parseMap((Map)JavaConversions$.MODULE$.mapAsJavaMap(props));
        this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(frameConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{this.configuration().config()}))));
    }

    public void saveConfig() {
        ConfigObject configToSave = this.configuration().config().withoutPath(ConfigKeys$core$.MODULE$.RequestBodiesFolder()).root().withOnlyKey(ConfigKeys$.MODULE$.ConfigRoot());
        this.configFile().foreach((Function1)new Serializable(configToSave){
            public static final long serialVersionUID = 0L;
            public final ConfigObject configToSave$1;

            public final void apply(File file) {
                IO$.MODULE$.withCloseable((Closeable)RecorderConfiguration$.MODULE$.createAndOpen(file).bufferedWriter(), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.saveConfig.1 $outer;

                    public final void apply(BufferedWriter x$3) {
                        x$3.write(this.$outer.configToSave$1.render(RecorderConfiguration$.MODULE$.RenderOptions()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.configToSave$1 = configToSave$1;
            }
        });
    }

    public scala.reflect.io.File createAndOpen(File jfile) {
        File parent;
        block4: {
            block3: {
                Object object;
                block2: {
                    if (!jfile.exists()) break block2;
                    object = BoxedUnit.UNIT;
                    break block3;
                }
                parent = jfile.getParentFile();
                if (parent != null && !parent.exists()) break block4;
                object = BoxesRunTime.boxToBoolean((boolean)jfile.createNewFile());
            }
            return package$.MODULE$.File().apply(Path$.MODULE$.jfile2path(jfile), Codec$.MODULE$.fallbackSystemCodec());
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Directory '", "' for recorder configuration does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parent.toString()})));
    }

    private RecorderConfiguration buildConfig(Config config) {
        return new RecorderConfiguration(new CoreConfiguration(config.getString(ConfigKeys$core$.MODULE$.Encoding()), this.getOutputFolder$1(config.getString(ConfigKeys$core$.MODULE$.SimulationOutputFolder())), this.getRequestBodiesFolder$1(config), config.getString(ConfigKeys$core$.MODULE$.Package()), config.getString(ConfigKeys$core$.MODULE$.ClassName()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(config.getInt(ConfigKeys$core$.MODULE$.ThresholdForPauseCreation()))).milliseconds(), config.getBoolean(ConfigKeys$core$.MODULE$.SaveConfig())), new FiltersConfiguration(FilterStrategy$.MODULE$.fromString(config.getString(ConfigKeys$filters$.MODULE$.FilterStrategy())), new WhiteList((Seq)JavaConversions$.MODULE$.asScalaBuffer(config.getStringList(ConfigKeys$filters$.MODULE$.WhitelistPatterns())).toList()), new BlackList((Seq)JavaConversions$.MODULE$.asScalaBuffer(config.getStringList(ConfigKeys$filters$.MODULE$.BlacklistPatterns())).toList())), new HttpConfiguration(config.getBoolean(ConfigKeys$http$.MODULE$.AutomaticReferer()), config.getBoolean(ConfigKeys$http$.MODULE$.FollowRedirect()), config.getBoolean(ConfigKeys$http$.MODULE$.InferHtmlResources()), config.getBoolean(ConfigKeys$http$.MODULE$.RemoveConditionalCache())), new ProxyConfiguration(config.getInt(ConfigKeys$proxy$.MODULE$.Port()), new OutgoingProxyConfiguration((Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Host()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Username()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Password()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.Port()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.SslPort()))))), new NettyConfiguration(config.getInt(ConfigKeys$netty$.MODULE$.MaxInitialLineLength()), config.getInt(ConfigKeys$netty$.MODULE$.MaxHeaderSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxChunkSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxContentLength())), config);
    }

    public RecorderConfiguration apply(CoreConfiguration core, FiltersConfiguration filters, HttpConfiguration http, ProxyConfiguration proxy, NettyConfiguration netty, Config config) {
        return new RecorderConfiguration(core, filters, http, proxy, netty, config);
    }

    public Option<Tuple6<CoreConfiguration, FiltersConfiguration, HttpConfiguration, ProxyConfiguration, NettyConfiguration, Config>> unapply(RecorderConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.core(), (Object)x$0.filters(), (Object)x$0.http(), (Object)x$0.proxy(), (Object)x$0.netty(), (Object)x$0.config()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String getOutputFolder$1(String folder) {
        String string;
        Option option = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(folder));
        if (option instanceof Some) {
            String f;
            Some some = (Some)option;
            string = f = (String)some.x();
        } else {
            string = scala.sys.package$.MODULE$.env().contains((Object)"GATLING_HOME") ? GatlingFiles$.MODULE$.sourcesDirectory().toString() : Properties$.MODULE$.userHome();
        }
        return string;
    }

    private final String getRequestBodiesFolder$1(Config config$1) {
        return config$1.hasPath(ConfigKeys$core$.MODULE$.RequestBodiesFolder()) ? config$1.getString(ConfigKeys$core$.MODULE$.RequestBodiesFolder()) : GatlingFiles$.MODULE$.requestBodiesDirectory().toString();
    }

    private RecorderConfiguration$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.Remove4SpacesRegex = new StringOps(Predef$.MODULE$.augmentString("\\s{4}")).r();
        this.RenderOptions = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
        this.configFile = None$.MODULE$;
        GatlingConfiguration$.MODULE$.setUp(GatlingConfiguration$.MODULE$.setUp$default$1());
    }
}

