/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.securechat;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.util.IO$;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.SSLContext;
import org.jboss.netty.example.securechat.SecureChatSslContextFactory$;
import org.jboss.netty.example.securechat.SecureChatTrustManagerFactory$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class SecureChatSslContextFactory$
implements StrictLogging {
    public static final SecureChatSslContextFactory$ MODULE$;
    private final String Protocol;
    private final String PropertyKeystorePath;
    private final String PropertyKeystorePassphrase;
    private final String DefaultKeyStore;
    private final String DefaultKeyStorePassphrase;
    private final SSLContext ServerContext;
    private final SSLContext ClientContext;
    private final Logger logger;

    static {
        new SecureChatSslContextFactory$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String Protocol() {
        return this.Protocol;
    }

    public String PropertyKeystorePath() {
        return this.PropertyKeystorePath;
    }

    public String PropertyKeystorePassphrase() {
        return this.PropertyKeystorePassphrase;
    }

    public String DefaultKeyStore() {
        return this.DefaultKeyStore;
    }

    public String DefaultKeyStorePassphrase() {
        return this.DefaultKeyStorePassphrase;
    }

    public SSLContext ServerContext() {
        return this.ServerContext;
    }

    public SSLContext ClientContext() {
        return this.ClientContext;
    }

    private final Option userSpecificKeyStore$1() {
        return package$.MODULE$.props().get(this.PropertyKeystorePath()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileInputStream apply(String keystorePath) {
                if (SecureChatSslContextFactory$.MODULE$.logger().underlying().isInfoEnabled()) {
                    SecureChatSslContextFactory$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading user-specified keystore: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keystorePath})));
                }
                return new FileInputStream(keystorePath);
            }
        });
    }

    public final InputStream org$jboss$netty$example$securechat$SecureChatSslContextFactory$$defaultKeyStore$1() {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading default keystore: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DefaultKeyStore()})));
        }
        return (InputStream)Option$.MODULE$.apply((Object)ClassLoader.getSystemResourceAsStream(this.DefaultKeyStore())).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<InputStream> apply() {
                return Option$.MODULE$.apply((Object)SecureChatSslContextFactory$.MODULE$.getClass().getResourceAsStream(SecureChatSslContextFactory$.MODULE$.DefaultKeyStore()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't load ", " neither from System ClassLoader nor from current one"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SecureChatSslContextFactory$.MODULE$.DefaultKeyStore()})));
            }
        });
    }

    private SecureChatSslContextFactory$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.Protocol = "TLS";
        this.PropertyKeystorePath = "gatling.recorder.keystore.path";
        this.PropertyKeystorePassphrase = "gatling.recorder.keystore.passphrase";
        this.DefaultKeyStore = "gatling.jks";
        this.DefaultKeyStorePassphrase = "gatling";
        String algorithm = (String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse((Function0)new anonfun.1());
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream keystoreStream = (InputStream)this.userSpecificKeyStore$1().getOrElse((Function0)new anonfun.2());
        String keystorePassphrase = System.getProperty(this.PropertyKeystorePassphrase(), this.DefaultKeyStorePassphrase());
        this.ServerContext = (SSLContext)IO$.MODULE$.withCloseable((Closeable)keystoreStream, (Function1)new anonfun.3(algorithm, ks, keystorePassphrase));
        SSLContext clientContext = SSLContext.getInstance(this.Protocol());
        clientContext.init(null, SecureChatTrustManagerFactory$.MODULE$.LooseTrustManagers(), null);
        this.ClientContext = clientContext;
    }
}

