/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.Base64;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.filter.Filters;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.recorder.Har$;
import io.gatling.recorder.Proxy$;
import io.gatling.recorder.RecorderMode;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.controller.RecorderController$;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.client.TimedHttpRequest;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.RecorderFrontend$;
import io.gatling.recorder.ui.RequestInfo;
import io.gatling.recorder.ui.SSLInfo;
import io.gatling.recorder.ui.TagInfo;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.SynchronizedBuffer;
import scala.collection.script.Message;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.File;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.package$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005q!B\u0001\u0003\u0011\u0003Y\u0011A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'o\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\t\u000biiA\u0011A\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007qyb\u0006\u0005\u0002\u0012;%\u0011aD\u0005\u0002\u0005+:LG\u000fC\u0003!3\u0001\u0007\u0011%A\u0003qe>\u00048\u000f\u0005\u0003#K!ZcBA\t$\u0013\t!##\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001d\u00121!T1q\u0015\t!#\u0003\u0005\u0002#S%\u0011!f\n\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005Ea\u0013BA\u0017\u0013\u0005\r\te.\u001f\u0005\b_e\u0001\n\u00111\u00011\u0003I\u0011XmY8sI\u0016\u00148i\u001c8gS\u001e4\u0015\u000e\\3\u0011\u0007E\t4'\u0003\u00023%\t1q\n\u001d;j_:\u0004\"\u0001N$\u000f\u0005U\"eB\u0001\u001cC\u001d\t9tH\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111HC\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\u0010\n\u0002\u000bQ|w\u000e\\:\n\u0005\u0001\u000b\u0015a\u00018tG*\u0011aHE\u0005\u0003\u0013\rS!\u0001Q!\n\u0005\u00153\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0013\rK!\u0001S%\u0003\t\u0019KG.\u001a\u0006\u0003\u000b\u001aCqaS\u0007\u0012\u0002\u0013\u0005A*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005i%F\u0001\u0019OW\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003%)hn\u00195fG.,GM\u0003\u0002U%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u000b&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001a!aB\u0001\u0001Y'\r9\u0006#\u0017\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000bQa\u001d7gi)T!AX0\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0001\f\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\t\f1aY8n\u0013\t!7LA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u0006/]#\tA\u001a\u000b\u0002OB\u0011Ab\u0016\u0005\bS^\u0013\r\u0011\"\u0003k\u0003!1'o\u001c8u\u000b:$W#A6\u0011\u00051|W\"A7\u000b\u00059$\u0011AA;j\u0013\t\u0001XN\u0001\tSK\u000e|'\u000fZ3s\rJ|g\u000e^3oI\"1!o\u0016Q\u0001\n-\f\u0011B\u001a:p]R,e\u000e\u001a\u0011\t\u0013Q<\u0006\u0019!a\u0001\n\u0013)\u0018!\u00029s_bLX#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e$\u0011\u0001\u00025uiBL!a\u001f=\u0003\u0013!#H\u000f\u001d)s_bL\b\"C?X\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0003%\u0001(o\u001c=z?\u0012*\u0017\u000f\u0006\u0002\u001d\u007f\"A\u0011\u0011\u0001?\u0002\u0002\u0003\u0007a/A\u0002yIEBq!!\u0002XA\u0003&a/\u0001\u0004qe>D\u0018\u0010\t\u0015\u0005\u0003\u0007\tI\u0001E\u0002\u0012\u0003\u0017I1!!\u0004\u0013\u0005!1x\u000e\\1uS2,gABA\t/\u0012\t\u0019BA\fTs:\u001c\u0007N]8oSj,G-\u0011:sCf\u0014UO\u001a4feV!\u0011QCA\u0016'\u0019\ty!a\u0006\u00028A1\u0011\u0011DA\u0012\u0003Oi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\b[V$\u0018M\u00197f\u0015\r\t\tCE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0013\u00037\u00111\"\u0011:sCf\u0014UO\u001a4feB!\u0011\u0011FA\u0016\u0019\u0001!\u0001\"!\f\u0002\u0010\t\u0007\u0011q\u0006\u0002\u0002)F\u0019\u0011\u0011G\u0016\u0011\u0007E\t\u0019$C\u0002\u00026I\u0011qAT8uQ&tw\r\u0005\u0004\u0002\u001a\u0005e\u0012qE\u0005\u0005\u0003w\tYB\u0001\nTs:\u001c\u0007N]8oSj,GMQ;gM\u0016\u0014\bbB\f\u0002\u0010\u0011\u0005\u0011q\b\u000b\u0003\u0003\u0003\u0002b!a\u0011\u0002\u0010\u0005\u001dR\"A,\t\u0013\u0005\u001dsK1A\u0005\n\u0005%\u0013aD2veJ,g\u000e\u001e*fcV,7\u000f^:\u0016\u0005\u0005-\u0003CBA\"\u0003\u001f\ti\u0005\u0005\u0004\u0002P\u0005U\u0013\u0011L\u0007\u0003\u0003#R1!a\u0015\u0005\u0003!\u00198-\u001a8be&|\u0017\u0002BA,\u0003#\u0012A\u0003V5nK\u0012\u001c6-\u001a8be&|W\t\\3nK:$\b\u0003BA(\u00037JA!!\u0018\u0002R\tq!+Z9vKN$X\t\\3nK:$\b\u0002CA1/\u0002\u0006I!a\u0013\u0002!\r,(O]3oiJ+\u0017/^3tiN\u0004\u0003\"CA3/\n\u0007I\u0011BA4\u0003-\u0019WO\u001d:f]R$\u0016mZ:\u0016\u0005\u0005%\u0004CBA\"\u0003\u001f\tY\u0007\u0005\u0004\u0002P\u0005U\u0013Q\u000e\t\u0005\u0003\u001f\ny'\u0003\u0003\u0002r\u0005E#A\u0003+bO\u0016cW-\\3oi\"A\u0011QO,!\u0002\u0013\tI'\u0001\u0007dkJ\u0014XM\u001c;UC\u001e\u001c\b\u0005C\u0004\u0002z]#\t!a\u001f\u0002\u001dM$\u0018M\u001d;SK\u000e|'\u000fZ5oOR\tA\u0004C\u0004\u0002\u0000]#\t!!!\u0002\u001bM$x\u000e\u001d*fG>\u0014H-\u001b8h)\ra\u00121\u0011\u0005\t\u0003\u000b\u000bi\b1\u0001\u0002\b\u0006!1/\u0019<f!\r\t\u0012\u0011R\u0005\u0004\u0003\u0017\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001f;F\u0011AAI\u00039\u0011XmY3jm\u0016\u0014V-];fgR$2\u0001HAJ\u0011!\t)*!$A\u0002\u0005]\u0015a\u0002:fcV,7\u000f\u001e\t\u0005\u00033\u000b\t,\u0004\u0002\u0002\u001c*\u0019\u00110!(\u000b\t\u0005}\u0015\u0011U\u0001\u0006G>$Wm\u0019\u0006\u0005\u0003G\u000b)+A\u0004iC:$G.\u001a:\u000b\t\u0005\u001d\u0016\u0011V\u0001\u0006]\u0016$H/\u001f\u0006\u0005\u0003W\u000bi+A\u0003kE>\u001c8O\u0003\u0002\u00020\u0006\u0019qN]4\n\t\u0005M\u00161\u0014\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fC\u0004\u00028^#\t!!/\u0002\u001fI,7-Z5wKJ+7\u000f]8og\u0016$R\u0001HA^\u0003\u0017D\u0001\"!&\u00026\u0002\u0007\u0011Q\u0018\t\u0005\u0003\u007f\u000b9-\u0004\u0002\u0002B*!\u00111YAc\u0003\u0019\u0019G.[3oi*\u0019\u00111\u0015=\n\t\u0005%\u0017\u0011\u0019\u0002\u0011)&lW\r\u001a%uiB\u0014V-];fgRD\u0001\"!4\u00026\u0002\u0007\u0011qZ\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011\u0011TAi\u0013\u0011\t\u0019.a'\u0003\u0019!#H\u000f\u001d*fgB|gn]3\t\u000f\u0005]w\u000b\"\u0001\u0002Z\u00061\u0011\r\u001a3UC\u001e$2\u0001HAn\u0011\u001d\ti.!6A\u0002!\nA\u0001^3yi\"9\u0011\u0011],\u0005\u0002\u0005\r\u0018\u0001E:fGV\u0014XmQ8o]\u0016\u001cG/[8o)\ra\u0012Q\u001d\u0005\t\u0003O\fy\u000e1\u0001\u0002j\u0006q1/Z2ve\u0016$\u0007j\\:u+JK\u0005\u0003BAv\u0003sl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\u0004kJL'\u0002BAb\u0003gT1!_A{\u0015\r\t90Y\u0001\u0005]&tw-\u0003\u0003\u0002|\u00065(!D+sS\u000e{W\u000e]8oK:$8\u000fC\u0004\u0002\u0000^#\t!a\u001f\u0002%\rdW-\u0019:SK\u000e|'\u000fZ3s'R\fG/\u001a")
public class RecorderController
implements StrictLogging {
    private final RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd;
    private volatile HttpProxy proxy;
    private final SynchronizedArrayBuffer<TimedScenarioElement<RequestElement>> currentRequests;
    private final SynchronizedArrayBuffer<TimedScenarioElement<TagElement>> currentTags;
    private final Logger logger;

    public static Option<File> apply$default$2() {
        return RecorderController$.MODULE$.apply$default$2();
    }

    public static void apply(Map<String, Object> map, Option<File> option) {
        RecorderController$.MODULE$.apply(map, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd() {
        return this.io$gatling$recorder$controller$RecorderController$$frontEnd;
    }

    private HttpProxy proxy() {
        return this.proxy;
    }

    private void proxy_$eq(HttpProxy x$1) {
        this.proxy = x$1;
    }

    private SynchronizedArrayBuffer<TimedScenarioElement<RequestElement>> currentRequests() {
        return this.currentRequests;
    }

    private SynchronizedArrayBuffer<TimedScenarioElement<TagElement>> currentTags() {
        return this.currentTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecording() {
        RecorderMode selectedMode = this.io$gatling$recorder$controller$RecorderController$$frontEnd().selectedMode();
        String harFilePath = this.io$gatling$recorder$controller$RecorderController$$frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        Har$ har$ = Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(har$) : har$ != null) && !package$.MODULE$.File().apply(Path$.MODULE$.string2path(harFilePath), Codec$.MODULE$.fallbackSystemCodec()).exists()) {
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleMissingHarFile(harFilePath);
            return;
        } else {
            boolean proceed;
            RecorderConfiguration config = RecorderConfiguration$.MODULE$.configuration();
            File simulationFile = package$.MODULE$.File().apply(ScenarioExporter$.MODULE$.simulationFilePath(config), Codec$.MODULE$.fallbackSystemCodec());
            boolean bl = proceed = simulationFile.exists() ? this.io$gatling$recorder$controller$RecorderController$$frontEnd().askSimulationOverwrite() : true;
            if (!proceed) return;
            RecorderMode recorderMode2 = selectedMode;
            Har$ har$2 = Har$.MODULE$;
            RecorderMode recorderMode3 = recorderMode2;
            if (!(har$2 != null ? !har$2.equals(recorderMode3) : recorderMode3 != null)) {
                Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, config);
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportFailure(errMsg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(validation instanceof Success)) throw new MatchError(validation);
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportSuccess();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                Proxy$ proxy$ = Proxy$.MODULE$;
                RecorderMode recorderMode4 = recorderMode2;
                if (proxy$ != null ? !proxy$.equals(recorderMode4) : recorderMode4 != null) throw new MatchError((Object)recorderMode2);
                this.proxy_$eq(new HttpProxy(config, this));
                this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStarted();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void stopRecording(boolean save) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStopped();
        try {
            if (this.currentRequests().isEmpty()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                }
            } else {
                RecorderConfiguration config = RecorderConfiguration$.MODULE$.configuration();
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)this.currentRequests().toVector(), (Seq<TimedScenarioElement<TagElement>>)this.currentTags().toVector(), config);
                ScenarioExporter$.MODULE$.saveScenario(scenario, config);
            }
            return;
        }
        finally {
            this.proxy().shutdown();
            this.clearRecorderState();
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
        }
    }

    public synchronized void receiveRequest(HttpRequest request) {
        Option$.MODULE$.apply((Object)request.headers().get("Proxy-Authorization")).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String header) {
                String[] credentials = new String(Base64.decode((String)header.split(" ")[1])).split(":");
                RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
                props.proxyUsername(credentials[0]);
                props.proxyPassword(credentials[1]);
                RecorderConfiguration$.MODULE$.reload(props.build());
            }
        });
    }

    public void receiveResponse(TimedHttpRequest request, HttpResponse response) {
        if (BoxesRunTime.unboxToBoolean((Object)RecorderConfiguration$.MODULE$.configuration().filters().filters().map((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final TimedHttpRequest request$1;

            public final boolean apply(Filters x$1) {
                return x$1.accept(this.request$1.httpRequest().getUri());
            }
            {
                this.request$1 = request$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }))) {
            long arrivalTime = System.currentTimeMillis();
            RequestElement requestEl = RequestElement$.MODULE$.apply(request.httpRequest(), response);
            this.currentRequests().$plus$eq(new TimedScenarioElement<RequestElement>(request.sendTime(), arrivalTime, requestEl));
            Option previousSendTime = this.currentRequests().lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(TimedScenarioElement<RequestElement> x$2) {
                    return x$2.sendTime();
                }
            });
            previousSendTime.foreach((Function1)new Serializable(this, arrivalTime){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecorderController $outer;
                private final long arrivalTime$1;

                public final void apply(long t) {
                    this.apply$mcVJ$sp(t);
                }

                public void apply$mcVJ$sp(long t) {
                    FiniteDuration delta = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.arrivalTime$1 - t)).milliseconds();
                    if (delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) {
                        this.$outer.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new PauseInfo(delta));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.arrivalTime$1 = arrivalTime$1;
                }
            });
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new RequestInfo(request.httpRequest(), response));
        }
    }

    public void addTag(String text) {
        long now = System.currentTimeMillis();
        this.currentTags().$plus$eq(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new TagInfo(text));
    }

    public void secureConnection(UriComponents securedHostURI) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new SSLInfo(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.currentRequests().clear();
        this.currentTags().clear();
    }

    public RecorderController() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.io$gatling$recorder$controller$RecorderController$$frontEnd = RecorderFrontend$.MODULE$.newFrontend(this);
        this.currentRequests = new SynchronizedArrayBuffer();
        this.currentTags = new SynchronizedArrayBuffer();
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
    }

    public class SynchronizedArrayBuffer<T>
    extends ArrayBuffer<T>
    implements SynchronizedBuffer<T> {
        public int scala$collection$mutable$SynchronizedBuffer$$super$length() {
            return ResizableArray.class.length((ResizableArray)this);
        }

        public Iterator scala$collection$mutable$SynchronizedBuffer$$super$iterator() {
            return IndexedSeqLike.class.iterator((IndexedSeqLike)this);
        }

        public Object scala$collection$mutable$SynchronizedBuffer$$super$apply(int n) {
            return ResizableArray.class.apply((ResizableArray)this, (int)n);
        }

        public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq(Object elem) {
            return (SynchronizedBuffer)super.$plus$eq(elem);
        }

        public Buffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus(GenTraversableOnce xs) {
            return BufferLike.class.$plus$plus((Buffer)this, (GenTraversableOnce)xs);
        }

        public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq(TraversableOnce xs) {
            return (SynchronizedBuffer)super.$plus$plus$eq(xs);
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$appendAll(TraversableOnce xs) {
            BufferLike.class.appendAll((Buffer)this, (TraversableOnce)xs);
        }

        public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq$colon(Object elem) {
            return (SynchronizedBuffer)super.$plus$eq$colon(elem);
        }

        public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq$colon(TraversableOnce xs) {
            return (SynchronizedBuffer)super.$plus$plus$eq$colon(xs);
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$prependAll(TraversableOnce xs) {
            BufferLike.class.prependAll((Buffer)this, (TraversableOnce)xs);
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$insertAll(int n, Traversable elems) {
            super.insertAll(n, elems);
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$update(int n, Object newelem) {
            ResizableArray.class.update((ResizableArray)this, (int)n, (Object)newelem);
        }

        public Object scala$collection$mutable$SynchronizedBuffer$$super$remove(int n) {
            return super.remove(n);
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$clear() {
            super.clear();
        }

        public void scala$collection$mutable$SynchronizedBuffer$$super$$less$less(Message cmd) {
            BufferLike.class.$less$less((Buffer)this, (Message)cmd);
        }

        public Buffer scala$collection$mutable$SynchronizedBuffer$$super$clone() {
            return BufferLike.class.clone((Buffer)this);
        }

        public int scala$collection$mutable$SynchronizedBuffer$$super$hashCode() {
            return IndexedSeqLike.class.hashCode((IndexedSeqLike)this);
        }

        public int length() {
            return SynchronizedBuffer.class.length((SynchronizedBuffer)this);
        }

        public Iterator<T> iterator() {
            return SynchronizedBuffer.class.iterator((SynchronizedBuffer)this);
        }

        public T apply(int n) {
            return (T)SynchronizedBuffer.class.apply((SynchronizedBuffer)this, (int)n);
        }

        public SynchronizedBuffer<T> $plus$eq(T elem) {
            return SynchronizedBuffer.class.$plus$eq((SynchronizedBuffer)this, elem);
        }

        public Buffer<T> $plus$plus(GenTraversableOnce<T> xs) {
            return SynchronizedBuffer.class.$plus$plus((SynchronizedBuffer)this, xs);
        }

        public SynchronizedBuffer<T> $plus$plus$eq(TraversableOnce<T> xs) {
            return SynchronizedBuffer.class.$plus$plus$eq((SynchronizedBuffer)this, xs);
        }

        public void append(Seq<T> elems) {
            SynchronizedBuffer.class.append((SynchronizedBuffer)this, elems);
        }

        public void appendAll(TraversableOnce<T> xs) {
            SynchronizedBuffer.class.appendAll((SynchronizedBuffer)this, xs);
        }

        public SynchronizedBuffer<T> $plus$eq$colon(T elem) {
            return SynchronizedBuffer.class.$plus$eq$colon((SynchronizedBuffer)this, elem);
        }

        public SynchronizedBuffer<T> $plus$plus$eq$colon(TraversableOnce<T> xs) {
            return SynchronizedBuffer.class.$plus$plus$eq$colon((SynchronizedBuffer)this, xs);
        }

        public void prepend(Seq<T> elems) {
            SynchronizedBuffer.class.prepend((SynchronizedBuffer)this, elems);
        }

        public void prependAll(TraversableOnce<T> xs) {
            SynchronizedBuffer.class.prependAll((SynchronizedBuffer)this, xs);
        }

        public void insert(int n, Seq<T> elems) {
            SynchronizedBuffer.class.insert((SynchronizedBuffer)this, (int)n, elems);
        }

        public void insertAll(int n, Traversable<T> xs) {
            SynchronizedBuffer.class.insertAll((SynchronizedBuffer)this, (int)n, xs);
        }

        public void update(int n, T newelem) {
            SynchronizedBuffer.class.update((SynchronizedBuffer)this, (int)n, newelem);
        }

        public T remove(int n) {
            return (T)SynchronizedBuffer.class.remove((SynchronizedBuffer)this, (int)n);
        }

        public void clear() {
            SynchronizedBuffer.class.clear((SynchronizedBuffer)this);
        }

        public void $less$less(Message<T> cmd) {
            SynchronizedBuffer.class.$less$less((SynchronizedBuffer)this, cmd);
        }

        public Buffer<T> clone() {
            return SynchronizedBuffer.class.clone((SynchronizedBuffer)this);
        }

        public int hashCode() {
            return SynchronizedBuffer.class.hashCode((SynchronizedBuffer)this);
        }

        public /* synthetic */ RecorderController io$gatling$recorder$controller$RecorderController$SynchronizedArrayBuffer$$$outer() {
            return RecorderController.this;
        }

        public SynchronizedArrayBuffer() {
            if (RecorderController.this == null) {
                throw new NullPointerException();
            }
            SynchronizedBuffer.class.$init$((SynchronizedBuffer)this);
        }
    }
}

