/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.util.IO$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Validation;
import io.gatling.core.validation.package;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.har.HarReader$;
import io.gatling.recorder.scenario.ProtocolDefinition;
import io.gatling.recorder.scenario.ProtocolDefinition$;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioElement;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.template.SimulationTemplate$;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.io.Directory;
import scala.reflect.io.File;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ScenarioExporter$
implements StrictLogging {
    public static final ScenarioExporter$ MODULE$;
    private final int EventsGrouping;
    private final Logger logger;

    static {
        new ScenarioExporter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int EventsGrouping() {
        return this.EventsGrouping;
    }

    public Path simulationFilePath(RecorderConfiguration config) {
        return this.getOutputFolder$1(config).$div(Path$.MODULE$.string2path(this.getSimulationFileName$1(config)));
    }

    public Validation<BoxedUnit> exportScenario(String harFilePath, RecorderConfiguration config) {
        Failure failure;
        try {
            ScenarioDefinition har = HarReader$.MODULE$.apply(harFilePath, config);
            if (har.elements().isEmpty()) {
                failure = package.FailureWrapper$.MODULE$.failure$extension(io.gatling.core.validation.package$.MODULE$.FailureWrapper("the selected file doesn't contain any valid HTTP requests"));
            } else {
                this.saveScenario(har, config);
                failure = package.SuccessWrapper$.MODULE$.success$extension(io.gatling.core.validation.package$.MODULE$.SuccessWrapper((Object)BoxedUnit.UNIT));
            }
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error while processing HAR file", (Throwable)exception);
            }
            failure = package.FailureWrapper$.MODULE$.failure$extension(io.gatling.core.validation.package$.MODULE$.FailureWrapper(exception.getMessage()));
        }
        return failure;
    }

    public void saveScenario(ScenarioDefinition scenarioElements, RecorderConfiguration config) {
        Predef$.MODULE$.require(!scenarioElements.isEmpty());
        String output = this.renderScenarioAndDumpBodies(scenarioElements, config);
        IO$.MODULE$.withCloseable((Closeable)new FileOutputStream(scala.tools.nsc.io.package$.MODULE$.File().apply(this.simulationFilePath(config), Codec$.MODULE$.fallbackSystemCodec()).jfile()), (Function1)new Serializable(config, output){
            public static final long serialVersionUID = 0L;
            private final RecorderConfiguration config$2;
            private final String output$1;

            public final void apply(FileOutputStream x$1) {
                x$1.write(this.output$1.getBytes(this.config$2.core().encoding()));
            }
            {
                this.config$2 = config$2;
                this.output$1 = output$1;
            }
        });
    }

    private String renderScenarioAndDumpBodies(ScenarioDefinition scenario, RecorderConfiguration config) {
        Set filteredHeaders = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.Cookie(), HeaderNames$.MODULE$.ContentLength(), HeaderNames$.MODULE$.Host()}))).$plus$plus((GenTraversableOnce)(config.http().automaticReferer() ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.Referer()})) : Predef$.MODULE$.Set().empty()));
        Seq<ScenarioElement> scenarioElements = scenario.elements();
        Seq mainRequestElements = (Seq)scenarioElements.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScenarioElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)A1;
                    object = requestElement;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScenarioElement x1) {
                ScenarioElement scenarioElement = x1;
                boolean bl = scenarioElement instanceof RequestElement;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq requestElements = (Seq)mainRequestElements.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<RequestElement> apply(RequestElement req) {
                RequestElement requestElement = req;
                return req.nonEmbeddedResources().$colon$colon((Object)requestElement);
            }
        }, Seq$.MODULE$.canBuildFrom());
        String baseUrl = this.getBaseUrl((Seq<RequestElement>)mainRequestElements);
        Map<String, String> baseHeaders = this.getBaseHeaders((Seq<RequestElement>)requestElements);
        ProtocolDefinition protocolConfigElement = new ProtocolDefinition(baseUrl, baseHeaders);
        Seq elements = (Seq)scenarioElements.map((Function1)new Serializable(baseUrl){
            public static final long serialVersionUID = 0L;
            private final String baseUrl$1;

            public final ScenarioElement apply(ScenarioElement x0$1) {
                ScenarioElement scenarioElement;
                ScenarioElement scenarioElement2 = x0$1;
                if (scenarioElement2 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)scenarioElement2;
                    scenarioElement = requestElement.makeRelativeTo(this.baseUrl$1);
                } else {
                    scenarioElement = scenarioElement2;
                }
                return scenarioElement;
            }
            {
                this.baseUrl$1 = baseUrl$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)requestElements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RequestElement apply(Tuple2<RequestElement, Object> x0$2) {
                Tuple2<RequestElement, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    RequestElement reqEl = (RequestElement)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    RequestElement requestElement = reqEl.setId(index);
                    return requestElement;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        requestElements.foreach((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            public final RecorderConfiguration config$3;

            public final void apply(RequestElement el) {
                el.body().foreach((Function1)new Serializable(this, el){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.renderScenarioAndDumpBodies.2 $outer;
                    private final RequestElement el$1;

                    public final void apply(RequestBody x0$3) {
                        RequestBody requestBody = x0$3;
                        if (requestBody instanceof RequestBodyBytes) {
                            RequestBodyBytes requestBodyBytes = (RequestBodyBytes)requestBody;
                            byte[] bytes = requestBodyBytes.bytes();
                            ScenarioExporter$.MODULE$.io$gatling$recorder$scenario$ScenarioExporter$$dumpRequestBody(this.el$1.id(), bytes, this.$outer.config$3.core().className(), this.$outer.config$3);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.el$1 = el$1;
                    }
                });
            }
            {
                this.config$3 = config$3;
            }
        });
        Map headers = (Map)SortedMap$.MODULE$.apply(this.generateHeaders$1(requestElements, Predef$.MODULE$.Map().empty(), filteredHeaders, baseHeaders).toSeq(), (Ordering)Ordering.Int$.MODULE$);
        Either<Seq<ScenarioElement>, List<Seq<ScenarioElement>>> newScenarioElements = this.getChains((Seq<ScenarioElement>)elements);
        return SimulationTemplate$.MODULE$.render(config.core().pkg(), config.core().className(), protocolConfigElement, (Map<Object, Seq<Tuple2<String, String>>>)headers, config.core().className(), newScenarioElements, config);
    }

    private Map<String, String> getBaseHeaders(Seq<RequestElement> requestElements) {
        return this.resolveBaseHeaders$1(Predef$.MODULE$.Map().empty(), ProtocolDefinition$.MODULE$.baseHeaders().keySet().toList(), requestElements);
    }

    private String getBaseUrl(Seq<RequestElement> requestElements) {
        Seq urlsOccurrences = ((TraversableLike)requestElements.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RequestElement x$8) {
                return x$8.baseUrl();
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$9) {
                return x$9.size();
            }
        }).toSeq();
        return (String)((Tuple2)urlsOccurrences.maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$10) {
                return x$10._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private Either<Seq<ScenarioElement>, List<Seq<ScenarioElement>>> getChains(Seq<ScenarioElement> scenarioElements) {
        return scenarioElements.size() > this.EventsGrouping() ? package$.MODULE$.Right().apply((Object)scenarioElements.grouped(this.EventsGrouping()).toList()) : package$.MODULE$.Left().apply(scenarioElements);
    }

    public void io$gatling$recorder$scenario$ScenarioExporter$$dumpRequestBody(int idEvent, byte[] content, String simulationClass, RecorderConfiguration config) {
        String arg$1 = simulationClass;
        int arg$2 = idEvent;
        String fileName = new StringOps(Predef$.MODULE$.augmentString("%s_request_%04d.txt")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, BoxesRunTime.boxToInteger((int)arg$2)}));
        File qual$2 = scala.tools.nsc.io.package$.MODULE$.File().apply(this.getFolder(config.core().requestBodiesFolder()).$div(Path$.MODULE$.string2path(fileName)), Codec$.MODULE$.fallbackSystemCodec());
        boolean x$13 = qual$2.outputStream$default$1();
        IO$.MODULE$.withCloseable((Closeable)qual$2.outputStream(x$13), (Function1)new Serializable(content){
            public static final long serialVersionUID = 0L;
            private final byte[] content$1;

            public final void apply(FileOutputStream fw) {
                block2: {
                    try {
                        fw.write(this.content$1);
                    }
                    catch (IOException iOException) {
                        if (!ScenarioExporter$.MODULE$.logger().underlying().isErrorEnabled()) break block2;
                        ScenarioExporter$.MODULE$.logger().underlying().error("Error, while dumping request body...", (Throwable)iOException);
                    }
                }
            }
            {
                this.content$1 = content$1;
            }
        });
    }

    private Directory getFolder(String folderPath) {
        Directory qual$1 = scala.tools.nsc.io.package$.MODULE$.Directory().apply(Path$.MODULE$.string2path(folderPath));
        boolean x$11 = qual$1.createDirectory$default$1();
        boolean x$12 = qual$1.createDirectory$default$2();
        return qual$1.createDirectory(x$11, x$12);
    }

    private final String getSimulationFileName$1(RecorderConfiguration config$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config$1.core().className()}));
    }

    private final Directory getOutputFolder$1(RecorderConfiguration config$1) {
        String path = new StringBuilder().append((Object)config$1.core().outputFolder()).append((Object)scala.tools.nsc.io.package$.MODULE$.File().separator()).append((Object)config$1.core().pkg().replace(".", scala.tools.nsc.io.package$.MODULE$.File().separator())).toString();
        return this.getFolder(path);
    }

    private final Map generateHeaders$1(Seq elements, Map headers, Set filteredHeaders$1, Map baseHeaders$1) {
        while (true) {
            Map newHeaders;
            Map map;
            Seq seq;
            Some some;
            if (!(some = Seq$.MODULE$.unapplySeq(seq = elements)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                Map map2 = headers;
                return map2;
            }
            Option option = package$.MODULE$.$plus$colon().unapply((SeqLike)seq);
            if (option.isEmpty()) {
                throw new MatchError((Object)seq);
            }
            RequestElement element = (RequestElement)((Tuple2)option.get())._1();
            Seq others = (Seq)((Tuple2)option.get())._2();
            List acceptedHeaders = (List)((SeqLike)element.headers().toList().filterNot((Function1)new Serializable(filteredHeaders$1, baseHeaders$1, element){
                public static final long serialVersionUID = 0L;
                private final Set filteredHeaders$1;
                private final Map baseHeaders$1;
                private final RequestElement element$1;

                /*
                 * Unable to fully structure code
                 */
                public final boolean apply(Tuple2<String, String> x0$4) {
                    block2: {
                        var2_2 = x0$4;
                        if (var2_2 == null) break block2;
                        headerName = (String)var2_2._1();
                        headerValue = (String)var2_2._2();
                        isFiltered = this.filteredHeaders$1.contains((Object)headerName);
                        isAlreadyInBaseHeaders = this.baseHeaders$1.get((Object)headerName).exists((Function1)new Serializable(this, headerValue){
                            public static final long serialVersionUID = 0L;
                            private final String headerValue$1;

                            public final boolean apply(String x$3) {
                                String string = x$3;
                                String string2 = this.headerValue$1;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                this.headerValue$1 = headerValue$1;
                            }
                        });
                        v0 = this.element$1.method();
                        var9_7 = "POST";
                        if (v0 != null ? v0.equals(var9_7) == false : var9_7 != null) ** GOTO lbl-1000
                        v1 = headerValue;
                        var10_8 = HeaderValues$.MODULE$.ApplicationFormUrlEncoded();
                        if (!(v1 != null ? v1.equals(var10_8) == false : var10_8 != null)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        isPostWithFormParams = v2;
                        var5_10 = isFiltered != false || isAlreadyInBaseHeaders != false || isPostWithFormParams != false;
                        return var5_10;
                    }
                    throw new MatchError(var2_2);
                }
                {
                    this.filteredHeaders$1 = filteredHeaders$1;
                    this.baseHeaders$1 = baseHeaders$1;
                    this.element$1 = element$1;
                }
            })).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x$4) {
                    return (String)x$4._1();
                }
            }, (Ordering)Ordering.String$.MODULE$);
            if (acceptedHeaders.isEmpty()) {
                element.filteredHeadersId_$eq((Option<Object>)None$.MODULE$);
                map = headers;
            } else {
                Seq headersSeq = headers.toSeq();
                int n = headersSeq.indexWhere((Function1)new anonfun.7(acceptedHeaders));
                switch (n) {
                    default: {
                        element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((Tuple2)headersSeq.apply(n))._1$mcI$sp())));
                        map = headers;
                        break;
                    }
                    case -1: {
                        element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)element.id())));
                        map = headers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)element.id())), (Object)acceptedHeaders));
                    }
                }
            }
            headers = newHeaders = map;
            elements = others;
        }
    }

    private final Option getMostFrequentHeaderValue$1(String headerName, Seq requestElements$1) {
        None$ none$;
        Seq headers = (Seq)requestElements$1.flatMap((Function1)new Serializable(headerName){
            public static final long serialVersionUID = 0L;
            public final String headerName$1;

            public final Iterable<String> apply(RequestElement x$5) {
                return (Iterable)x$5.headers().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.8 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 != null) {
                            String name = (String)A1._1();
                            String value = (String)A1._2();
                            String string = name;
                            String string2 = this.$outer.headerName$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                object = value;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x2);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<String, String> x2) {
                        String name;
                        Tuple2<String, String> tuple2 = x2;
                        if (tuple2 == null) return false;
                        String string = name = (String)tuple2._1();
                        String string2 = this.$outer.headerName$1;
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.headerName$1 = headerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (headers.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq headersValuesOccurrences = headers.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Seq<String> x$6) {
                    return x$6.size();
                }
            }).toSeq();
            String mostFrequentValue = (String)((Tuple2)headersValuesOccurrences.maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, Object> x$7) {
                    return x$7._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$))._1();
            none$ = new Some((Object)mostFrequentValue);
        }
        return none$;
    }

    private final Map addHeader$1(Map appendTo, String headerName, Seq requestElements$1) {
        return (Map)this.getMostFrequentHeaderValue$1(headerName, requestElements$1).map((Function1)new Serializable(appendTo, headerName){
            public static final long serialVersionUID = 0L;
            private final Map appendTo$1;
            private final String headerName$2;

            public final Map<String, String> apply(String headerValue) {
                return this.appendTo$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.headerName$2), (Object)headerValue));
            }
            {
                this.appendTo$1 = appendTo$1;
                this.headerName$2 = headerName$2;
            }
        }).getOrElse((Function0)new Serializable(appendTo){
            public static final long serialVersionUID = 0L;
            private final Map appendTo$1;

            public final Map<String, String> apply() {
                return this.appendTo$1;
            }
            {
                this.appendTo$1 = appendTo$1;
            }
        });
    }

    private final Map resolveBaseHeaders$1(Map headers, List headerNames, Seq requestElements$1) {
        List list;
        while (true) {
            List others;
            list = headerNames;
            Nil$ nil$ = Nil$.MODULE$;
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                Map map = headers;
                return map;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String headerName = (String)colon2.hd$1();
            headerNames = others = colon2.tl$1();
            headers = this.addHeader$1(headers, headerName, requestElements$1);
        }
        throw new MatchError((Object)list);
    }

    private ScenarioExporter$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.EventsGrouping = 100;
    }
}

