/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.handler.remote;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.channel.BootstrapFactory$;
import io.gatling.recorder.http.handler.ScalaChannelHandler;
import io.gatling.recorder.http.handler.ScalaChannelHandler$class;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.handler.user.SslHandlerSetter;
import io.gatling.recorder.http.ssl.SSLEngineFactory$;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\ti!+Z7pi\u0016D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\rI,Wn\u001c;f\u0015\t)a!A\u0004iC:$G.\u001a:\u000b\u0005\u001dA\u0011\u0001\u00025uiBT!!\u0003\u0006\u0002\u0011I,7m\u001c:eKJT!a\u0003\u0007\u0002\u000f\u001d\fG\u000f\\5oO*\tQ\"\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u00119\u0001\u0002\"!\u0005\u000e\u000e\u0003IQ!a\u0005\u000b\u0002\u000f\rD\u0017M\u001c8fY*\u0011QCF\u0001\u0006]\u0016$H/\u001f\u0006\u0003/a\tQA\u001b2pgNT\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0013\u0005Q\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7feB\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\u0014'\u000e\fG.Y\"iC:tW\r\u001c%b]\u0012dWM\u001d\t\u0003C)j\u0011A\t\u0006\u0003G\u0011\nQa\u001d7gi)T!!\n\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u001dB\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\n1aY8n\u0013\tY#EA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005Q1m\u001c8ue>dG.\u001a:\u0011\u0005=\nT\"\u0001\u0019\u000b\u00055B\u0011B\u0001\u001a1\u0005I\u0011VmY8sI\u0016\u00148i\u001c8ue>dG.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\n1\"^:fe\u000eC\u0017M\u001c8fYB\u0011\u0011CN\u0005\u0003oI\u0011qa\u00115b]:,G\u000e\u0003\u0005:\u0001\t\u0005\r\u0011\"\u0001;\u00039\u0001XM\u001d4pe6\u001cuN\u001c8fGR,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b\u0005>|G.Z1o\u0011!\u0011\u0005A!a\u0001\n\u0003\u0019\u0015A\u00059fe\u001a|'/\\\"p]:,7\r^0%KF$\"\u0001R$\u0011\u0005q*\u0015B\u0001$>\u0005\u0011)f.\u001b;\t\u000f!\u000b\u0015\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\t\u0011)\u0003!\u0011!Q!\nm\nq\u0002]3sM>\u0014XnQ8o]\u0016\u001cG\u000f\t\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005w\u0005I!/Z2p]:,7\r\u001e\u0005\u0006\u001d\u0002!\taT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bA\u00136\u000bV+\u0011\u0005E\u0003Q\"\u0001\u0002\t\u000b5j\u0005\u0019\u0001\u0018\t\u000bQj\u0005\u0019A\u001b\t\u000bej\u0005\u0019A\u001e\t\u000b1k\u0005\u0019A\u001e\t\u000b]\u0003A\u0011\t-\u0002\u001f5,7o]1hKJ+7-Z5wK\u0012$2\u0001R-_\u0011\u0015Qf\u000b1\u0001\\\u0003\r\u0019G\u000f\u001f\t\u0003#qK!!\u0018\n\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")qL\u0016a\u0001A\u0006)QM^3oiB\u0011\u0011#Y\u0005\u0003EJ\u0011A\"T3tg\u0006<W-\u0012<f]R\u0004")
public class RemoteHandler
extends SimpleChannelHandler
implements ScalaChannelHandler,
StrictLogging {
    private final RecorderController controller;
    public final Channel io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel;
    private boolean performConnect;
    private final boolean reconnect;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Object function2ChannelFutureListener(Function1<ChannelFuture, Object> thunk) {
        return ScalaChannelHandler$class.function2ChannelFutureListener(this, thunk);
    }

    @Override
    public HttpRequest copyRequestWithNewUri(HttpRequest request, String uri) {
        return ScalaChannelHandler$class.copyRequestWithNewUri(this, request, uri);
    }

    public boolean performConnect() {
        return this.performConnect;
    }

    public void performConnect_$eq(boolean x$1) {
        this.performConnect = x$1;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object object = event.getMessage();
        if (object instanceof HttpResponse) {
            BoxedUnit boxedUnit;
            HttpResponse httpResponse = (HttpResponse)object;
            if (this.performConnect()) {
                this.handleConnect$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.handleRequest$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof HttpChunk) {
            BoxedUnit boxedUnit;
            HttpChunk httpChunk = (HttpChunk)object;
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response chunk to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)httpChunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response chunk to disconnected user channel ", ", ignoring"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        }
    }

    private final void upgradeRemotePipeline$1(ChannelPipeline remotePipeline, SslHandler clientSslHandler) {
        remotePipeline.replace(BootstrapFactory$.MODULE$.CodecHandlerName(), BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec());
        remotePipeline.addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)clientSslHandler);
    }

    private final void handleConnect$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        HttpResponseStatus httpResponseStatus = response.getStatus();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (!(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null)) {
            this.performConnect_$eq(false);
            SslHandler remoteSslHandler = new SslHandler(SSLEngineFactory$.MODULE$.newClientSSLEngine());
            this.upgradeRemotePipeline$1(ctx$1.getChannel().getPipeline(), remoteSslHandler);
            if (!this.reconnect) {
                remoteSslHandler.handshake().addListener(this.function2ChannelFutureListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RemoteHandler $outer;

                    public final ChannelFuture apply(ChannelFuture handshakeFuture) {
                        this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getPipeline().addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)new SslHandlerSetter());
                        return this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            return;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Outgoing proxy refused to connect: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.getStatus()})));
    }

    private final void handleRequest$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        Object object = ctx$1.getAttachment();
        if (object instanceof TimedHttpRequest) {
            BoxedUnit boxedUnit;
            TimedHttpRequest timedHttpRequest = (TimedHttpRequest)object;
            this.controller.receiveResponse(timedHttpRequest, response);
            ctx$1.setAttachment(null);
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)response);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response to disconnected user channel ", ", aborting request:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId(), timedHttpRequest.httpRequest().getUri()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new IllegalStateException("Couldn't find request attachment");
    }

    public RemoteHandler(RecorderController controller, Channel userChannel, boolean performConnect, boolean reconnect) {
        this.controller = controller;
        this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel = userChannel;
        this.performConnect = performConnect;
        this.reconnect = reconnect;
        ScalaChannelHandler$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

