/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.channel;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.user.PortUnificationUserHandler;
import io.gatling.recorder.http.ssl.SSLClientContext$;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BootstrapFactory$
implements StrictLogging {
    public static final BootstrapFactory$ MODULE$;
    private final String CodecHandlerName;
    private final String SslHandlerName;
    private final String GatlingHandlerName;
    private final String PortUnificationServerHandler;
    private final Logger logger;

    static {
        new BootstrapFactory$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String CodecHandlerName() {
        return this.CodecHandlerName;
    }

    public String SslHandlerName() {
        return this.SslHandlerName;
    }

    public String GatlingHandlerName() {
        return this.GatlingHandlerName;
    }

    public String PortUnificationServerHandler() {
        return this.PortUnificationServerHandler;
    }

    /*
     * WARNING - void declaration
     */
    public ClientBootstrap newRemoteBootstrap(boolean ssl, RecorderConfiguration config) {
        void var3_3;
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory());
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(ssl, config){
            private final boolean ssl$1;
            private final RecorderConfiguration config$1;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                BoxedUnit boxedUnit;
                if (BootstrapFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                    BootstrapFactory$.MODULE$.logger().underlying().debug("Open new remote channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ChannelPipeline pipeline = Channels.pipeline();
                if (this.ssl$1) {
                    pipeline.addLast(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)new SslHandler(SSLClientContext$.MODULE$.createSSLEngine()));
                }
                pipeline.addLast(BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec(this.config$1.netty().maxInitialLineLength(), this.config$1.netty().maxHeaderSize(), this.config$1.netty().maxChunkSize()));
                pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.config$1.netty().maxContentLength()));
                return var1_1;
            }
            {
                this.ssl$1 = ssl$1;
                this.config$1 = config$1;
            }
        });
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ServerBootstrap newUserBootstrap(HttpProxy proxy, RecorderConfiguration config) {
        void var3_3;
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory());
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(proxy, config){
            private final HttpProxy proxy$1;
            private final RecorderConfiguration config$2;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                BoxedUnit boxedUnit;
                if (BootstrapFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                    BootstrapFactory$.MODULE$.logger().underlying().debug("Open new user channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.config$2.netty().maxInitialLineLength(), this.config$2.netty().maxHeaderSize(), this.config$2.netty().maxChunkSize()));
                pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.config$2.netty().maxContentLength()));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
                pipeline.addLast(BootstrapFactory$.MODULE$.PortUnificationServerHandler(), (ChannelHandler)new PortUnificationUserHandler(this.proxy$1, pipeline));
                return var1_1;
            }
            {
                this.proxy$1 = proxy$1;
                this.config$2 = config$2;
            }
        });
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var3_3;
    }

    private BootstrapFactory$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.CodecHandlerName = "codec";
        this.SslHandlerName = "ssl";
        this.GatlingHandlerName = "gatling";
        this.PortUnificationServerHandler = "port-unification";
    }
}

