/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import io.gatling.core.util.PathHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.ssl.HttpsMode;
import io.gatling.recorder.http.ssl.HttpsMode$CertificateAuthority$;
import io.gatling.recorder.http.ssl.HttpsMode$ProvidedKeyStore$;
import io.gatling.recorder.http.ssl.HttpsMode$SelfSignedCertificate$;
import io.gatling.recorder.http.ssl.KeyStoreType;
import io.gatling.recorder.http.ssl.KeyStoreType$JKS$;
import io.gatling.recorder.http.ssl.SSLServerContext;
import io.gatling.recorder.http.ssl.SSLServerContext$SelfSignedCertificate$;
import java.io.File;
import java.security.Security;
import scala.Function0;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;

public final class SSLServerContext$ {
    public static final SSLServerContext$ MODULE$;
    private final String GatlingSelfSignedKeyStore;
    private final KeyStoreType$JKS$ GatlingKeyStoreType;
    private final String GatlingPassword;
    private final String GatlingCAKeyFile;
    private final String GatlingCACrtFile;
    private final String Algorithm;
    private final String Protocol;

    static {
        new SSLServerContext$();
    }

    public String GatlingSelfSignedKeyStore() {
        return this.GatlingSelfSignedKeyStore;
    }

    public KeyStoreType$JKS$ GatlingKeyStoreType() {
        return this.GatlingKeyStoreType;
    }

    public String GatlingPassword() {
        return this.GatlingPassword;
    }

    public String GatlingCAKeyFile() {
        return this.GatlingCAKeyFile;
    }

    public String GatlingCACrtFile() {
        return this.GatlingCACrtFile;
    }

    public String Algorithm() {
        return this.Algorithm;
    }

    public String Protocol() {
        return this.Protocol;
    }

    public SSLServerContext apply(RecorderConfiguration config) {
        HttpsMode httpsMode;
        block5: {
            SSLServerContext sSLServerContext;
            block3: {
                block4: {
                    block2: {
                        httpsMode = config.proxy().https().mode();
                        if (!HttpsMode$SelfSignedCertificate$.MODULE$.equals(httpsMode)) break block2;
                        sSLServerContext = SSLServerContext$SelfSignedCertificate$.MODULE$;
                        break block3;
                    }
                    if (!HttpsMode$ProvidedKeyStore$.MODULE$.equals(httpsMode)) break block4;
                    File ksFile = new File(config.proxy().https().keyStore().path());
                    KeyStoreType keyStoreType = config.proxy().https().keyStore().keyStoreType();
                    char[] password = config.proxy().https().keyStore().password().toCharArray();
                    sSLServerContext = new SSLServerContext.ProvidedKeystore(ksFile, keyStoreType, password);
                    break block3;
                }
                if (!HttpsMode$CertificateAuthority$.MODULE$.equals(httpsMode)) break block5;
                sSLServerContext = new SSLServerContext.CertificateAuthority(PathHelper$.MODULE$.string2path(config.proxy().https().certificateAuthority().certificatePath()), PathHelper$.MODULE$.string2path(config.proxy().https().certificateAuthority().privateKeyPath()));
            }
            return sSLServerContext;
        }
        throw new MatchError((Object)httpsMode);
    }

    private SSLServerContext$() {
        MODULE$ = this;
        this.GatlingSelfSignedKeyStore = "gatling.jks";
        this.GatlingKeyStoreType = KeyStoreType$JKS$.MODULE$;
        this.GatlingPassword = "gatling";
        this.GatlingCAKeyFile = "gatlingCA.key.pem";
        this.GatlingCACrtFile = "gatlingCA.cert.pem";
        this.Algorithm = (String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse((Function0)new Serializable(){

            public final String apply() {
                return "SunX509";
            }
        });
        this.Protocol = "TLS";
    }
}

