/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.ning.http.client.uri.Uri;
import com.ning.http.util.Base64;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.filter.Filters;
import io.gatling.core.util.PathHelper;
import io.gatling.core.util.PathHelper$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.recorder.RecorderMode;
import io.gatling.recorder.RecorderMode$Har$;
import io.gatling.recorder.RecorderMode$Proxy$;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.controller.RecorderController$;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.RecorderFrontend$;
import io.gatling.recorder.ui.RequestInfo;
import io.gatling.recorder.ui.SSLInfo;
import io.gatling.recorder.ui.TagInfo;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dw!B\u0001\u0003\u0011\u0003Y\u0011A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'o\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\t\u000biiA\u0011A\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007qy2\u0007\u0005\u0002\u0012;%\u0011aD\u0005\u0002\u0005+:LG\u000fC\u0003!3\u0001\u0007\u0011%A\u0003qe>\u00048\u000f\u0005\u0003#O%\u0002T\"A\u0012\u000b\u0005\u0011*\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003MI\t!bY8mY\u0016\u001cG/[8o\u0013\tA3EA\u0002NCB\u0004\"AK\u0017\u000f\u0005EY\u0013B\u0001\u0017\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u0012\u0002CA\t2\u0013\t\u0011$CA\u0002B]fDq\u0001N\r\u0011\u0002\u0003\u0007Q'\u0001\nsK\u000e|'\u000fZ3s\u0007>tg-[4GS2,\u0007cA\t7q%\u0011qG\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00024jY\u0016T!!\u0010 \u0002\u00079LwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005S$\u0001\u0002)bi\"DqaQ\u0007\u0012\u0002\u0013\u0005A)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005)%FA\u001bGW\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003%)hn\u00195fG.,GM\u0003\u0002M%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059K%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001a!aB\u0001\u0001Q'\ry\u0005#\u0015\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000bAb]2bY\u0006dwnZ4j]\u001eT!AV,\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001W\u0001\u0004G>l\u0017B\u0001.T\u00055\u0019FO]5di2{wmZ5oO\")qc\u0014C\u00019R\tQ\f\u0005\u0002\r\u001f\"9ql\u0014b\u0001\n\u0013\u0001\u0017\u0001\u00034s_:$XI\u001c3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0003\u0002\u0005UL\u0017B\u00014d\u0005A\u0011VmY8sI\u0016\u0014hI]8oi\u0016tG\r\u0003\u0004i\u001f\u0002\u0006I!Y\u0001\nMJ|g\u000e^#oI\u0002B\u0011B[(A\u0002\u0003\u0007I\u0011B6\u0002\u000bA\u0014x\u000e_=\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0003\u0002\t!$H\u000f]\u0005\u0003c:\u0014\u0011\u0002\u0013;uaB\u0013x\u000e_=\t\u0013M|\u0005\u0019!a\u0001\n\u0013!\u0018!\u00039s_bLx\fJ3r)\taR\u000fC\u0004we\u0006\u0005\t\u0019\u00017\u0002\u0007a$\u0013\u0007\u0003\u0004y\u001f\u0002\u0006K\u0001\\\u0001\u0007aJ|\u00070\u001f\u0011)\u0005]T\bCA\t|\u0013\ta(C\u0001\u0005w_2\fG/\u001b7f\u0011\u001dqxJ1A\u0005\n}\fqbY;se\u0016tGOU3rk\u0016\u001cHo]\u000b\u0003\u0003\u0003\u0001b!a\u0001\u0002\u000e\u0005EQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\fy\nA!\u001e;jY&!\u0011qBA\u0003\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u0004b!a\u0005\u0002\u001a\u0005uQBAA\u000b\u0015\r\t9\u0002B\u0001\tg\u000e,g.\u0019:j_&!\u00111DA\u000b\u0005Q!\u0016.\\3e'\u000e,g.\u0019:j_\u0016cW-\\3oiB!\u00111CA\u0010\u0013\u0011\t\t#!\u0006\u0003\u001dI+\u0017/^3ti\u0016cW-\\3oi\"A\u0011QE(!\u0002\u0013\t\t!\u0001\tdkJ\u0014XM\u001c;SKF,Xm\u001d;tA!I\u0011\u0011F(C\u0002\u0013%\u00111F\u0001\fGV\u0014(/\u001a8u)\u0006<7/\u0006\u0002\u0002.A1\u00111AA\u0007\u0003_\u0001b!a\u0005\u0002\u001a\u0005E\u0002\u0003BA\n\u0003gIA!!\u000e\u0002\u0016\tQA+Y4FY\u0016lWM\u001c;\t\u0011\u0005er\n)A\u0005\u0003[\tAbY;se\u0016tG\u000fV1hg\u0002Bq!!\u0010P\t\u0003\ty$\u0001\bti\u0006\u0014HOU3d_J$\u0017N\\4\u0015\u0003qAq!a\u0011P\t\u0003\t)%A\u0007ti>\u0004(+Z2pe\u0012Lgn\u001a\u000b\u00049\u0005\u001d\u0003\u0002CA%\u0003\u0003\u0002\r!a\u0013\u0002\tM\fg/\u001a\t\u0004#\u00055\u0013bAA(%\t9!i\\8mK\u0006t\u0007bBA*\u001f\u0012\u0005\u0011QK\u0001\u000fe\u0016\u001cW-\u001b<f%\u0016\fX/Z:u)\ra\u0012q\u000b\u0005\t\u00033\n\t\u00061\u0001\u0002\\\u00059!/Z9vKN$\b\u0003BA/\u0003kj!!a\u0018\u000b\u0007=\f\tG\u0003\u0003\u0002d\u0005\u0015\u0014!B2pI\u0016\u001c'\u0002BA4\u0003S\nq\u0001[1oI2,'O\u0003\u0003\u0002l\u00055\u0014!\u00028fiRL(\u0002BA8\u0003c\nQA\u001b2pgNT!!a\u001d\u0002\u0007=\u0014x-\u0003\u0003\u0002x\u0005}#a\u0003%uiB\u0014V-];fgRDq!a\u001fP\t\u0003\ti(A\bsK\u000e,\u0017N^3SKN\u0004xN\\:f)\u0015a\u0012qPAH\u0011!\tI&!\u001fA\u0002\u0005\u0005\u0005\u0003BAB\u0003\u0017k!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0007e\u0016lw\u000e^3\u000b\u0007\u0005\u001dd.\u0003\u0003\u0002\u000e\u0006\u0015%\u0001\u0005+j[\u0016$\u0007\n\u001e;q%\u0016\fX/Z:u\u0011!\t\t*!\u001fA\u0002\u0005M\u0015\u0001\u0003:fgB|gn]3\u0011\t\u0005u\u0013QS\u0005\u0005\u0003/\u000byF\u0001\u0007IiR\u0004(+Z:q_:\u001cX\rC\u0004\u0002\u001c>#\t!!(\u0002\r\u0005$G\rV1h)\ra\u0012q\u0014\u0005\b\u0003C\u000bI\n1\u0001*\u0003\u0011!X\r\u001f;\t\u000f\u0005\u0015v\n\"\u0001\u0002(\u0006\u00012/Z2ve\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u00049\u0005%\u0006\u0002CAV\u0003G\u0003\r!!,\u0002\u001dM,7-\u001e:fI\"{7\u000f^+S\u0013B!\u0011qVA`\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016aA;sS*!\u0011qWA]\u0003\u0019\u0019G.[3oi*\u0019q.a/\u000b\u0007\u0005uv+\u0001\u0003oS:<\u0017\u0002BAa\u0003c\u00131!\u0016:j\u0011\u001d\t)m\u0014C\u0001\u0003\u007f\t!c\u00197fCJ\u0014VmY8sI\u0016\u00148\u000b^1uK\u0002")
public class RecorderController
implements StrictLogging {
    private final RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd;
    private volatile HttpProxy proxy;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags;
    private final Logger logger;

    public static Option<Path> apply$default$2() {
        return RecorderController$.MODULE$.apply$default$2();
    }

    public static void apply(Map<String, Object> map, Option<Path> option) {
        RecorderController$.MODULE$.apply(map, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd() {
        return this.io$gatling$recorder$controller$RecorderController$$frontEnd;
    }

    private HttpProxy proxy() {
        return this.proxy;
    }

    private void proxy_$eq(HttpProxy x$1) {
        this.proxy = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests() {
        return this.currentRequests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags() {
        return this.currentTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecording() {
        RecorderMode selectedMode = this.io$gatling$recorder$controller$RecorderController$$frontEnd().selectedRecorderMode();
        String harFilePath = this.io$gatling$recorder$controller$RecorderController$$frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(harFilePath)))) {
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleMissingHarFile(harFilePath);
            return;
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = proceed = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.io$gatling$recorder$controller$RecorderController$$frontEnd().askSimulationOverwrite() : true;
            if (!proceed) return;
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, RecorderConfiguration$.MODULE$.configuration());
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportFailure(errMsg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(validation instanceof Success)) throw new MatchError(validation);
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportSuccess();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) throw new MatchError((Object)recorderMode2);
                this.proxy_$eq(new HttpProxy(this, RecorderConfiguration$.MODULE$.configuration()));
                this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStarted();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void stopRecording(boolean save) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStopped();
        try {
            if (this.currentRequests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).toVector(), (Seq<TimedScenarioElement<TagElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentTags()).toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
            return;
        }
        finally {
            this.proxy().shutdown();
            this.clearRecorderState();
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
        }
    }

    public synchronized void receiveRequest(HttpRequest request) {
        Option$.MODULE$.apply((Object)request.headers().get("Proxy-Authorization")).foreach((Function1)new Serializable(this){

            public final void apply(String header) {
                String[] credentials = new String(Base64.decode((String)header.split(" ")[1])).split(":");
                RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
                props.proxyUsername(credentials[0]);
                props.proxyPassword(credentials[1]);
                RecorderConfiguration$.MODULE$.reload(props.build());
            }
        });
    }

    public void receiveResponse(TimedHttpRequest request, HttpResponse response) {
        if (BoxesRunTime.unboxToBoolean((Object)RecorderConfiguration$.MODULE$.configuration().filters().filters().map((Function1)new Serializable(this, request){
            private final TimedHttpRequest request$1;

            public final boolean apply(Filters x$1) {
                return x$1.accept(this.request$1.httpRequest().getUri());
            }
            {
                this.request$1 = request$1;
            }
        }).getOrElse((Function0)new Serializable(this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }))) {
            long arrivalTime = System.currentTimeMillis();
            RequestElement requestEl = RequestElement$.MODULE$.apply(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration());
            this.currentRequests().add(new TimedScenarioElement<RequestElement>(request.sendTime(), arrivalTime, requestEl));
            Option previousSendTime = JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).lastOption().map((Function1)new Serializable(this){

                public final long apply(TimedScenarioElement<RequestElement> x$2) {
                    return x$2.sendTime();
                }
            });
            previousSendTime.foreach((Function1)new Serializable(this, arrivalTime){
                private final /* synthetic */ RecorderController $outer;
                private final long arrivalTime$1;

                public final void apply(long t) {
                    this.apply$mcVJ$sp(t);
                }

                public void apply$mcVJ$sp(long t) {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(this.arrivalTime$1 - t)).milliseconds();
                    if (delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) {
                        this.$outer.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new PauseInfo(delta));
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.arrivalTime$1 = arrivalTime$1;
                }
            });
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new RequestInfo(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = System.currentTimeMillis();
        this.currentTags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new TagInfo(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new SSLInfo(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.currentRequests().clear();
        this.currentTags().clear();
    }

    public RecorderController() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.io$gatling$recorder$controller$RecorderController$$frontEnd = RecorderFrontend$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.currentRequests = new ConcurrentLinkedQueue();
        this.currentTags = new ConcurrentLinkedQueue();
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
    }
}

