/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import com.ning.http.client.uri.Uri;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.UserAgent;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestBodyParams;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ResponseBody;
import io.gatling.recorder.scenario.ResponseBodyBytes$;
import java.nio.charset.Charset;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.package$;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class RequestElement$
implements Serializable {
    public static final RequestElement$ MODULE$;
    private final Regex HtmlContentType;
    private final Set<String> CacheHeaders;

    static {
        new RequestElement$();
    }

    public Regex HtmlContentType() {
        return this.HtmlContentType;
    }

    public Option<byte[]> io$gatling$recorder$scenario$RequestElement$$extractContent(HttpMessage message) {
        None$ none$;
        if (message.getContent().readableBytes() > 0) {
            byte[] bufferBytes = new byte[message.getContent().readableBytes()];
            message.getContent().getBytes(message.getContent().readerIndex(), bufferBytes);
            none$ = new Some((Object)bufferBytes);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Set<String> CacheHeaders() {
        return this.CacheHeaders;
    }

    public RequestElement apply(HttpRequest request, HttpResponse response, RecorderConfiguration configuration) {
        Map requestHeaders = (Map)JavaConversions$.MODULE$.asScalaBuffer(request.headers().entries()).map((Function1)new Serializable(){

            public final Tuple2<String, String> apply(Map.Entry<String, String> entry) {
                return new Tuple2((Object)entry.getKey(), (Object)entry.getValue());
            }
        }, package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        Option requestContentType = requestHeaders.get((Object)HeaderNames$.MODULE$.ContentType());
        Option requestUserAgent = requestHeaders.get((Object)HeaderNames$.MODULE$.UserAgent());
        Option responseContentType = Option$.MODULE$.apply((Object)response.headers().get(HeaderNames$.MODULE$.ContentType()));
        List embeddedResources = (List)responseContentType.collect((PartialFunction)new Serializable(request, response, requestHeaders){
            public final HttpRequest request$1;
            private final HttpResponse response$1;
            public final Map requestHeaders$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String headerCharset = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String charsetName = (String)Option$.MODULE$.apply((Object)headerCharset).filter((Function1)new Serializable(this){

                        public final boolean apply(String x$1) {
                            return Charset.isSupported(x$1);
                        }
                    }).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return Codec$.MODULE$.UTF8().name();
                        }
                    });
                    Charset charset = Charset.forName(charsetName);
                    object = RequestElement$.MODULE$.io$gatling$recorder$scenario$RequestElement$$extractContent((HttpMessage)this.response$1).map((Function1)new Serializable(this, charset){
                        private final /* synthetic */ anonfun.1 $outer;
                        private final Charset charset$1;

                        public final List<EmbeddedResource> apply(byte[] bytes) {
                            String htmlBuff = new String(bytes, this.charset$1);
                            Option userAgent = this.$outer.requestHeaders$1.get((Object)HeaderNames$.MODULE$.UserAgent()).flatMap((Function1)new Serializable(this){

                                public final Option<UserAgent> apply(String userAgent) {
                                    return UserAgent$.MODULE$.parseFromHeader(userAgent);
                                }
                            });
                            return new HtmlParser().getEmbeddedResources(Uri.create((String)this.$outer.request$1.getUri()), htmlBuff, userAgent);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.charset$1 = charset$1;
                        }
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0;
                return bl;
            }
            {
                this.request$1 = request$1;
                this.response$1 = response$1;
                this.requestHeaders$1 = requestHeaders$1;
            }
        }).flatten(Predef$.MODULE$.$conforms()).getOrElse((Function0)new Serializable(){

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        boolean containsFormParams = requestContentType.exists((Function1)new Serializable(){

            public final boolean apply(String x$1) {
                return x$1.contains(HeaderValues$.MODULE$.ApplicationFormUrlEncoded());
            }
        });
        Option requestBody = this.io$gatling$recorder$scenario$RequestElement$$extractContent((HttpMessage)request).map((Function1)new Serializable(containsFormParams){
            private final boolean containsFormParams$1;

            public final Product apply(byte[] content) {
                return this.containsFormParams$1 ? new RequestBodyParams((List<Tuple2<String, String>>)HttpHelper$.MODULE$.parseFormBody(new String(content, Codec$.MODULE$.UTF8().name()))) : new RequestBodyBytes(content);
            }
            {
                this.containsFormParams$1 = containsFormParams$1;
            }
        });
        Option responseBody = this.io$gatling$recorder$scenario$RequestElement$$extractContent((HttpMessage)request).map((Function1)ResponseBodyBytes$.MODULE$);
        Map filteredRequestHeaders = configuration.http().removeCacheHeaders() ? requestHeaders.filterKeys((Function1)new Serializable(){

            public final boolean apply(String name) {
                return !RequestElement$.MODULE$.CacheHeaders().contains((Object)name);
            }
        }) : requestHeaders;
        return new RequestElement(new String(request.getUri()), request.getMethod().toString(), (Map<String, String>)filteredRequestHeaders, (Option<RequestBody>)requestBody, (Option<ResponseBody>)responseBody, response.getStatus().getCode(), (List<EmbeddedResource>)embeddedResources, this.apply$default$8());
    }

    public List<RequestElement> apply$default$8() {
        return Nil$.MODULE$;
    }

    public RequestElement apply(String uri, String method, Map<String, String> headers, Option<RequestBody> body, Option<ResponseBody> responseBody, int statusCode, List<EmbeddedResource> embeddedResources, List<RequestElement> nonEmbeddedResources) {
        return new RequestElement(uri, method, headers, body, responseBody, statusCode, embeddedResources, nonEmbeddedResources);
    }

    public Option<Tuple8<String, String, Map<String, String>, Option<RequestBody>, Option<ResponseBody>, Object, List<EmbeddedResource>, List<RequestElement>>> unapply(RequestElement x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.uri(), (Object)x$0.method(), x$0.headers(), x$0.body(), x$0.responseBody(), (Object)BoxesRunTime.boxToInteger((int)x$0.statusCode()), x$0.embeddedResources(), x$0.nonEmbeddedResources()));
    }

    public List<RequestElement> $lessinit$greater$default$8() {
        return Nil$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RequestElement$() {
        MODULE$ = this;
        this.HtmlContentType = new StringOps(Predef$.MODULE$.augmentString("(?i)text/html\\s*(;\\s+charset=(.+))?")).r();
        this.CacheHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.CacheControl(), HeaderNames$.MODULE$.IfMatch(), HeaderNames$.MODULE$.IfModifiedSince(), HeaderNames$.MODULE$.IfNoneMatch(), HeaderNames$.MODULE$.IfRange(), HeaderNames$.MODULE$.IfUnmodifiedSince()}));
    }
}

