/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.util.Io$;
import io.gatling.core.util.PathHelper;
import io.gatling.core.util.PathHelper$;
import io.gatling.recorder.http.ssl.Ca;
import io.gatling.recorder.http.ssl.Csr;
import io.gatling.recorder.http.ssl.SslCertUtil$;
import io.gatling.recorder.http.ssl.SslCertUtil$$anonfun$updateKeystoreWithNewAlias$1$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.util.Try;
import scala.util.Try$;

public final class SslCertUtil$
implements StrictLogging {
    public static final SslCertUtil$ MODULE$;
    private final Logger logger;

    static {
        new SslCertUtil$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Object readPEM(InputStream file) {
        return Io$.MODULE$.withCloseable((AutoCloseable)new PEMParser((Reader)new InputStreamReader(file)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(PEMParser x$1) {
                return x$1.readObject();
            }
        });
    }

    public void writePEM(Object obj, OutputStream os) {
        Io$.MODULE$.withCloseable((AutoCloseable)new JcaPEMWriter((Writer)new OutputStreamWriter(os)), (Function1)new Serializable(obj){
            public static final long serialVersionUID = 0L;
            private final Object obj$1;

            public final void apply(JcaPEMWriter x$2) {
                x$2.writeObject(this.obj$1);
            }
            {
                this.obj$1 = obj$1;
            }
        });
    }

    public X509Certificate certificateFromHolder(X509CertificateHolder certHolder) {
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
    }

    public KeyPair newRSAKeyPair() {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(1024);
        return kpGen.generateKeyPair();
    }

    public ContentSigner io$gatling$recorder$http$ssl$SslCertUtil$$newSigner(PrivateKey privKey) {
        return new JcaContentSignerBuilder("SHA256withRSA").build(privKey);
    }

    public void generateGatlingCAPEMFiles(Path dir, String privKeyFileName, String certFileName) {
        Predef$.MODULE$.assert(PathHelper.RichPath$.MODULE$.isDirectory$extension(PathHelper$.MODULE$.RichPath(dir)), (Function0)new Serializable(dir){
            public static final long serialVersionUID = 0L;
            private final Path dir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " isn't a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
            }
            {
                this.dir$1 = dir$1;
            }
        });
        KeyPair pair = this.newRSAKeyPair();
        X509CertificateHolder crtHolder = this.generateCACertificate$1(pair);
        this.writePEM(crtHolder, PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(dir), certFileName))));
        this.writePEM(pair, PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(dir), privKeyFileName))));
    }

    public Try<Ca> getCA(InputStream crtFile, InputStream keyFile) {
        return Try$.MODULE$.apply((Function0)new Serializable(crtFile, keyFile){
            public static final long serialVersionUID = 0L;
            private final InputStream crtFile$1;
            private final InputStream keyFile$1;

            public final Ca apply() {
                X509CertificateHolder certHolder = (X509CertificateHolder)SslCertUtil$.MODULE$.readPEM(this.crtFile$1);
                X509Certificate certificate = SslCertUtil$.MODULE$.certificateFromHolder(certHolder);
                PrivateKeyInfo keyInfo = ((PEMKeyPair)SslCertUtil$.MODULE$.readPEM(this.keyFile$1)).getPrivateKeyInfo();
                PrivateKey privKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
                return new Ca(certificate, privKey);
            }
            {
                this.crtFile$1 = crtFile$1;
                this.keyFile$1 = keyFile$1;
            }
        });
    }

    public Try<KeyStore> updateKeystoreWithNewAlias(KeyStore keyStore2, char[] password, String alias, Try<Ca> caT) {
        return caT.flatMap((Function1)new Serializable(keyStore2, password, alias){
            public static final long serialVersionUID = 0L;
            public final KeyStore keyStore$1;
            public final char[] password$1;
            public final String alias$1;

            public final Try<KeyStore> apply(Ca ca) {
                return SslCertUtil$.MODULE$.io$gatling$recorder$http$ssl$SslCertUtil$$createCSR(this.alias$1).flatMap((Function1)new Serializable(this, ca){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.updateKeystoreWithNewAlias.1 $outer;
                    public final Ca ca$1;

                    public final Try<KeyStore> apply(Csr csr) {
                        return SslCertUtil$.MODULE$.io$gatling$recorder$http$ssl$SslCertUtil$$createServerCert(this.ca$1.cert(), this.ca$1.privKey(), csr.cert()).flatMap((Function1)new Serializable(this, csr){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$updateKeystoreWithNewAlias$1$$anonfun$apply$1 $outer;
                            private final Csr csr$2;

                            public final Try<KeyStore> apply(X509Certificate serverCrt) {
                                return SslCertUtil$.MODULE$.io$gatling$recorder$http$ssl$SslCertUtil$$addNewKeystoreEntry(this.$outer.io$gatling$recorder$http$ssl$SslCertUtil$$anonfun$$anonfun$$$outer().keyStore$1, this.$outer.io$gatling$recorder$http$ssl$SslCertUtil$$anonfun$$anonfun$$$outer().password$1, serverCrt, this.csr$2.privKey(), this.$outer.ca$1.cert(), this.$outer.io$gatling$recorder$http$ssl$SslCertUtil$$anonfun$$anonfun$$$outer().alias$1).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final KeyStore apply(KeyStore updatedKeyStore) {
                                        return updatedKeyStore;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.csr$2 = csr$2;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.updateKeystoreWithNewAlias.1 io$gatling$recorder$http$ssl$SslCertUtil$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ca$1 = ca$1;
                    }
                });
            }
            {
                this.keyStore$1 = keyStore$1;
                this.password$1 = password$1;
                this.alias$1 = alias$1;
            }
        });
    }

    public Try<Csr> io$gatling$recorder$http$ssl$SslCertUtil$$createCSR(String dnHostName) {
        return Try$.MODULE$.apply((Function0)new Serializable(dnHostName){
            public static final long serialVersionUID = 0L;
            private final String dnHostName$1;

            public final Csr apply() {
                KeyPair pair = SslCertUtil$.MODULE$.newRSAKeyPair();
                String dn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C=FR, ST=Val de marne, O=GatlingCA, OU=Gatling, CN=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dnHostName$1}));
                JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(dn), pair.getPublic());
                ContentSigner signer = SslCertUtil$.MODULE$.io$gatling$recorder$http$ssl$SslCertUtil$$newSigner(pair.getPrivate());
                PKCS10CertificationRequest pkcs10CR = builder.build(signer);
                return new Csr(pkcs10CR, pair.getPrivate());
            }
            {
                this.dnHostName$1 = dnHostName$1;
            }
        });
    }

    public Try<X509Certificate> io$gatling$recorder$http$ssl$SslCertUtil$$createServerCert(X509Certificate caCert, PrivateKey caKey, PKCS10CertificationRequest csr) {
        return Try$.MODULE$.apply((Function0)new Serializable(caCert, caKey, csr){
            public static final long serialVersionUID = 0L;
            private final X509Certificate caCert$1;
            private final PrivateKey caKey$1;
            private final PKCS10CertificationRequest csr$1;

            public final X509Certificate apply() {
                long now = System.currentTimeMillis();
                X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(this.caCert$1).getSubject(), BigInteger.valueOf(now), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(1)).day().toMillis()), this.csr$1.getSubject(), this.csr$1.getSubjectPublicKeyInfo());
                ContentSigner signer = SslCertUtil$.MODULE$.io$gatling$recorder$http$ssl$SslCertUtil$$newSigner(this.caKey$1);
                return SslCertUtil$.MODULE$.certificateFromHolder(certBuilder.build(signer));
            }
            {
                this.caCert$1 = caCert$1;
                this.caKey$1 = caKey$1;
                this.csr$1 = csr$1;
            }
        });
    }

    public Try<KeyStore> io$gatling$recorder$http$ssl$SslCertUtil$$addNewKeystoreEntry(KeyStore keyStore2, char[] password, X509Certificate serverCert, PrivateKey csrPrivKey, X509Certificate caCert, String alias) {
        return Try$.MODULE$.apply((Function0)new Serializable(keyStore2, password, serverCert, csrPrivKey, caCert, alias){
            public static final long serialVersionUID = 0L;
            private final KeyStore keyStore$2;
            private final char[] password$2;
            private final X509Certificate serverCert$1;
            private final PrivateKey csrPrivKey$1;
            private final X509Certificate caCert$2;
            private final String alias$2;

            public final KeyStore apply() {
                this.keyStore$2.setCertificateEntry(this.alias$2, this.serverCert$1);
                this.keyStore$2.setKeyEntry(this.alias$2, this.csrPrivKey$1, this.password$2, (Certificate[])((Object[])new Certificate[]{this.serverCert$1, this.caCert$2}));
                return this.keyStore$2;
            }
            {
                this.keyStore$2 = keyStore$2;
                this.password$2 = password$2;
                this.serverCert$1 = serverCert$1;
                this.csrPrivKey$1 = csrPrivKey$1;
                this.caCert$2 = caCert$2;
                this.alias$2 = alias$2;
            }
        });
    }

    private final X509CertificateHolder generateCACertificate$1(KeyPair pair) {
        String dn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C=FR, ST=Val de marne, O=GatlingCA, CN=Gatling"})).s((Seq)Nil$.MODULE$);
        long now = System.currentTimeMillis();
        JcaX509v1CertificateBuilder certGen = new JcaX509v1CertificateBuilder(new X500Principal(dn), BigInteger.valueOf(now), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(365)).days().toMillis()), new X500Principal(dn), pair.getPublic());
        ContentSigner signer = this.io$gatling$recorder$http$ssl$SslCertUtil$$newSigner(pair.getPrivate());
        return certGen.build(signer);
    }

    private SslCertUtil$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

