/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.ning.http.client.uri.Uri;
import com.ning.http.util.Base64;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.filter.Filters;
import io.gatling.core.util.PathHelper;
import io.gatling.core.util.PathHelper$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.recorder.RecorderMode;
import io.gatling.recorder.RecorderMode$Har$;
import io.gatling.recorder.RecorderMode$Proxy$;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.controller.RecorderController$;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.RecorderFrontend$;
import io.gatling.recorder.ui.RequestInfo;
import io.gatling.recorder.ui.SSLInfo;
import io.gatling.recorder.ui.TagInfo;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ew!B\u0001\u0003\u0011\u0003Y\u0011A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'o\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\t\u000biiA\u0011A\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007qyB\b\u0005\u0002\u0012;%\u0011aD\u0005\u0002\u0005+:LG\u000fC\u0003!3\u0001\u0007\u0011%A\u0003qe>\u00048\u000f\r\u0002#gA!1\u0005\u000b\u00162\u001b\u0005!#BA\u0013'\u0003\u001diW\u000f^1cY\u0016T!a\n\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002*I\t\u0019Q*\u00199\u0011\u0005-rcBA\t-\u0013\ti##\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u0013!\t\u00114\u0007\u0004\u0001\u0005\u0013Qz\u0012\u0011!A\u0001\u0006\u0003)$aA0%cE\u0011a'\u000f\t\u0003#]J!\u0001\u000f\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011CO\u0005\u0003wI\u00111!\u00118z\u0011\u001di\u0014\u0004%AA\u0002y\n!C]3d_J$WM]\"p]\u001aLwMR5mKB\u0019\u0011cP!\n\u0005\u0001\u0013\"AB(qi&|g\u000e\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u0006!a-\u001b7f\u0015\t1u)A\u0002oS>T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u0007\n!\u0001+\u0019;i\u0011\u001daU\"%A\u0005\u00025\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0002\u001d*\u0012ahT\u0016\u0002!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0016\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002X%\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0007\t9\u0011\u0001!W\n\u00041BQ\u0006CA.c\u001b\u0005a&BA/_\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0006-\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0017aA2p[&\u00111\r\u0018\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u000b]AF\u0011A3\u0015\u0003\u0019\u0004\"\u0001\u0004-\t\u000f!D&\u0019!C\u0005S\u0006AaM]8oi\u0016sG-F\u0001k!\tYg.D\u0001m\u0015\tiG!\u0001\u0002vS&\u0011q\u000e\u001c\u0002\u0011%\u0016\u001cwN\u001d3fe\u001a\u0013xN\u001c;f]\u0012Da!\u001d-!\u0002\u0013Q\u0017!\u00034s_:$XI\u001c3!\u0011%\u0019\b\f1AA\u0002\u0013%A/A\u0003qe>D\u00180F\u0001v!\t1\u00180D\u0001x\u0015\tAH!\u0001\u0003iiR\u0004\u0018B\u0001>x\u0005%AE\u000f\u001e9Qe>D\u0018\u0010C\u0005}1\u0002\u0007\t\u0019!C\u0005{\u0006I\u0001O]8ys~#S-\u001d\u000b\u00039yDqa`>\u0002\u0002\u0003\u0007Q/A\u0002yIEBq!a\u0001YA\u0003&Q/\u0001\u0004qe>D\u0018\u0010\t\u0015\u0005\u0003\u0003\t9\u0001E\u0002\u0012\u0003\u0013I1!a\u0003\u0013\u0005!1x\u000e\\1uS2,\u0007\"CA\b1\n\u0007I\u0011BA\t\u0003=\u0019WO\u001d:f]R\u0014V-];fgR\u001cXCAA\n!\u0019\t)\"a\b\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\bH\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u0012q\u0003\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0004\u0003S!\u0011\u0001C:dK:\f'/[8\n\t\u00055\u0012q\u0005\u0002\u0015)&lW\rZ*dK:\f'/[8FY\u0016lWM\u001c;\u0011\t\u0005\u0015\u0012\u0011G\u0005\u0005\u0003g\t9C\u0001\bSKF,Xm\u001d;FY\u0016lWM\u001c;\t\u0011\u0005]\u0002\f)A\u0005\u0003'\t\u0001cY;se\u0016tGOU3rk\u0016\u001cHo\u001d\u0011\t\u0013\u0005m\u0002L1A\u0005\n\u0005u\u0012aC2veJ,g\u000e\u001e+bON,\"!a\u0010\u0011\r\u0005U\u0011qDA!!\u0019\t)#a\u000b\u0002DA!\u0011QEA#\u0013\u0011\t9%a\n\u0003\u0015Q\u000bw-\u00127f[\u0016tG\u000f\u0003\u0005\u0002La\u0003\u000b\u0011BA \u00031\u0019WO\u001d:f]R$\u0016mZ:!\u0011\u001d\ty\u0005\u0017C\u0001\u0003#\nab\u001d;beR\u0014VmY8sI&tw\rF\u0001\u001d\u0011\u001d\t)\u0006\u0017C\u0001\u0003/\nQb\u001d;paJ+7m\u001c:eS:<Gc\u0001\u000f\u0002Z!A\u00111LA*\u0001\u0004\ti&\u0001\u0003tCZ,\u0007cA\t\u0002`%\u0019\u0011\u0011\r\n\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\r-\u0005\u0002\u0005\u001d\u0014A\u0004:fG\u0016Lg/\u001a*fcV,7\u000f\u001e\u000b\u00049\u0005%\u0004\u0002CA6\u0003G\u0002\r!!\u001c\u0002\u000fI,\u0017/^3tiB!\u0011qNAD\u001b\t\t\tHC\u0002y\u0003gRA!!\u001e\u0002x\u0005)1m\u001c3fG*!\u0011\u0011PA>\u0003\u001dA\u0017M\u001c3mKJTA!! \u0002\u0000\u0005)a.\u001a;us*!\u0011\u0011QAB\u0003\u0015Q'm\\:t\u0015\t\t))A\u0002pe\u001eLA!!#\u0002r\tY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u001d\ti\t\u0017C\u0001\u0003\u001f\u000bqB]3dK&4XMU3ta>t7/\u001a\u000b\u00069\u0005E\u0015\u0011\u0015\u0005\t\u0003W\nY\t1\u0001\u0002\u0014B!\u0011QSAO\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015A\u0002:f[>$XMC\u0002\u0002z]LA!a(\u0002\u0018\n\u0001B+[7fI\"#H\u000f\u001d*fcV,7\u000f\u001e\u0005\t\u0003G\u000bY\t1\u0001\u0002&\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0002p\u0005\u001d\u0016\u0002BAU\u0003c\u0012A\u0002\u0013;uaJ+7\u000f]8og\u0016Dq!!,Y\t\u0003\ty+\u0001\u0004bI\u0012$\u0016m\u001a\u000b\u00049\u0005E\u0006bBAZ\u0003W\u0003\rAK\u0001\u0005i\u0016DH\u000fC\u0004\u00028b#\t!!/\u0002!M,7-\u001e:f\u0007>tg.Z2uS>tGc\u0001\u000f\u0002<\"A\u0011QXA[\u0001\u0004\ty,\u0001\btK\u000e,(/\u001a3I_N$XKU%\u0011\t\u0005\u0005\u0017\u0011[\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006\u0019QO]5\u000b\t\u0005%\u00171Z\u0001\u0007G2LWM\u001c;\u000b\u0007a\fiMC\u0002\u0002P\u0002\fAA\\5oO&!\u00111[Ab\u0005\r)&/\u001b\u0005\b\u0003/DF\u0011AA)\u0003I\u0019G.Z1s%\u0016\u001cwN\u001d3feN#\u0018\r^3")
public class RecorderController
implements StrictLogging {
    private final RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd;
    private volatile HttpProxy proxy;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags;
    private final Logger logger;

    public static Option<Path> apply$default$2() {
        return RecorderController$.MODULE$.apply$default$2();
    }

    public static void apply(Map<String, ?> map, Option<Path> option) {
        RecorderController$.MODULE$.apply(map, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd() {
        return this.io$gatling$recorder$controller$RecorderController$$frontEnd;
    }

    private HttpProxy proxy() {
        return this.proxy;
    }

    private void proxy_$eq(HttpProxy x$1) {
        this.proxy = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests() {
        return this.currentRequests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags() {
        return this.currentTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecording() {
        RecorderMode selectedMode = this.io$gatling$recorder$controller$RecorderController$$frontEnd().selectedRecorderMode();
        String harFilePath = this.io$gatling$recorder$controller$RecorderController$$frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(harFilePath)))) {
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleMissingHarFile(harFilePath);
            return;
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = proceed = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.io$gatling$recorder$controller$RecorderController$$frontEnd().askSimulationOverwrite() : true;
            if (!proceed) return;
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, RecorderConfiguration$.MODULE$.configuration());
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportFailure(errMsg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(validation instanceof Success)) throw new MatchError(validation);
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportSuccess();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) throw new MatchError((Object)recorderMode2);
                this.proxy_$eq(new HttpProxy(this, RecorderConfiguration$.MODULE$.configuration()));
                this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStarted();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void stopRecording(boolean save) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStopped();
        try {
            if (this.currentRequests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).toVector(), (Seq<TimedScenarioElement<TagElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentTags()).toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
            return;
        }
        finally {
            this.proxy().shutdown();
            this.clearRecorderState();
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
        }
    }

    public synchronized void receiveRequest(HttpRequest request) {
        Option$.MODULE$.apply((Object)request.headers().get("Proxy-Authorization")).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String header) {
                String[] credentials = new String(Base64.decode((String)header.split(" ")[1])).split(":");
                RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
                props.proxyUsername(credentials[0]);
                props.proxyPassword(credentials[1]);
                RecorderConfiguration$.MODULE$.reload(props.build());
            }
        });
    }

    public void receiveResponse(TimedHttpRequest request, HttpResponse response) {
        if (BoxesRunTime.unboxToBoolean((Object)RecorderConfiguration$.MODULE$.configuration().filters().filters().map((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final TimedHttpRequest request$1;

            public final boolean apply(Filters x$1) {
                return x$1.accept(this.request$1.httpRequest().getUri());
            }
            {
                this.request$1 = request$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }))) {
            long arrivalTime = System.currentTimeMillis();
            RequestElement requestEl = RequestElement$.MODULE$.apply(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration());
            this.currentRequests().add(new TimedScenarioElement<RequestElement>(request.sendTime(), arrivalTime, requestEl));
            Option previousSendTime = JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(TimedScenarioElement<RequestElement> x$2) {
                    return x$2.sendTime();
                }
            });
            previousSendTime.foreach((Function1)new Serializable(this, arrivalTime){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecorderController $outer;
                private final long arrivalTime$1;

                public final void apply(long t) {
                    this.apply$mcVJ$sp(t);
                }

                public void apply$mcVJ$sp(long t) {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(this.arrivalTime$1 - t)).milliseconds();
                    if (delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) {
                        this.$outer.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new PauseInfo(delta));
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.arrivalTime$1 = arrivalTime$1;
                }
            });
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new RequestInfo(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = System.currentTimeMillis();
        this.currentTags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new TagInfo(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new SSLInfo(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.currentRequests().clear();
        this.currentTags().clear();
    }

    public RecorderController() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.io$gatling$recorder$controller$RecorderController$$frontEnd = RecorderFrontend$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.currentRequests = new ConcurrentLinkedQueue();
        this.currentTags = new ConcurrentLinkedQueue();
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
    }
}

