/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.handler.remote;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.channel.BootstrapFactory$;
import io.gatling.recorder.http.handler.ScalaChannelHandler;
import io.gatling.recorder.http.handler.ScalaChannelHandler$class;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.handler.user.SSLHandlerSetter;
import io.gatling.recorder.http.ssl.SslClientContext$;
import io.gatling.recorder.http.ssl.SslServerContext;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001f\ti!+Z7pi\u0016D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\rI,Wn\u001c;f\u0015\t)a!A\u0004iC:$G.\u001a:\u000b\u0005\u001dA\u0011\u0001\u00025uiBT!!\u0003\u0006\u0002\u0011I,7m\u001c:eKJT!a\u0003\u0007\u0002\u000f\u001d\fG\u000f\\5oO*\tQ\"\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u00119\u0001\u0002\"!\u0005\u000e\u000e\u0003IQ!a\u0005\u000b\u0002\u000f\rD\u0017M\u001c8fY*\u0011QCF\u0001\u0006]\u0016$H/\u001f\u0006\u0003/a\tQA\u001b2pgNT\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0013\u0005Q\u0019\u0016.\u001c9mK\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7feB\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\u0014'\u000e\fG.Y\"iC:tW\r\u001c%b]\u0012dWM\u001d\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\nAb]2bY\u0006dwnZ4j]\u001eT!!\n\u0014\u0002\u0011QL\b/Z:bM\u0016T\u0011aJ\u0001\u0004G>l\u0017BA\u0015#\u00055\u0019FO]5di2{wmZ5oO\"A1\u0006\u0001B\u0001B\u0003%A&\u0001\u0006d_:$(o\u001c7mKJ\u0004\"!L\u0018\u000e\u00039R!a\u000b\u0005\n\u0005Ar#A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0011gNd7+\u001a:wKJ\u001cuN\u001c;fqR\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0004\u0002\u0007M\u001cH.\u0003\u00029k\t\u00012k\u001d7TKJ4XM]\"p]R,\u0007\u0010\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005YQo]3s\u0007\"\fgN\\3m!\t\tB(\u0003\u0002>%\t91\t[1o]\u0016d\u0007\u0002C \u0001\u0005\u0003\u0007I\u0011\u0001!\u0002\u001dA,'OZ8s[\u000e{gN\\3diV\t\u0011\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15IA\u0004C_>dW-\u00198\t\u0011!\u0003!\u00111A\u0005\u0002%\u000b!\u0003]3sM>\u0014XnQ8o]\u0016\u001cGo\u0018\u0013fcR\u0011!*\u0014\t\u0003\u0005.K!\u0001T\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u001e\u000b\t\u00111\u0001B\u0003\rAH%\r\u0005\t!\u0002\u0011\t\u0011)Q\u0005\u0003\u0006y\u0001/\u001a:g_Jl7i\u001c8oK\u000e$\b\u0005\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003B\u0003%\u0011XmY8o]\u0016\u001cG\u000fC\u0003U\u0001\u0011\u0005Q+\u0001\u0004=S:LGO\u0010\u000b\u0007-bK&l\u0017/\u0011\u0005]\u0003Q\"\u0001\u0002\t\u000b-\u001a\u0006\u0019\u0001\u0017\t\u000bI\u001a\u0006\u0019A\u001a\t\u000bi\u001a\u0006\u0019A\u001e\t\u000b}\u001a\u0006\u0019A!\t\u000bI\u001b\u0006\u0019A!\t\u000by\u0003A\u0011I0\u0002\u001f5,7o]1hKJ+7-Z5wK\u0012$2A\u00131f\u0011\u0015\tW\f1\u0001c\u0003\r\u0019G\u000f\u001f\t\u0003#\rL!\u0001\u001a\n\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")a-\u0018a\u0001O\u0006)QM^3oiB\u0011\u0011\u0003[\u0005\u0003SJ\u0011A\"T3tg\u0006<W-\u0012<f]R\u0004")
public class RemoteHandler
extends SimpleChannelHandler
implements ScalaChannelHandler,
StrictLogging {
    private final RecorderController controller;
    public final SslServerContext io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext;
    public final Channel io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel;
    private boolean performConnect;
    private final boolean reconnect;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Object function2ChannelFutureListener(Function1<ChannelFuture, Object> thunk) {
        return ScalaChannelHandler$class.function2ChannelFutureListener(this, thunk);
    }

    @Override
    public HttpRequest copyRequestWithNewUri(HttpRequest request, String uri) {
        return ScalaChannelHandler$class.copyRequestWithNewUri(this, request, uri);
    }

    public boolean performConnect() {
        return this.performConnect;
    }

    public void performConnect_$eq(boolean x$1) {
        this.performConnect = x$1;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object object = event.getMessage();
        if (object instanceof HttpResponse) {
            BoxedUnit boxedUnit;
            HttpResponse httpResponse = (HttpResponse)object;
            if (this.performConnect()) {
                this.handleConnect$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.handleRequest$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof HttpChunk) {
            BoxedUnit boxedUnit;
            HttpChunk httpChunk = (HttpChunk)object;
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response chunk to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)httpChunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response chunk to disconnected user channel ", ", ignoring"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        }
    }

    private final void upgradeRemotePipeline$1(ChannelPipeline remotePipeline, SslHandler clientSslHandler) {
        remotePipeline.replace(BootstrapFactory$.MODULE$.CodecHandlerName(), BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec());
        remotePipeline.addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)clientSslHandler);
    }

    private final void handleConnect$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        HttpResponseStatus httpResponseStatus = response.getStatus();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (!(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null)) {
            this.performConnect_$eq(false);
            SslHandler remoteSslHandler = new SslHandler(SslClientContext$.MODULE$.createSSLEngine());
            remoteSslHandler.setCloseOnSSLException(true);
            this.upgradeRemotePipeline$1(ctx$1.getChannel().getPipeline(), remoteSslHandler);
            if (!this.reconnect) {
                remoteSslHandler.handshake().addListener(this.function2ChannelFutureListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RemoteHandler $outer;

                    public final ChannelFuture apply(ChannelFuture handshakeFuture) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)handshakeFuture.getChannel().getRemoteAddress();
                        this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getPipeline().addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)new SSLHandlerSetter(inetSocketAddress.getHostString(), this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext));
                        return this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            return;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Outgoing proxy refused to connect: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.getStatus()})));
    }

    private final void handleRequest$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        Object object = ctx$1.getAttachment();
        if (object instanceof TimedHttpRequest) {
            BoxedUnit boxedUnit;
            TimedHttpRequest timedHttpRequest = (TimedHttpRequest)object;
            this.controller.receiveResponse(timedHttpRequest, response);
            ctx$1.setAttachment(null);
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)response);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response to disconnected user channel ", ", aborting request:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId(), timedHttpRequest.httpRequest().getUri()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
            return;
        }
        throw new IllegalStateException("Couldn't find request attachment");
    }

    public RemoteHandler(RecorderController controller, SslServerContext sslServerContext, Channel userChannel, boolean performConnect, boolean reconnect) {
        this.controller = controller;
        this.io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext = sslServerContext;
        this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel = userChannel;
        this.performConnect = performConnect;
        this.reconnect = reconnect;
        ScalaChannelHandler$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

