/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.ning.http.client.uri.Uri;
import com.ning.http.util.Base64;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.filter.Filters;
import io.gatling.core.util.PathHelper;
import io.gatling.core.util.PathHelper$;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.RecorderFrontend$;
import io.gatling.recorder.ui.RequestInfo;
import io.gatling.recorder.ui.SSLInfo;
import io.gatling.recorder.ui.TagInfo;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!B\u0001\u0003\u0001\u0011Q!A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004\"AE\r\u000e\u0003MQ!\u0001F\u000b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005Y9\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003a\t1aY8n\u0013\tQ2CA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u00069\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u0011\u0019\u0014xN\u001c;F]\u0012,\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\t!!^5\n\u0005%2#\u0001\u0005*fG>\u0014H-\u001a:Ge>tG/\u001a8e\u0011\u0019Y\u0003\u0001)A\u0005I\u0005IaM]8oi\u0016sG\r\t\u0005\n[\u0001\u0001\r\u00111A\u0005\n9\nQ\u0001\u001d:pqf,\u0012a\f\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\tA\u0001\u001b;ua&\u0011A'\r\u0002\n\u0011R$\b\u000f\u0015:pqfD\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011B\u001c\u0002\u0013A\u0014x\u000e_=`I\u0015\fHC\u0001\u001d<!\ta\u0011(\u0003\u0002;\u001b\t!QK\\5u\u0011\u001daT'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019q\u0004\u0001)Q\u0005_\u00051\u0001O]8ys\u0002B#!\u0010!\u0011\u00051\t\u0015B\u0001\"\u000e\u0005!1x\u000e\\1uS2,\u0007b\u0002#\u0001\u0005\u0004%I!R\u0001\u0010GV\u0014(/\u001a8u%\u0016\fX/Z:ugV\ta\tE\u0002H\u001dBk\u0011\u0001\u0013\u0006\u0003\u0013*\u000b!bY8oGV\u0014(/\u001a8u\u0015\tYE*\u0001\u0003vi&d'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f\"\u0013QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\rE\u0002R)Zk\u0011A\u0015\u0006\u0003'\u0012\t\u0001b]2f]\u0006\u0014\u0018n\\\u0005\u0003+J\u0013A\u0003V5nK\u0012\u001c6-\u001a8be&|W\t\\3nK:$\bCA)X\u0013\tA&K\u0001\bSKF,Xm\u001d;FY\u0016lWM\u001c;\t\ri\u0003\u0001\u0015!\u0003G\u0003A\u0019WO\u001d:f]R\u0014V-];fgR\u001c\b\u0005C\u0004]\u0001\t\u0007I\u0011B/\u0002\u0017\r,(O]3oiR\u000bwm]\u000b\u0002=B\u0019qIT0\u0011\u0007E#\u0006\r\u0005\u0002RC&\u0011!M\u0015\u0002\u000b)\u0006<W\t\\3nK:$\bB\u00023\u0001A\u0003%a,\u0001\u0007dkJ\u0014XM\u001c;UC\u001e\u001c\b\u0005C\u0003g\u0001\u0011\u0005q-\u0001\bti\u0006\u0014HOU3d_J$\u0017N\\4\u0015\u0003aBQ!\u001b\u0001\u0005\u0002)\fQb\u001d;paJ+7m\u001c:eS:<GC\u0001\u001dl\u0011\u0015a\u0007\u000e1\u0001n\u0003\u0011\u0019\u0018M^3\u0011\u00051q\u0017BA8\u000e\u0005\u001d\u0011un\u001c7fC:DQ!\u001d\u0001\u0005\u0002I\faB]3dK&4XMU3rk\u0016\u001cH\u000f\u0006\u00029g\")A\u000f\u001da\u0001k\u00069!/Z9vKN$\bc\u0001<\u0002\u00065\tqO\u0003\u00023q*\u0011\u0011P_\u0001\u0006G>$Wm\u0019\u0006\u0003wr\fq\u0001[1oI2,'O\u0003\u0002~}\u0006)a.\u001a;us*\u0019q0!\u0001\u0002\u000b)\u0014wn]:\u000b\u0005\u0005\r\u0011aA8sO&\u0019\u0011qA<\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003=\u0011XmY3jm\u0016\u0014Vm\u001d9p]N,G#\u0002\u001d\u0002\u0010\u0005}\u0001b\u0002;\u0002\n\u0001\u0007\u0011\u0011\u0003\t\u0005\u0003'\tY\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0019\u0011X-\\8uK*\u001110M\u0005\u0005\u0003;\t)B\u0001\tUS6,G\r\u0013;uaJ+\u0017/^3ti\"A\u0011\u0011EA\u0005\u0001\u0004\t\u0019#\u0001\u0005sKN\u0004xN\\:f!\r1\u0018QE\u0005\u0004\u0003O9(\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u0007C\u0012$G+Y4\u0015\u0007a\ny\u0003\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003\u0011!X\r\u001f;\u0011\t\u0005U\u00121\b\b\u0004\u0019\u0005]\u0012bAA\u001d\u001b\u00051\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000f\u000e\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001c]3dkJ,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0007a\n9\u0005\u0003\u0005\u0002J\u0005\u0005\u0003\u0019AA&\u00039\u0019XmY;sK\u0012Dun\u001d;V%&\u0003B!!\u0014\u0002^5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0002ve&TA!!\u0016\u0002X\u000511\r\\5f]RT1AMA-\u0015\r\tYfF\u0001\u0005]&tw-\u0003\u0003\u0002`\u0005=#aA+sS\"1\u00111\r\u0001\u0005\u0002\u001d\f!c\u00197fCJ\u0014VmY8sI\u0016\u00148\u000b^1uK\u0002")
public class RecorderController
implements StrictLogging {
    private final RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd;
    private volatile HttpProxy proxy;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RecorderFrontend io$gatling$recorder$controller$RecorderController$$frontEnd() {
        return this.io$gatling$recorder$controller$RecorderController$$frontEnd;
    }

    private HttpProxy proxy() {
        return this.proxy;
    }

    private void proxy_$eq(HttpProxy x$1) {
        this.proxy = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests() {
        return this.currentRequests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags() {
        return this.currentTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startRecording() {
        RecorderMode selectedMode = this.io$gatling$recorder$controller$RecorderController$$frontEnd().selectedRecorderMode();
        String harFilePath2 = this.io$gatling$recorder$controller$RecorderController$$frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(harFilePath2)))) {
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleMissingHarFile(harFilePath2);
            return;
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = proceed = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.io$gatling$recorder$controller$RecorderController$$frontEnd().askSimulationOverwrite() : true;
            if (!proceed) return;
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath2, RecorderConfiguration$.MODULE$.configuration());
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportFailure(errMsg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(validation instanceof Success)) throw new MatchError(validation);
                    this.io$gatling$recorder$controller$RecorderController$$frontEnd().handleHarExportSuccess();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) throw new MatchError((Object)recorderMode2);
                this.proxy_$eq(new HttpProxy(this, RecorderConfiguration$.MODULE$.configuration()));
                this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStarted();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void stopRecording(boolean save) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().recordingStopped();
        try {
            if (this.currentRequests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).toVector(), (Seq<TimedScenarioElement<TagElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentTags()).toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
            return;
        }
        finally {
            this.proxy().shutdown();
            this.clearRecorderState();
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
        }
    }

    public synchronized void receiveRequest(HttpRequest request) {
        Option$.MODULE$.apply((Object)request.headers().get("Proxy-Authorization")).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String header) {
                String[] credentials = new String(Base64.decode((String)header.split(" ")[1])).split(":");
                RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
                props.proxyUsername(credentials[0]);
                props.proxyPassword(credentials[1]);
                RecorderConfiguration$.MODULE$.reload(props.build());
            }
        });
    }

    public void receiveResponse(TimedHttpRequest request, HttpResponse response) {
        if (BoxesRunTime.unboxToBoolean((Object)RecorderConfiguration$.MODULE$.configuration().filters().filters().map((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final TimedHttpRequest request$1;

            public final boolean apply(Filters x$1) {
                return x$1.accept(this.request$1.httpRequest().getUri());
            }
            {
                this.request$1 = request$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }))) {
            long arrivalTime = System.currentTimeMillis();
            RequestElement requestEl = RequestElement$.MODULE$.apply(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration());
            this.currentRequests().add(new TimedScenarioElement<RequestElement>(request.sendTime(), arrivalTime, requestEl));
            Option previousSendTime = JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(TimedScenarioElement<RequestElement> x$2) {
                    return x$2.sendTime();
                }
            });
            previousSendTime.foreach((Function1)new Serializable(this, arrivalTime){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecorderController $outer;
                private final long arrivalTime$1;

                public final void apply(long t) {
                    this.apply$mcVJ$sp(t);
                }

                public void apply$mcVJ$sp(long t) {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(this.arrivalTime$1 - t)).milliseconds();
                    if (delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) {
                        this.$outer.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new PauseInfo(delta));
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.arrivalTime$1 = arrivalTime$1;
                }
            });
            this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new RequestInfo(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = System.currentTimeMillis();
        this.currentTags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new TagInfo(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().receiveEventInfo(new SSLInfo(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.currentRequests().clear();
        this.currentTags().clear();
    }

    public RecorderController() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.io$gatling$recorder$controller$RecorderController$$frontEnd = RecorderFrontend$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.currentRequests = new ConcurrentLinkedQueue();
        this.currentTags = new ConcurrentLinkedQueue();
        this.io$gatling$recorder$controller$RecorderController$$frontEnd().init();
    }
}

