/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.handler.remote;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.channel.BootstrapFactory$;
import io.gatling.recorder.http.handler.ScalaChannelHandler;
import io.gatling.recorder.http.handler.ScalaChannelHandler$class;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.handler.user.SslHandlerSetter;
import io.gatling.recorder.http.ssl.SslClientContext$;
import io.gatling.recorder.http.ssl.SslServerContext;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0001\t9\u0011QBU3n_R,\u0007*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\\8uK*\u0011QAB\u0001\bQ\u0006tG\r\\3s\u0015\t9\u0001\"\u0001\u0003iiR\u0004(BA\u0005\u000b\u0003!\u0011XmY8sI\u0016\u0014(BA\u0006\r\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!D\u0001\u0003S>\u001cB\u0001A\b\u001c?A\u0011\u0001#G\u0007\u0002#)\u0011!cE\u0001\bG\"\fgN\\3m\u0015\t!R#A\u0003oKR$\u0018P\u0003\u0002\u0017/\u0005)!NY8tg*\t\u0001$A\u0002pe\u001eL!AG\t\u0003)MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s!\taR$D\u0001\u0005\u0013\tqBAA\nTG\u0006d\u0017m\u00115b]:,G\u000eS1oI2,'\u000f\u0005\u0002!O5\t\u0011E\u0003\u0002#G\u0005a1oY1mC2|wmZ5oO*\u0011A%J\u0001\tif\u0004Xm]1gK*\ta%A\u0002d_6L!\u0001K\u0011\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011!Q\u0003A!A!\u0002\u0013a\u0013AC2p]R\u0014x\u000e\u001c7fe\u000e\u0001\u0001CA\u00170\u001b\u0005q#B\u0001\u0016\t\u0013\t\u0001dF\u0001\nSK\u000e|'\u000fZ3s\u0007>tGO]8mY\u0016\u0014\b\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002!M\u001cHnU3sm\u0016\u00148i\u001c8uKb$\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0007\u0003\r\u00198\u000f\\\u0005\u0003qU\u0012\u0001cU:m'\u0016\u0014h/\u001a:D_:$X\r\u001f;\t\u0011i\u0002!\u0011!Q\u0001\nm\n1\"^:fe\u000eC\u0017M\u001c8fYB\u0011\u0001\u0003P\u0005\u0003{E\u0011qa\u00115b]:,G\u000e\u0003\u0005@\u0001\t\u0005\r\u0011\"\u0001A\u00039\u0001XM\u001d4pe6\u001cuN\u001c8fGR,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b\u0005>|G.Z1o\u0011!A\u0005A!a\u0001\n\u0003I\u0015A\u00059fe\u001a|'/\\\"p]:,7\r^0%KF$\"AS'\u0011\u0005\t[\u0015B\u0001'D\u0005\u0011)f.\u001b;\t\u000f9;\u0015\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\t\u0011A\u0003!\u0011!Q!\n\u0005\u000bq\u0002]3sM>\u0014XnQ8o]\u0016\u001cG\u000f\t\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0003\u0006I!/Z2p]:,7\r\u001e\u0005\u0006)\u0002!\t!V\u0001\u0007y%t\u0017\u000e\u001e \u0015\rYC\u0016LW.]!\t9\u0006!D\u0001\u0003\u0011\u0015Q3\u000b1\u0001-\u0011\u0015\u00114\u000b1\u00014\u0011\u0015Q4\u000b1\u0001<\u0011\u0015y4\u000b1\u0001B\u0011\u0015\u00116\u000b1\u0001B\u0011\u0015q\u0006\u0001\"\u0011`\u0003=iWm]:bO\u0016\u0014VmY3jm\u0016$Gc\u0001&aK\")\u0011-\u0018a\u0001E\u0006\u00191\r\u001e=\u0011\u0005A\u0019\u0017B\u00013\u0012\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQAZ/A\u0002\u001d\fQ!\u001a<f]R\u0004\"\u0001\u00055\n\u0005%\f\"\u0001D'fgN\fw-Z#wK:$\b")
public class RemoteHandler
extends SimpleChannelHandler
implements ScalaChannelHandler,
StrictLogging {
    private final RecorderController controller;
    public final SslServerContext io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext;
    public final Channel io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel;
    private boolean performConnect;
    private final boolean reconnect;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Object function2ChannelFutureListener(Function1<ChannelFuture, Object> thunk) {
        return ScalaChannelHandler$class.function2ChannelFutureListener(this, thunk);
    }

    @Override
    public HttpRequest copyRequestWithNewUri(HttpRequest request, String uri) {
        return ScalaChannelHandler$class.copyRequestWithNewUri(this, request, uri);
    }

    public boolean performConnect() {
        return this.performConnect;
    }

    public void performConnect_$eq(boolean x$1) {
        this.performConnect = x$1;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object object = event.getMessage();
        if (object instanceof HttpResponse) {
            BoxedUnit boxedUnit;
            HttpResponse httpResponse = (HttpResponse)object;
            if (this.performConnect()) {
                this.handleConnect$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.handleRequest$1(httpResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof HttpChunk) {
            BoxedUnit boxedUnit;
            HttpChunk httpChunk = (HttpChunk)object;
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response chunk to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)httpChunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response chunk to disconnected user channel ", ", ignoring"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        }
    }

    private final void upgradeRemotePipeline$1(ChannelPipeline remotePipeline, SslHandler clientSslHandler) {
        remotePipeline.replace(BootstrapFactory$.MODULE$.CodecHandlerName(), BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec());
        remotePipeline.addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)clientSslHandler);
    }

    private final void handleConnect$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        HttpResponseStatus httpResponseStatus = response.getStatus();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (!(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null)) {
            this.performConnect_$eq(false);
            SslHandler remoteSslHandler = new SslHandler(SslClientContext$.MODULE$.createSSLEngine());
            remoteSslHandler.setCloseOnSSLException(true);
            this.upgradeRemotePipeline$1(ctx$1.getChannel().getPipeline(), remoteSslHandler);
            if (!this.reconnect) {
                remoteSslHandler.handshake().addListener(this.function2ChannelFutureListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RemoteHandler $outer;

                    public final ChannelFuture apply(ChannelFuture handshakeFuture) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)handshakeFuture.getChannel().getRemoteAddress();
                        this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getPipeline().addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)new SslHandlerSetter(inetSocketAddress.getHostString(), this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext));
                        return this.$outer.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            return;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Outgoing proxy refused to connect: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.getStatus()})));
    }

    private final void handleRequest$1(HttpResponse response, ChannelHandlerContext ctx$1) {
        Object object = ctx$1.getAttachment();
        if (object instanceof TimedHttpRequest) {
            BoxedUnit boxedUnit;
            TimedHttpRequest timedHttpRequest = (TimedHttpRequest)object;
            this.controller.receiveResponse(timedHttpRequest, response);
            ctx$1.setAttachment(null);
            if (this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.isConnected()) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId()})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.write((Object)response);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response to disconnected user channel ", ", aborting request:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel.getId(), timedHttpRequest.httpRequest().getUri()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
            return;
        }
        throw new IllegalStateException("Couldn't find request attachment");
    }

    public RemoteHandler(RecorderController controller, SslServerContext sslServerContext, Channel userChannel, boolean performConnect, boolean reconnect) {
        this.controller = controller;
        this.io$gatling$recorder$http$handler$remote$RemoteHandler$$sslServerContext = sslServerContext;
        this.io$gatling$recorder$http$handler$remote$RemoteHandler$$userChannel = userChannel;
        this.performConnect = performConnect;
        this.reconnect = reconnect;
        ScalaChannelHandler$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

