/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.channel;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.handler.user.PortUnificationUserHandler;
import io.gatling.recorder.http.ssl.SslClientContext$;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import scala.runtime.BoxedUnit;

public final class BootstrapFactory$
implements StrictLogging {
    public static final BootstrapFactory$ MODULE$;
    private final String CodecHandlerName;
    private final String SslHandlerSetterName;
    private final String SslHandlerName;
    private final String GatlingHandlerName;
    private final String PortUnificationServerHandler;
    private final AttributeKey<TimedHttpRequest> TimedHttpRequestAttribute;
    private final Logger logger;

    static {
        new BootstrapFactory$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String CodecHandlerName() {
        return this.CodecHandlerName;
    }

    public String SslHandlerSetterName() {
        return this.SslHandlerSetterName;
    }

    public String SslHandlerName() {
        return this.SslHandlerName;
    }

    public String GatlingHandlerName() {
        return this.GatlingHandlerName;
    }

    public String PortUnificationServerHandler() {
        return this.PortUnificationServerHandler;
    }

    public AttributeKey<TimedHttpRequest> TimedHttpRequestAttribute() {
        return this.TimedHttpRequestAttribute;
    }

    public Bootstrap newRemoteBootstrap(NioEventLoopGroup clientGroup, boolean ssl, RecorderConfiguration config) {
        return (Bootstrap)new Bootstrap().channel(NioSocketChannel.class).group((EventLoopGroup)clientGroup).handler((ChannelHandler)new ChannelInitializer<Channel>(ssl, config){
            private final boolean ssl$1;
            private final RecorderConfiguration config$2;

            public void initChannel(Channel ch) {
                BoxedUnit boxedUnit;
                if (BootstrapFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                    BootstrapFactory$.MODULE$.logger().underlying().debug("Open new remote channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ChannelPipeline pipeline = ch.pipeline();
                Object object = this.ssl$1 ? pipeline.addLast(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)new SslHandler(SslClientContext$.MODULE$.createSSLEngine())) : BoxedUnit.UNIT;
                pipeline.addLast(BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec(this.config$2.netty().maxInitialLineLength(), this.config$2.netty().maxHeaderSize(), this.config$2.netty().maxChunkSize())).addLast("inflater", (ChannelHandler)new HttpContentDecompressor()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.config$2.netty().maxContentLength()));
            }
            {
                this.ssl$1 = ssl$1;
                this.config$2 = config$2;
            }
        });
    }

    public ServerBootstrap newUserBootstrap(NioEventLoopGroup serverBossGroup, NioEventLoopGroup serverWorkerGroup, HttpProxy proxy, RecorderConfiguration config) {
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, (Object)1024).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).group((EventLoopGroup)serverBossGroup, (EventLoopGroup)serverWorkerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(proxy, config){
            private final HttpProxy proxy$1;
            private final RecorderConfiguration config$1;

            public void initChannel(Channel ch) {
                BoxedUnit boxedUnit;
                if (BootstrapFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                    BootstrapFactory$.MODULE$.logger().underlying().debug("Open new user channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.config$1.netty().maxInitialLineLength(), this.config$1.netty().maxHeaderSize(), this.config$1.netty().maxChunkSize())).addLast("inflater", (ChannelHandler)new HttpContentDecompressor()).addLast("encoder", (ChannelHandler)new HttpResponseEncoder()).addLast("deflater", (ChannelHandler)new HttpContentCompressor()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.config$1.netty().maxContentLength())).addLast(BootstrapFactory$.MODULE$.PortUnificationServerHandler(), (ChannelHandler)new PortUnificationUserHandler(this.proxy$1, pipeline));
            }
            {
                this.proxy$1 = proxy$1;
                this.config$1 = config$1;
            }
        });
    }

    private BootstrapFactory$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.CodecHandlerName = "codec";
        this.SslHandlerSetterName = "ssl-setter";
        this.SslHandlerName = "ssl";
        this.GatlingHandlerName = "gatling";
        this.PortUnificationServerHandler = "port-unification";
        this.TimedHttpRequestAttribute = AttributeKey.valueOf((String)"default");
    }
}

