/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Io$;
import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.commons.util.TimeHelper$;
import io.gatling.recorder.http.ssl.Ca;
import io.gatling.recorder.http.ssl.Csr;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$$nestedInAnonfun$6$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$$nestedInAnonfun$7$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$addNewKeystoreEntry$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$createCSR$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$createServerCert$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$generateGatlingCAPEMFiles$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$getCA$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$io$gatling$recorder$http$ssl$SslCertUtil$$$nestedInAnonfun$5$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$readPEM$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$updateKeystoreWithNewAlias$1;
import io.gatling.recorder.http.ssl.SslCertUtil$lambda$$writePEM$1;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.util.Try;
import scala.util.Try$;

public final class SslCertUtil$
implements StrictLogging {
    public static final SslCertUtil$ MODULE$;
    private final Logger logger;

    static {
        new SslCertUtil$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Object readPEM(InputStream file) {
        return Io$.MODULE$.withCloseable((AutoCloseable)new PEMParser((Reader)new InputStreamReader(file)), (Function1)new SslCertUtil$lambda$$readPEM$1());
    }

    public void writePEM(Object obj, OutputStream os) {
        Io$.MODULE$.withCloseable((AutoCloseable)new JcaPEMWriter((Writer)new OutputStreamWriter(os)), (Function1)new SslCertUtil$lambda$$writePEM$1(obj));
    }

    public X509Certificate certificateFromHolder(X509CertificateHolder certHolder) {
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
    }

    public KeyPair newRSAKeyPair() {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(1024);
        return kpGen.generateKeyPair();
    }

    private ContentSigner newSigner(PrivateKey privKey) {
        return new JcaContentSignerBuilder("SHA256withRSA").build(privKey);
    }

    public void generateGatlingCAPEMFiles(Path dir, String privKeyFileName, String certFileName) {
        Predef$.MODULE$.assert(PathHelper.RichPath$.MODULE$.isDirectory$extension(PathHelper$.MODULE$.RichPath(dir)), (Function0)new SslCertUtil$lambda$$generateGatlingCAPEMFiles$1(dir));
        KeyPair pair = this.newRSAKeyPair();
        X509CertificateHolder crtHolder = this.generateCACertificate$1(pair);
        this.writePEM(crtHolder, PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(dir), certFileName))));
        this.writePEM(pair, PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(dir), privKeyFileName))));
    }

    public Try<Ca> getCA(InputStream crtFile, InputStream keyFile) {
        return Try$.MODULE$.apply((Function0)new SslCertUtil$lambda$$getCA$1(this, crtFile, keyFile));
    }

    public Try<KeyStore> updateKeystoreWithNewAlias(KeyStore keyStore2, char[] password, String alias, Try<Ca> caT) {
        return caT.flatMap((Function1)new SslCertUtil$lambda$$updateKeystoreWithNewAlias$1(this, keyStore2, password, alias));
    }

    private Try<Csr> createCSR(String dnHostName) {
        return Try$.MODULE$.apply((Function0)new SslCertUtil$lambda$$createCSR$1(this, dnHostName));
    }

    private Try<X509Certificate> createServerCert(X509Certificate caCert, PrivateKey caKey, PKCS10CertificationRequest csr) {
        return Try$.MODULE$.apply((Function0)new SslCertUtil$lambda$$createServerCert$1(this, caCert, caKey, csr));
    }

    private Try<KeyStore> addNewKeystoreEntry(KeyStore keyStore2, char[] password, X509Certificate serverCert, PrivateKey csrPrivKey, X509Certificate caCert, String alias) {
        return Try$.MODULE$.apply((Function0)new SslCertUtil$lambda$$addNewKeystoreEntry$1(keyStore2, password, serverCert, csrPrivKey, caCert, alias));
    }

    public static final /* synthetic */ Object io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$1(PEMParser x$1) {
        return x$1.readObject();
    }

    public static final /* synthetic */ void io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$2(Object obj$1, JcaPEMWriter x$2) {
        x$2.writeObject(obj$1);
    }

    public static final /* synthetic */ String io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$3(Path dir$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " isn't a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir$1}));
    }

    private final X509CertificateHolder generateCACertificate$1(KeyPair pair) {
        String dn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C=FR, ST=Val de marne, O=GatlingCA, CN=Gatling"})).s((Seq)Nil$.MODULE$);
        long now = TimeHelper$.MODULE$.nowMillis();
        JcaX509v1CertificateBuilder certGen = new JcaX509v1CertificateBuilder(new X500Principal(dn), BigInteger.valueOf(now), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(365)).days().toMillis()), new X500Principal(dn), pair.getPublic());
        ContentSigner signer = this.newSigner(pair.getPrivate());
        return certGen.build(signer);
    }

    public final /* synthetic */ Ca io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$4(InputStream crtFile$1, InputStream keyFile$1) {
        X509CertificateHolder certHolder = (X509CertificateHolder)this.readPEM(crtFile$1);
        X509Certificate certificate = this.certificateFromHolder(certHolder);
        PrivateKeyInfo keyInfo = ((PEMKeyPair)this.readPEM(keyFile$1)).getPrivateKeyInfo();
        PrivateKey privKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
        return new Ca(certificate, privKey);
    }

    public static final /* synthetic */ KeyStore io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$8(KeyStore updatedKeyStore) {
        return updatedKeyStore;
    }

    public final /* synthetic */ Try io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$7(KeyStore keyStore$1, char[] password$1, String alias$1, Ca ca$1, Csr csr$2, X509Certificate serverCrt) {
        return this.addNewKeystoreEntry(keyStore$1, password$1, serverCrt, csr$2.privKey(), ca$1.cert(), alias$1).map((Function1)new SslCertUtil$lambda$$$nestedInAnonfun$7$1());
    }

    public final /* synthetic */ Try io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$6(KeyStore keyStore$1, char[] password$1, String alias$1, Ca ca$1, Csr csr) {
        return this.createServerCert(ca$1.cert(), ca$1.privKey(), csr.cert()).flatMap((Function1)new SslCertUtil$lambda$$$nestedInAnonfun$6$1(this, keyStore$1, password$1, alias$1, ca$1, csr));
    }

    public final /* synthetic */ Try io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$5(KeyStore keyStore$1, char[] password$1, String alias$1, Ca ca) {
        return this.createCSR(alias$1).flatMap((Function1)new SslCertUtil$lambda$$io$gatling$recorder$http$ssl$SslCertUtil$$$nestedInAnonfun$5$1(this, keyStore$1, password$1, alias$1, ca));
    }

    public final /* synthetic */ Csr io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$9(String dnHostName$1) {
        KeyPair pair = this.newRSAKeyPair();
        String dn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C=FR, ST=Val de marne, O=GatlingCA, OU=Gatling, CN=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dnHostName$1}));
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(dn), pair.getPublic());
        ContentSigner signer = this.newSigner(pair.getPrivate());
        PKCS10CertificationRequest pkcs10CR = builder.build(signer);
        return new Csr(pkcs10CR, pair.getPrivate());
    }

    public final /* synthetic */ X509Certificate io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$10(X509Certificate caCert$1, PrivateKey caKey$1, PKCS10CertificationRequest csr$1) {
        long now = TimeHelper$.MODULE$.nowMillis();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(caCert$1).getSubject(), BigInteger.valueOf(now), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(1)).day().toMillis()), csr$1.getSubject(), csr$1.getSubjectPublicKeyInfo());
        ContentSigner signer = this.newSigner(caKey$1);
        return this.certificateFromHolder(certBuilder.build(signer));
    }

    public static final /* synthetic */ KeyStore io$gatling$recorder$http$ssl$SslCertUtil$$$anonfun$11(KeyStore keyStore$2, char[] password$2, X509Certificate serverCert$1, PrivateKey csrPrivKey$1, X509Certificate caCert$2, String alias$2) {
        keyStore$2.setCertificateEntry(alias$2, serverCert$1);
        keyStore$2.setKeyEntry(alias$2, csrPrivKey$1, password$2, (Certificate[])((Object[])new Certificate[]{serverCert$1, caCert$2}));
        return keyStore$2;
    }

    private SslCertUtil$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

