/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.model.SafeHttpRequest;
import io.gatling.recorder.http.model.SafeHttpResponse;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestBodyParams;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$$nestedInAnonfun$10$lambda$$charsetName$1;
import io.gatling.recorder.scenario.RequestElement$$nestedInAnonfun$10$lambda$$charsetName$2;
import io.gatling.recorder.scenario.RequestElement$$nestedInAnonfun$10$lambda$$userAgent$1;
import io.gatling.recorder.scenario.RequestElement$lambda$$containsFormParams$1;
import io.gatling.recorder.scenario.RequestElement$lambda$$embeddedResources$1;
import io.gatling.recorder.scenario.RequestElement$lambda$$filteredRequestHeaders$1;
import io.gatling.recorder.scenario.RequestElement$lambda$$requestHeaders$1;
import io.gatling.recorder.scenario.ResponseBody;
import io.gatling.recorder.scenario.ResponseBodyBytes;
import java.nio.charset.Charset;
import java.util.Map;
import org.asynchttpclient.uri.Uri;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.package$;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class RequestElement$
implements Serializable {
    public static final RequestElement$ MODULE$;
    private final Regex HtmlContentType;
    private final Set<String> CacheHeaders;

    static {
        new RequestElement$();
    }

    public Regex HtmlContentType() {
        return this.HtmlContentType;
    }

    public Set<String> CacheHeaders() {
        return this.CacheHeaders;
    }

    public RequestElement apply(SafeHttpRequest request, SafeHttpResponse response, RecorderConfiguration configuration) {
        None$ requestBody2;
        Map requestHeaders2 = (Map)JavaConversions$.MODULE$.asScalaBuffer(request.headers().entries()).map((Function1)new RequestElement$lambda$$requestHeaders$1(), package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        Option requestContentType = requestHeaders2.get((Object)HeaderNames$.MODULE$.ContentType());
        Option requestUserAgent = requestHeaders2.get((Object)HeaderNames$.MODULE$.UserAgent());
        Option responseContentType = Option$.MODULE$.apply((Object)response.headers().get(HeaderNames$.MODULE$.ContentType()));
        boolean containsFormParams2 = requestContentType.exists((Function1)new RequestElement$lambda$$containsFormParams$1());
        Object object = Predef$.MODULE$.byteArrayOps(request.body()).nonEmpty() ? (containsFormParams2 ? new Some((Object)new RequestBodyParams((List<Tuple2<String, String>>)HttpHelper$.MODULE$.parseFormBody(new String(request.body(), Codec$.MODULE$.UTF8().name())))) : new Some((Object)new RequestBodyBytes(request.body()))) : (requestBody2 = None$.MODULE$);
        None$ responseBody = Predef$.MODULE$.byteArrayOps(response.body()).nonEmpty() ? new Some((Object)new ResponseBodyBytes(response.body())) : None$.MODULE$;
        List embeddedResources2 = (List)responseContentType.collect((PartialFunction)new Serializable(request, response, requestUserAgent){
            public static final long serialVersionUID = 0L;
            private final SafeHttpRequest request$1;
            private final SafeHttpResponse response$1;
            private final Option requestUserAgent$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x12;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    None$ none$;
                    String headerCharset = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String charsetName2 = (String)Option$.MODULE$.apply((Object)headerCharset).filter((Function1)new RequestElement$$nestedInAnonfun$10$lambda$$charsetName$1()).getOrElse((Function0)new RequestElement$$nestedInAnonfun$10$lambda$$charsetName$2());
                    Charset charset = Charset.forName(charsetName2);
                    if (Predef$.MODULE$.byteArrayOps(this.response$1.body()).nonEmpty()) {
                        String htmlBuff = new String(this.response$1.body(), charset);
                        Option userAgent2 = this.requestUserAgent$1.flatMap((Function1)new RequestElement$$nestedInAnonfun$10$lambda$$userAgent$1());
                        none$ = new Some((Object)new HtmlParser().getEmbeddedResources(Uri.create((String)this.request$1.uri()), htmlBuff, userAgent2));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    object = none$;
                } else {
                    object = function1.apply(x12);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x12) {
                String string = x12;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0;
                return bl;
            }

            public static final /* synthetic */ boolean io$gatling$recorder$scenario$RequestElement$$anonfun$10$$$anonfun$3(String x$1) {
                return Charset.isSupported(x$1);
            }

            public static final /* synthetic */ String io$gatling$recorder$scenario$RequestElement$$anonfun$10$$$anonfun$4() {
                return Codec$.MODULE$.UTF8().name();
            }

            public static final /* synthetic */ Option io$gatling$recorder$scenario$RequestElement$$anonfun$10$$$anonfun$5(String userAgent2) {
                return UserAgent$.MODULE$.parseFromHeader(userAgent2);
            }
            {
                this.request$1 = request$1;
                this.response$1 = response$1;
                this.requestUserAgent$1 = requestUserAgent$1;
            }
        }).flatten(Predef$.MODULE$.$conforms()).getOrElse((Function0)new RequestElement$lambda$$embeddedResources$1());
        Map filteredRequestHeaders2 = configuration.http().removeCacheHeaders() ? requestHeaders2.filterKeys((Function1)new RequestElement$lambda$$filteredRequestHeaders$1(this)) : requestHeaders2;
        return new RequestElement(new String(request.uri()), request.method().toString(), (Map<String, String>)filteredRequestHeaders2, (Option<RequestBody>)requestBody2, (Option<ResponseBody>)responseBody, response.status().code(), (List<EmbeddedResource>)embeddedResources2, this.apply$default$8());
    }

    public List<RequestElement> apply$default$8() {
        return Nil$.MODULE$;
    }

    public RequestElement apply(String uri, String method, Map<String, String> headers2, Option<RequestBody> body, Option<ResponseBody> responseBody, int statusCode, List<EmbeddedResource> embeddedResources2, List<RequestElement> nonEmbeddedResources2) {
        return new RequestElement(uri, method, headers2, body, responseBody, statusCode, embeddedResources2, nonEmbeddedResources2);
    }

    public Option<Tuple8<String, String, Map<String, String>, Option<RequestBody>, Option<ResponseBody>, Object, List<EmbeddedResource>, List<RequestElement>>> unapply(RequestElement x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.uri(), (Object)x$0.method(), x$0.headers(), x$0.body(), x$0.responseBody(), (Object)BoxesRunTime.boxToInteger((int)x$0.statusCode()), x$0.embeddedResources(), x$0.nonEmbeddedResources()));
    }

    public List<RequestElement> $lessinit$greater$default$8() {
        return Nil$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 io$gatling$recorder$scenario$RequestElement$$$anonfun$1(Map.Entry entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    public static final /* synthetic */ boolean io$gatling$recorder$scenario$RequestElement$$$anonfun$2(String x$1) {
        return x$1.contains(HeaderValues$.MODULE$.ApplicationFormUrlEncoded());
    }

    public static final /* synthetic */ Nil$ io$gatling$recorder$scenario$RequestElement$$$anonfun$6() {
        return Nil$.MODULE$;
    }

    public final /* synthetic */ boolean io$gatling$recorder$scenario$RequestElement$$$anonfun$7(String name) {
        return !this.CacheHeaders().contains((Object)name);
    }

    private RequestElement$() {
        MODULE$ = this;
        this.HtmlContentType = new StringOps(Predef$.MODULE$.augmentString("(?i)text/html\\s*(;\\s+charset=(.+))?")).r();
        this.CacheHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.CacheControl(), HeaderNames$.MODULE$.IfMatch(), HeaderNames$.MODULE$.IfModifiedSince(), HeaderNames$.MODULE$.IfNoneMatch(), HeaderNames$.MODULE$.IfRange(), HeaderNames$.MODULE$.IfUnmodifiedSince()}));
    }
}

