/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.headless;

import io.gatling.commons.util.Io$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.EventInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.headless.HeadlessFrontend$;
import io.gatling.recorder.ui.headless.HeadlessFrontend$lambda$$createLockFile$1;
import io.gatling.recorder.ui.headless.HeadlessFrontend$lambda$$harFilePath$1;
import io.gatling.recorder.ui.headless.HeadlessFrontend$lambda$$recordingStarted$1;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005=rAB\u0001\u0003\u0011\u0003\u0011A\"\u0001\tIK\u0006$G.Z:t\rJ|g\u000e^3oI*\u00111\u0001B\u0001\tQ\u0016\fG\r\\3tg*\u0011QAB\u0001\u0003k&T!a\u0002\u0005\u0002\u0011I,7m\u001c:eKJT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_B\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0001\u0005A\u0011\u0001\u0003S3bI2,7o\u001d$s_:$XM\u001c3\u0014\u00059\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rC\u0003\u0019\u001d\u0011\u0005!$\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0001b\u0002\u000f\u000f\u0005\u0004%I!H\u0001\u0010%\u0016\u001cwN\u001d3feBKGMR5mKV\ta\u0004\u0005\u0002 G5\t\u0001E\u0003\u0002\fC)\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013!\u0005\u00111\u0015\u000e\\3\t\r\u0019r\u0001\u0015!\u0003\u001f\u0003A\u0011VmY8sI\u0016\u0014\b+\u001b3GS2,\u0007EB\u0003\u0010\u0005\u0001!\u0001f\u0005\u0002(SA\u0011!fK\u0007\u0002\t%\u0011A\u0006\u0002\u0002\u0011%\u0016\u001cwN\u001d3fe\u001a\u0013xN\u001c;f]\u0012D\u0001BL\u0014\u0003\u0002\u0003\u0006IaL\u0001\u000bG>tGO]8mY\u0016\u0014\bC\u0001\u00193\u001b\u0005\t$B\u0001\u0018\u0007\u0013\t\u0019\u0014G\u0001\nSK\u000e|'\u000fZ3s\u0007>tGO]8mY\u0016\u0014\b\u0002C\u001b(\u0005\u0003\u0005\u000b1\u0002\u001c\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t9$(D\u00019\u0015\tId!\u0001\u0004d_:4\u0017nZ\u0005\u0003wa\u0012QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003\u0019O\u0011\u0005Q\b\u0006\u0002?\u0003R\u0011q\b\u0011\t\u0003\u001b\u001dBQ!\u000e\u001fA\u0004YBQA\f\u001fA\u0002=BqaQ\u0014A\u0002\u0013%A)\u0001\u0004iCN\u0014VO\\\u000b\u0002\u000bB\u0011!CR\u0005\u0003\u000fN\u0011qAQ8pY\u0016\fg\u000eC\u0004JO\u0001\u0007I\u0011\u0002&\u0002\u0015!\f7OU;o?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011!\u0003T\u0005\u0003\u001bN\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011k\nQ!\n\u0015\u000bq\u0001[1t%Vt\u0007\u0005C\u0003TO\u0011\u0005C+\u0001\u000btK2,7\r^3e%\u0016\u001cwN\u001d3fe6{G-Z\u000b\u0002+B\u0011qGV\u0005\u0003/b\u0012ABU3d_J$WM]'pI\u0016DQ!W\u0014\u0005Bi\u000b\u0001C]3dK&4X-\u0012<f]RLeNZ8\u0015\u0005-[\u0006\"\u0002/Y\u0001\u0004i\u0016!C3wK:$\u0018J\u001c4p!\tQc,\u0003\u0002`\t\tIQI^3oi&sgm\u001c\u0005\u0006C\u001e\"\tEY\u0001\u0005S:LG\u000fF\u0001L\u0011\u0015!w\u0005\"\u0011f\u0003YA\u0017M\u001c3mK\"\u000b'/\u0012=q_J$h)Y5mkJ,GCA&g\u0011\u001597\r1\u0001i\u0003\u001diWm]:bO\u0016\u0004\"!\u001b7\u000f\u0005IQ\u0017BA6\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u001c\u0002\"\u00029(\t\u0003\n\u0018a\u00035be\u001aKG.\u001a)bi\",\u0012\u0001\u001b\u0005\u0006g\u001e\"\tEY\u0001\u0017Q\u0006tG\r\\3ICJ,\u0005\u0010]8siN+8mY3tg\")Qo\nC!E\u0006\u0001\"/Z2pe\u0012LgnZ*uCJ$X\r\u001a\u0005\u0006o\u001e\"\t\u0005_\u0001\u001fQ\u0006tG\r\\3GS2$XM\u001d,bY&$\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sKN$\"aS=\t\u000bi4\b\u0019A>\u0002\u0011\u0019\f\u0017\u000e\\;sKN\u0004B\u0001`A\u0005Q:\u0019Q0!\u0002\u000f\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!G\u0001\u0007yI|w\u000e\u001e \n\u0003QI1!a\u0002\u0014\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0003\u0002\u000e\t\u00191+Z9\u000b\u0007\u0005\u001d1\u0003\u0003\u0004\u0002\u0012\u001d\"\t\u0005R\u0001\u0017CN\\7+[7vY\u0006$\u0018n\u001c8Pm\u0016\u0014xO]5uK\"1\u0011QC\u0014\u0005B\t\f\u0001C]3d_J$\u0017N\\4Ti>\u0004\b/\u001a3\t\u000f\u0005eq\u0005\"\u0011\u0002\u001c\u0005!\u0002.\u00198eY\u0016l\u0015n]:j]\u001eD\u0015M\u001d$jY\u0016$2aSA\u000f\u0011\u001d\ty\"a\u0006A\u0002!\fA\u0001]1uQ\"1\u00111E\u0014\u0005\n\t\fab\u0019:fCR,Gj\\2l\r&dW\rC\u0004\u0002(\u001d\"I!!\u000b\u0002\u0011A\u0014\u0018N\u001c;FeJ$2aSA\u0016\u0011\u001d\ti#!\nA\u0002!\f1!\\:h\u0001")
public class HeadlessFrontend
extends RecorderFrontend {
    private final RecorderConfiguration configuration;
    private boolean hasRun;

    private boolean hasRun() {
        return this.hasRun;
    }

    private void hasRun_$eq(boolean x$1) {
        this.hasRun = x$1;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configuration.core().mode();
    }

    @Override
    public void receiveEventInfo(EventInfo eventInfo) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Event] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eventInfo})));
    }

    @Override
    public void init() {
        if (!this.hasRun()) {
            this.hasRun_$eq(true);
            Predef$.MODULE$.println((Object)"Starting Recorder in headless mode");
            RecorderMode recorderMode = this.selectedRecorderMode();
            RecorderMode$Proxy$ recorderMode$Proxy$ = RecorderMode$Proxy$.MODULE$;
            if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Proxy$) : recorderMode$Proxy$ != null) && HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile().exists()) {
                this.printErr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recorder lock file found at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()})));
                this.printErr("Make sure that there is no other recording in progress.");
                throw package$.MODULE$.exit(1);
            }
            this.startRecording();
        } else {
            package$.MODULE$.runtime().halt(0);
        }
    }

    @Override
    public void handleHarExportFailure(String message) {
        this.printErr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not convert HAR file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
    }

    @Override
    public String harFilePath() {
        return (String)this.configuration.core().harFilePath().getOrElse((Function0)new HeadlessFrontend$lambda$$harFilePath$1());
    }

    @Override
    public void handleHarExportSuccess() {
        Predef$.MODULE$.println((Object)"HAR file successfully converted.");
    }

    @Override
    public void recordingStarted() {
        this.createLockFile();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recording started, proxy port is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.configuration.proxy().port())})));
        Predef$.MODULE$.println((Object)"To stop the Recorder and generate the Simulation, kill the Recorder process with: ");
        Predef$.MODULE$.println((Object)"- CTRL-C");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"- Use the Recorder's PID, written to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()})));
        package$.MODULE$.addShutdownHook((Function0)new HeadlessFrontend$lambda$$recordingStarted$1(this));
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
    }

    @Override
    public boolean askSimulationOverwrite() {
        this.printErr("Another simulation with the same name exists.");
        return false;
    }

    @Override
    public void recordingStopped() {
        HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile().delete();
        Predef$.MODULE$.println((Object)"New Gatling simulation created.");
    }

    @Override
    public void handleMissingHarFile(String path) {
        String errorMessage = path.isEmpty() ? "The HAR file to convert was not specified, either through recorder.conf or through CLI options." : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find the HAR file (path: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        this.printErr(errorMessage);
    }

    private void createLockFile() {
        String pid = (String)Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getRuntimeMXBean().getName().split("@")).head();
        Io$.MODULE$.withCloseable((AutoCloseable)new PrintStream(HeadlessFrontend$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontend$$RecorderPidFile()), (Function1)new HeadlessFrontend$lambda$$createLockFile$1(pid));
    }

    private void printErr(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public static final /* synthetic */ String io$gatling$recorder$ui$headless$HeadlessFrontend$$$anonfun$1() {
        return "";
    }

    public final /* synthetic */ void io$gatling$recorder$ui$headless$HeadlessFrontend$$$anonfun$2() {
        this.stopRecording(true);
    }

    public static final /* synthetic */ void io$gatling$recorder$ui$headless$HeadlessFrontend$$$anonfun$3(String pid$1, PrintStream x$1) {
        x$1.println(pid$1);
    }

    public HeadlessFrontend(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
        this.hasRun = false;
    }
}

