/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.ConfigHelper$;
import io.gatling.commons.util.Io$;
import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.config.GatlingFiles$;
import io.gatling.core.filter.BlackList;
import io.gatling.core.filter.WhiteList;
import io.gatling.recorder.config.CertificateAuthorityConfiguration;
import io.gatling.recorder.config.ConfigKeys$;
import io.gatling.recorder.config.ConfigKeys$core$;
import io.gatling.recorder.config.ConfigKeys$filters$;
import io.gatling.recorder.config.ConfigKeys$http$;
import io.gatling.recorder.config.ConfigKeys$netty$;
import io.gatling.recorder.config.ConfigKeys$proxy$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$certificateAuthority$;
import io.gatling.recorder.config.ConfigKeys$proxy$https$keyStore$;
import io.gatling.recorder.config.ConfigKeys$proxy$outgoing$;
import io.gatling.recorder.config.CoreConfiguration;
import io.gatling.recorder.config.FilterStrategy$;
import io.gatling.recorder.config.FiltersConfiguration;
import io.gatling.recorder.config.HttpConfiguration;
import io.gatling.recorder.config.HttpsModeConfiguration;
import io.gatling.recorder.config.KeyStoreConfiguration;
import io.gatling.recorder.config.NettyConfiguration;
import io.gatling.recorder.config.OutgoingProxyConfiguration;
import io.gatling.recorder.config.ProxyConfiguration;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$IntOption$;
import io.gatling.recorder.config.RecorderMode$;
import io.gatling.recorder.http.ssl.HttpsMode$;
import io.gatling.recorder.http.ssl.KeyStoreType$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public final class RecorderConfiguration$
implements StrictLogging,
scala.Serializable {
    public static RecorderConfiguration$ MODULE$;
    private final ConfigRenderOptions RenderOptions;
    private Option<Path> configFile;
    private RecorderConfiguration configuration;
    private final GatlingConfiguration gatlingConfiguration;
    private final Logger logger;

    static {
        new RecorderConfiguration$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int IntOption(int value) {
        return value;
    }

    private ConfigRenderOptions RenderOptions() {
        return this.RenderOptions;
    }

    public Option<Path> configFile() {
        return this.configFile;
    }

    public void configFile_$eq(Option<Path> x$1) {
        this.configFile = x$1;
    }

    public RecorderConfiguration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(RecorderConfiguration x$1) {
        this.configuration = x$1;
    }

    public GatlingConfiguration gatlingConfiguration() {
        return this.gatlingConfiguration;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Config getDefaultConfig(ClassLoader classLoader) {
        return ConfigFactory.parseResources((ClassLoader)classLoader, (String)"recorder-defaults.conf");
    }

    public RecorderConfiguration fakeConfig(scala.collection.mutable.Map<String, ?> props) {
        Config defaultConfig = this.getDefaultConfig(this.getClassLoader());
        return this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.parseMap((Map)((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(props).asJava())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{defaultConfig})));
    }

    public void initialSetup(scala.collection.mutable.Map<String, ?> props, Option<Path> recorderConfigFile) {
        ClassLoader classLoader = this.getClassLoader();
        Config defaultConfig = this.getDefaultConfig(classLoader);
        this.configFile_$eq((Option<Path>)recorderConfigFile.orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)classLoader.getResource("recorder.conf")).map((Function1 & Serializable & scala.Serializable)url -> PathHelper$.MODULE$.uri2path(url.toURI()))));
        Config customConfig = (Config)this.configFile().map((Function1 & Serializable & scala.Serializable)path -> ConfigFactory.parseFile((File)path.toFile())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)"recorder.conf file couldn't be located or is outdated");
            Predef$.MODULE$.println((Object)"Recorder preferences won't be saved.");
            Predef$.MODULE$.println((Object)"If running from sbt, please run \"copyConfigFiles\" and check the plugin documentation.");
            return ConfigFactory.empty();
        });
        Config propertiesConfig = ConfigFactory.parseMap((Map)((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(props).asJava()));
        try {
            this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, customConfig, defaultConfig}))));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Loading configuration crashed: {}. Probable cause is a format change, resetting.", new Object[]{Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(e))});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.configFile().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    PathHelper.RichPath$.MODULE$.delete$extension(PathHelper$.MODULE$.RichPath(x$1));
                    return BoxedUnit.UNIT;
                });
                this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultConfig}))));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public Option<Path> initialSetup$default$2() {
        return None$.MODULE$;
    }

    public void reload(scala.collection.mutable.Map<String, ?> props) {
        Config frameConfig = ConfigFactory.parseMap((Map)((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(props).asJava()));
        this.configuration_$eq(this.buildConfig(ConfigHelper$.MODULE$.configChain(frameConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{this.configuration().config()}))));
    }

    public void saveConfig() {
        ConfigObject configToSave = this.configuration().config().withoutPath(ConfigKeys$core$.MODULE$.ResourcesFolder()).root().withOnlyKey(ConfigKeys$.MODULE$.ConfigRoot());
        this.configFile().foreach((Function1 & Serializable & scala.Serializable)file -> {
            Io$.MODULE$.withCloseable((AutoCloseable)PathHelper.RichPath$.MODULE$.writer$extension(PathHelper$.MODULE$.RichPath(RecorderConfiguration$.MODULE$.createAndOpen(file)), RecorderConfiguration$.MODULE$.gatlingConfiguration().core().charset()), (Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.write(configToSave$1.render(RecorderConfiguration$.MODULE$.RenderOptions()));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path createAndOpen(Path path) {
        Path path2;
        if (!PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(path))) {
            Path parent = path.getParent();
            if (!PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(parent))) throw new FileNotFoundException(new StringBuilder(54).append("Directory '").append(((Object)parent).toString()).append("' for recorder configuration does not exist").toString());
            path2 = PathHelper.RichPath$.MODULE$.touch$extension(PathHelper$.MODULE$.RichPath(path));
            return path2;
        } else {
            path2 = path;
        }
        return path2;
    }

    private RecorderConfiguration buildConfig(Config config) {
        return new RecorderConfiguration(new CoreConfiguration(RecorderMode$.MODULE$.apply(config.getString(ConfigKeys$core$.MODULE$.Mode())), config.getString(ConfigKeys$core$.MODULE$.Encoding()), this.getSimulationsFolder$1(config.getString(ConfigKeys$core$.MODULE$.SimulationsFolder())), this.getResourcesFolder$1(config), config.getString(ConfigKeys$core$.MODULE$.Package()), config.getString(ConfigKeys$core$.MODULE$.ClassName()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(config.getInt(ConfigKeys$core$.MODULE$.ThresholdForPauseCreation()))).milliseconds(), config.getBoolean(ConfigKeys$core$.MODULE$.SaveConfig()), config.getBoolean(ConfigKeys$core$.MODULE$.Headless()), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.HarFilePath())))), new FiltersConfiguration(FilterStrategy$.MODULE$.apply(config.getString(ConfigKeys$filters$.MODULE$.FilterStrategy())), new WhiteList((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList(ConfigKeys$filters$.MODULE$.WhitelistPatterns())).asScala()).toList()), new BlackList((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList(ConfigKeys$filters$.MODULE$.BlacklistPatterns())).asScala()).toList())), new HttpConfiguration(config.getBoolean(ConfigKeys$http$.MODULE$.AutomaticReferer()), config.getBoolean(ConfigKeys$http$.MODULE$.FollowRedirect()), config.getBoolean(ConfigKeys$http$.MODULE$.InferHtmlResources()), config.getBoolean(ConfigKeys$http$.MODULE$.RemoveCacheHeaders()), config.getBoolean(ConfigKeys$http$.MODULE$.CheckResponseBodies())), new ProxyConfiguration(config.getInt(ConfigKeys$proxy$.MODULE$.Port()), new HttpsModeConfiguration(HttpsMode$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$.MODULE$.Mode())), new KeyStoreConfiguration(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Path()), config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Password()), KeyStoreType$.MODULE$.apply(config.getString(ConfigKeys$proxy$https$keyStore$.MODULE$.Type()))), new CertificateAuthorityConfiguration(config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.CertificatePath()), config.getString(ConfigKeys$proxy$https$certificateAuthority$.MODULE$.PrivateKeyPath()))), new OutgoingProxyConfiguration((Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Host()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Username()))), (Option<String>)StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$proxy$outgoing$.MODULE$.Password()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.Port()))), RecorderConfiguration$IntOption$.MODULE$.toOption$extension(this.IntOption(config.getInt(ConfigKeys$proxy$outgoing$.MODULE$.SslPort()))))), new NettyConfiguration(config.getInt(ConfigKeys$netty$.MODULE$.MaxInitialLineLength()), config.getInt(ConfigKeys$netty$.MODULE$.MaxHeaderSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxChunkSize()), config.getInt(ConfigKeys$netty$.MODULE$.MaxContentLength())), config);
    }

    public RecorderConfiguration apply(CoreConfiguration core, FiltersConfiguration filters, HttpConfiguration http, ProxyConfiguration proxy, NettyConfiguration netty, Config config) {
        return new RecorderConfiguration(core, filters, http, proxy, netty, config);
    }

    public Option<Tuple6<CoreConfiguration, FiltersConfiguration, HttpConfiguration, ProxyConfiguration, NettyConfiguration, Config>> unapply(RecorderConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.core(), (Object)x$0.filters(), (Object)x$0.http(), (Object)x$0.proxy(), (Object)x$0.netty(), (Object)x$0.config()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String getSimulationsFolder$1(String folder) {
        String string;
        Option option = StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(folder));
        if (option instanceof Some) {
            String f;
            Some some = (Some)option;
            string = f = (String)some.value();
        } else {
            string = scala.sys.package$.MODULE$.env().contains((Object)"GATLING_HOME") ? GatlingFiles$.MODULE$.resourcesDirectory(this.gatlingConfiguration()).toFile().toString() : Properties$.MODULE$.userHome();
        }
        return string;
    }

    private final String getResourcesFolder$1(Config config$1) {
        return config$1.hasPath(ConfigKeys$core$.MODULE$.ResourcesFolder()) ? config$1.getString(ConfigKeys$core$.MODULE$.ResourcesFolder()) : GatlingFiles$.MODULE$.resourcesDirectory(this.gatlingConfiguration()).toFile().toString();
    }

    private RecorderConfiguration$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.RenderOptions = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
        this.configFile = None$.MODULE$;
        this.gatlingConfiguration = GatlingConfiguration$.MODULE$.load(GatlingConfiguration$.MODULE$.load$default$1());
    }
}

