/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.headless;

import io.gatling.commons.util.Io$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.FrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.headless.HeadlessFrontEnd$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ErAB\u0001\u0003\u0011\u0003\u0011A\"\u0001\tIK\u0006$G.Z:t\rJ|g\u000e^#oI*\u00111\u0001B\u0001\tQ\u0016\fG\r\\3tg*\u0011QAB\u0001\u0003k&T!a\u0002\u0005\u0002\u0011I,7m\u001c:eKJT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_B\u0011QBD\u0007\u0002\u0005\u00191qB\u0001E\u0001\u0005A\u0011\u0001\u0003S3bI2,7o\u001d$s_:$XI\u001c3\u0014\u00059\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rC\u0003\u0019\u001d\u0011\u0005!$\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0001b\u0002\u000f\u000f\u0005\u0004%I!H\u0001\u0010%\u0016\u001cwN\u001d3feBKGMR5mKV\ta\u0004\u0005\u0002 G5\t\u0001E\u0003\u0002\fC)\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013!\u0005\u00111\u0015\u000e\\3\t\r\u0019r\u0001\u0015!\u0003\u001f\u0003A\u0011VmY8sI\u0016\u0014\b+\u001b3GS2,\u0007EB\u0003\u0010\u0005\u0001!\u0001f\u0005\u0002(SA\u0011!fK\u0007\u0002\t%\u0011A\u0006\u0002\u0002\u0011%\u0016\u001cwN\u001d3fe\u001a\u0013xN\u001c;F]\u0012D\u0001BL\u0014\u0003\u0002\u0003\u0006IaL\u0001\u000bG>tGO]8mY\u0016\u0014\bC\u0001\u00193\u001b\u0005\t$B\u0001\u0018\u0007\u0013\t\u0019\u0014G\u0001\nSK\u000e|'\u000fZ3s\u0007>tGO]8mY\u0016\u0014\b\u0002C\u001b(\u0005\u0003\u0005\u000b1\u0002\u001c\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t9$(D\u00019\u0015\tId!\u0001\u0004d_:4\u0017nZ\u0005\u0003wa\u0012QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003\u0019O\u0011\u0005Q\b\u0006\u0002?\u0003R\u0011q\b\u0011\t\u0003\u001b\u001dBQ!\u000e\u001fA\u0004YBQA\f\u001fA\u0002=BqaQ\u0014A\u0002\u0013%A)\u0001\u0004iCN\u0014VO\\\u000b\u0002\u000bB\u0011!CR\u0005\u0003\u000fN\u0011qAQ8pY\u0016\fg\u000eC\u0004JO\u0001\u0007I\u0011\u0002&\u0002\u0015!\f7OU;o?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011!\u0003T\u0005\u0003\u001bN\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011k\nQ!\n\u0015\u000bq\u0001[1t%Vt\u0007\u0005C\u0003TO\u0011\u0005C+\u0001\u000btK2,7\r^3e%\u0016\u001cwN\u001d3fe6{G-Z\u000b\u0002+B\u0011qGV\u0005\u0003/b\u0012ABU3d_J$WM]'pI\u0016DQ!W\u0014\u0005Bi\u000bAB]3dK&4X-\u0012<f]R$\"aS.\t\u000bqC\u0006\u0019A/\u0002\u000b\u00154XM\u001c;\u0011\u0005)r\u0016BA0\u0005\u000551%o\u001c8u\u000b:$WI^3oi\")\u0011m\nC!E\u0006!\u0011N\\5u)\u0005Y\u0005\"\u00023(\t\u0003*\u0017A\u00065b]\u0012dW\rS1s\u000bb\u0004xN\u001d;GC&dWO]3\u0015\u0005-3\u0007\"B4d\u0001\u0004A\u0017aB7fgN\fw-\u001a\t\u0003SBt!A\u001b8\u0011\u0005-\u001cR\"\u00017\u000b\u00055L\u0012A\u0002\u001fs_>$h(\u0003\u0002p'\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty7\u0003C\u0003uO\u0011\u0005S/A\u0006iCJ4\u0015\u000e\\3QCRDW#\u00015\t\u000b]<C\u0011\t2\u0002-!\fg\u000e\u001a7f\u0011\u0006\u0014X\t\u001f9peR\u001cVoY2fgNDQ!_\u0014\u0005B\t\f\u0001C]3d_J$\u0017N\\4Ti\u0006\u0014H/\u001a3\t\u000bm<C\u0011\t?\u0002=!\fg\u000e\u001a7f\r&dG/\u001a:WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016\u001cHCA&~\u0011\u0015q(\u00101\u0001\u0000\u0003!1\u0017-\u001b7ve\u0016\u001c\b#BA\u0001\u0003\u0017Ag\u0002BA\u0002\u0003\u000fq1a[A\u0003\u0013\u0005!\u0012bAA\u0005'\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0007\u0003\u001f\u00111aU3r\u0015\r\tIa\u0005\u0005\u0007\u0003'9C\u0011\t#\u0002-\u0005\u001c8nU5nk2\fG/[8o\u001fZ,'o\u001e:ji\u0016Da!a\u0006(\t\u0003\u0012\u0017\u0001\u0005:fG>\u0014H-\u001b8h'R|\u0007\u000f]3e\u0011\u001d\tYb\nC!\u0003;\tA\u0003[1oI2,W*[:tS:<\u0007*\u0019:GS2,GcA&\u0002 !9\u0011\u0011EA\r\u0001\u0004A\u0017\u0001\u00029bi\"Da!!\n(\t\u0013\u0011\u0017AD2sK\u0006$X\rT8dW\u001aKG.\u001a\u0005\b\u0003S9C\u0011BA\u0016\u0003!\u0001(/\u001b8u\u000bJ\u0014HcA&\u0002.!9\u0011qFA\u0014\u0001\u0004A\u0017aA7tO\u0002")
public class HeadlessFrontEnd
extends RecorderFrontEnd {
    private final RecorderConfiguration configuration;
    private boolean hasRun;

    private boolean hasRun() {
        return this.hasRun;
    }

    private void hasRun_$eq(boolean x$1) {
        this.hasRun = x$1;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configuration.core().mode();
    }

    @Override
    public void receiveEvent(FrontEndEvent event) {
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("[Event] ").append(event).toString());
    }

    @Override
    public void init() {
        if (!this.hasRun()) {
            this.hasRun_$eq(true);
            Predef$.MODULE$.println((Object)"Starting Recorder in headless mode");
            RecorderMode recorderMode = this.selectedRecorderMode();
            RecorderMode$Proxy$ recorderMode$Proxy$ = RecorderMode$Proxy$.MODULE$;
            if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Proxy$) : recorderMode$Proxy$ != null) && HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().exists()) {
                this.printErr(new StringBuilder(29).append("Recorder lock file found at ").append(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()).append(".").toString());
                this.printErr("Make sure that there is no other recording in progress.");
                throw package$.MODULE$.exit(1);
            }
            this.startRecording();
        } else {
            package$.MODULE$.runtime().halt(0);
        }
    }

    @Override
    public void handleHarExportFailure(String message) {
        this.printErr(new StringBuilder(28).append("Could not convert HAR file: ").append(message).toString());
    }

    @Override
    public String harFilePath() {
        return (String)this.configuration.core().harFilePath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    @Override
    public void handleHarExportSuccess() {
        Predef$.MODULE$.println((Object)"HAR file successfully converted.");
    }

    @Override
    public void recordingStarted() {
        this.createLockFile();
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Recording started, proxy port is ").append(this.configuration.proxy().port()).toString());
        Predef$.MODULE$.println((Object)"To stop the Recorder and generate the Simulation, kill the Recorder process with: ");
        Predef$.MODULE$.println((Object)"- CTRL-C");
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("- Use the Recorder's PID, written to ").append(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()).toString());
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopRecording(true));
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
    }

    @Override
    public boolean askSimulationOverwrite() {
        this.printErr("Another simulation with the same name exists.");
        return false;
    }

    @Override
    public void recordingStopped() {
        HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().delete();
        Predef$.MODULE$.println((Object)"New Gatling simulation created.");
    }

    @Override
    public void handleMissingHarFile(String path) {
        String errorMessage = path.isEmpty() ? "The HAR file to convert was not specified, either through recorder.conf or through CLI options." : new StringBuilder(36).append("Could not find the HAR file (path: ").append(path).append(")").toString();
        this.printErr(errorMessage);
    }

    private void createLockFile() {
        String pid = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getRuntimeMXBean().getName().split("@"))).head();
        Io$.MODULE$.withCloseable((AutoCloseable)new PrintStream(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.println(pid);
            return BoxedUnit.UNIT;
        });
    }

    private void printErr(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public HeadlessFrontEnd(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
        this.hasRun = false;
    }
}

