/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.har;

import io.gatling.commons.util.Io$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.filter.Filters;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.recorder.har.HarParser;
import io.gatling.recorder.har.HarParser$;
import io.gatling.recorder.har.HttpTransaction;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Locale;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class HarReader$ {
    public static HarReader$ MODULE$;
    private final Regex WrappedValue;

    static {
        new HarReader$();
    }

    public Seq<HttpTransaction> readFile(String path, Option<Filters> filters) {
        return (Seq)Io$.MODULE$.withCloseable((AutoCloseable)new FileInputStream(path), (Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.readStream((InputStream)x$1, filters));
    }

    public Seq<HttpTransaction> readStream(InputStream is, Option<Filters> filters) {
        Seq<HarParser.HarEntry> harEntries = HarParser$.MODULE$.parseHarEntries(is);
        Seq filteredHarEntries = (Seq)harEntries.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)filters.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.accept(entry.request().url())))));
        return this.buildHttpTransactions((Seq<HarParser.HarEntry>)filteredHarEntries);
    }

    private long parseMillisFromIso8601DateTime(String time) {
        return ZonedDateTime.parse(time).toInstant().toEpochMilli();
    }

    private Seq<HttpTransaction> buildHttpTransactions(Seq<HarParser.HarEntry> harEntries) {
        return (Seq)harEntries.iterator().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$1(x$3))).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildHttpTransactions$2(entry))).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)HarReader$.MODULE$.isValidURL(entry.request().url()))).map((Function1 & Serializable & scala.Serializable)entry -> MODULE$.buildHttpTransaction((HarParser.HarEntry)entry)).toVector().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)HarReader$.$anonfun$buildHttpTransactions$5(x$4)), (Ordering)Ordering.Long$.MODULE$);
    }

    private boolean isValidURL(String url) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URL(url)).isSuccess();
    }

    private HttpTransaction buildHttpTransaction(HarParser.HarEntry entry) {
        long start = this.parseMillisFromIso8601DateTime(entry.startedDateTime());
        long time = (long)BoxesRunTime.unboxToDouble((Object)entry.time().orElse((Function0 & Serializable & scala.Serializable)() -> entry.timings().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.time()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Neither time nor timings");
        }));
        long end = start + time;
        return new HttpTransaction(this.buildRequest(entry.request(), start), this.buildResponse(entry.response(), end));
    }

    private Regex WrappedValue() {
        return this.WrappedValue;
    }

    private String unwrap(String raw) {
        String unwrapped;
        String string = raw;
        Option option = this.WrappedValue().unapplySeq((CharSequence)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (unwrapped = (String)((LinearSeqOptimized)option.get()).apply(0)) : raw;
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private HttpHeaders buildHeaders(Seq<HarParser.HarHeader> harHeaders) {
        void var2_2;
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        harHeaders.foreach((Function1 & Serializable & scala.Serializable)harHeader -> headers.add(harHeader.name(), (Object)MODULE$.unwrap(harHeader.value())));
        return var2_2;
    }

    private HttpRequest buildRequest(HarParser.HarRequest request, long timestamp) {
        HttpHeaders headers = this.buildHeaders(request.headers());
        byte[] body = (byte[])request.postData().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.buildRequestBody((HarParser.HarRequestPostData)x$6, headers)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
        return new HttpRequest(request.httpVersion(), request.method(), request.url(), headers, body, timestamp);
    }

    private String encode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
    }

    private Option<byte[]> buildRequestBody(HarParser.HarRequestPostData postData, HttpHeaders requestHeaders) {
        None$ none$;
        Option option = postData.text().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$7)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.value();
            none$ = new Some((Object)string.getBytes(StandardCharsets.UTF_8));
        } else {
            none$ = postData.params().nonEmpty() && Option$.MODULE$.apply((Object)requestHeaders.get(HeaderNames$.MODULE$.ContentType())).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildRequestBody$2(x$8))) ? new Some((Object)((TraversableOnce)postData.params().map((Function1 & Serializable & scala.Serializable)postParam -> new StringBuilder(1).append(MODULE$.encode(postParam.name())).append("=").append(MODULE$.encode(MODULE$.unwrap(postParam.value()))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("&").getBytes(StandardCharsets.UTF_8)) : None$.MODULE$;
        }
        return none$;
    }

    private HttpResponse buildResponse(HarParser.HarResponse response, long timestamp) {
        return new HttpResponse(response.status(), response.statusText(), this.buildHeaders(response.headers()), (byte[])this.buildResponseBody(response.content()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), timestamp);
    }

    private Option<byte[]> buildResponseBody(HarParser.HarResponseContent content) {
        return content.text().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$9))).withFilter((Function1 & Serializable & scala.Serializable)text -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildResponseBody$2(content, text))).withFilter((Function1 & Serializable & scala.Serializable)text -> BoxesRunTime.boxToBoolean((boolean)HarReader$.$anonfun$buildResponseBody$3(content, text))).map((Function1 & Serializable & scala.Serializable)text -> {
            Some some;
            String string;
            Option option = content.encoding().flatMap((Function1 & Serializable & scala.Serializable)x$10 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$10)));
            byte[] byArray = option instanceof Some && "base64".equals(string = (String)(some = (Some)option).value()) ? Base64.getDecoder().decode((String)text) : text.getBytes(StandardCharsets.UTF_8);
            return byArray;
        });
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$1(HarParser.HarEntry x$3) {
        return x$3.request().url().toString().toLowerCase(Locale.ROOT).startsWith("http");
    }

    public static final /* synthetic */ boolean $anonfun$buildHttpTransactions$2(HarParser.HarEntry entry) {
        String string = entry.request().method();
        String string2 = HttpMethod.CONNECT.name();
        return (string == null ? string2 != null : !string.equals(string2)) && !entry.request().headers().contains((Object)HttpHeaderValues.UPGRADE);
    }

    public static final /* synthetic */ long $anonfun$buildHttpTransactions$5(HttpTransaction x$4) {
        return x$4.request().timestamp();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequestBody$2(String x$8) {
        return x$8.toLowerCase(Locale.ROOT).contains(HeaderValues$.MODULE$.ApplicationFormUrlEncoded());
    }

    public static final /* synthetic */ boolean $anonfun$buildResponseBody$2(HarParser.HarResponseContent content$1, String text) {
        return !content$1.mimeType().contains((Object)"x-unknown");
    }

    public static final /* synthetic */ boolean $anonfun$buildResponseBody$3(HarParser.HarResponseContent content$1, String text) {
        return content$1.comment().isEmpty();
    }

    private HarReader$() {
        MODULE$ = this;
        this.WrappedValue = new StringOps(Predef$.MODULE$.augmentString("\"(.*)\"")).r();
    }
}

