/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.http.TrafficLogger;
import io.gatling.recorder.http.flows.MitmMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\ti1\t\\5f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\t!$H\u000f\u001d\u0006\u0003\u000b\u0019\t\u0001B]3d_J$WM\u001d\u0006\u0003\u000f!\tqaZ1uY&twMC\u0001\n\u0003\tIwn\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u000591\r[1o]\u0016d'BA\t\t\u0003\u0015qW\r\u001e;z\u0013\t\u0019bB\u0001\u000fDQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:BI\u0006\u0004H/\u001a:\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012\u0001D:dC2\fGn\\4hS:<'BA\r\u001b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u000e\u0002\u0007\r|W.\u0003\u0002\u001e-\ti1\u000b\u001e:jGRdunZ4j]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\n[&$X.Q2u_J\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0015\nA!Y6lC&\u0011qE\t\u0002\t\u0003\u000e$xN\u001d*fM\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\btKJ4XM]\"iC:tW\r\\%e!\ti1&\u0003\u0002-\u001d\tI1\t[1o]\u0016d\u0017\n\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005iAO]1gM&\u001cGj\\4hKJ\u0004\"\u0001M\u0019\u000e\u0003\tI!A\r\u0002\u0003\u001bQ\u0013\u0018M\u001a4jG2{wmZ3s\u0011!!\u0004A!A!\u0002\u0013)\u0014!B2m_\u000e\\\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011)H/\u001b7\u000b\u0005i2\u0011aB2p[6|gn]\u0005\u0003y]\u0012Qa\u00117pG.DQA\u0010\u0001\u0005\u0002}\na\u0001P5oSRtD#\u0002!B\u0005\u000e#\u0005C\u0001\u0019\u0001\u0011\u0015yR\b1\u0001!\u0011\u0015IS\b1\u0001+\u0011\u0015qS\b1\u00010\u0011\u0015!T\b1\u00016\u0011\u00151\u0005\u0001\"\u0011H\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u0007!s5\u000b\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0003V]&$\b\"B(F\u0001\u0004\u0001\u0016aA2uqB\u0011Q\"U\u0005\u0003%:\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003U\u000b\u0002\u0007Q+A\u0002ng\u001e\u0004\"!\u0013,\n\u0005]S%AB!osJ+g\rC\u0003Z\u0001\u0011\u0005#,A\bdQ\u0006tg.\u001a7J]\u0006\u001cG/\u001b<f)\tA5\fC\u0003P1\u0002\u0007\u0001\u000bC\u0003^\u0001\u0011\u0005c,A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\rAu\f\u0019\u0005\u0006\u001fr\u0003\r\u0001\u0015\u0005\u0006Cr\u0003\rAY\u0001\u0006G\u0006,8/\u001a\t\u0003G.t!\u0001Z5\u000f\u0005\u0015DW\"\u00014\u000b\u0005\u001dT\u0011A\u0002\u001fs_>$h(C\u0001L\u0013\tQ'*A\u0004qC\u000e\\\u0017mZ3\n\u00051l'!\u0003+ie><\u0018M\u00197f\u0015\tQ'\n")
public class ClientHandler
extends ChannelInboundHandlerAdapter
implements StrictLogging {
    private final ActorRef mitmActor;
    private final ChannelId serverChannelId;
    private final TrafficLogger trafficLogger;
    private final Clock clock;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        long receiveTimestamp = this.clock.nowMillis();
        Object object = msg;
        if (object instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
            this.trafficLogger.logResponse(this.serverChannelId, fullHttpResponse, receiveTimestamp);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.mitmActor);
            MitmMessage.ResponseReceived x$1 = new MitmMessage.ResponseReceived(fullHttpResponse);
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Received unknown message: {}", new Object[]{object});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.mitmActor);
        MitmMessage.ClientChannelInactive x$3 = new MitmMessage.ClientChannelInactive(ctx.channel().id());
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.mitmActor);
        MitmMessage.ClientChannelException x$5 = new MitmMessage.ClientChannelException(cause);
        ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
        qual$3.$bang((Object)x$5, x$6);
    }

    public ClientHandler(ActorRef mitmActor, ChannelId serverChannelId, TrafficLogger trafficLogger, Clock clock) {
        this.mitmActor = mitmActor;
        this.serverChannelId = serverChannelId;
        this.trafficLogger = trafficLogger;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
    }
}

