/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.http.Mitm;
import io.gatling.recorder.http.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.SslFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0001\u0003\u0001\u0011Q!A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004\"AE\r\u000e\u0003MQ!\u0001F\u000b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005Y9\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003a\t1aY8n\u0013\tQ2CA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005)1\r\\8dW\u000e\u0001\u0001CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011)H/\u001b7\u000b\u0005\r2\u0011aB2p[6|gn]\u0005\u0003K\u0001\u0012Qa\u00117pG.DQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015ab\u00051\u0001\u001f\u0011\u001di\u0003A1A\u0005\n9\n\u0001B\u001a:p]R,e\u000eZ\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!\u0007B\u0001\u0003k&L!\u0001N\u0019\u0003!I+7m\u001c:eKJ4%o\u001c8u\u000b:$\u0007B\u0002\u001c\u0001A\u0003%q&A\u0005ge>tG/\u00128eA!I\u0001\b\u0001a\u0001\u0002\u0004%I!O\u0001\u0005[&$X.F\u0001;!\tYd(D\u0001=\u0015\tiD!\u0001\u0003iiR\u0004\u0018BA =\u0005\u0011i\u0015\u000e^7\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0015\u0001C7ji6|F%Z9\u0015\u0005\r3\u0005C\u0001\u0007E\u0013\t)UB\u0001\u0003V]&$\bbB$A\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0004\"C%\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0003\u0015i\u0017\u000e^7!Q\tA5\n\u0005\u0002\r\u0019&\u0011Q*\u0004\u0002\tm>d\u0017\r^5mK\"9q\n\u0001b\u0001\n\u0013\u0001\u0016\u0001\u0003:fcV,7\u000f^:\u0016\u0003E\u00032A\u0015-[\u001b\u0005\u0019&B\u0001+V\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003CYS\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z'\n)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007cA._A6\tAL\u0003\u0002^\t\u0005A1oY3oCJLw.\u0003\u0002`9\n!B+[7fIN\u001bWM\\1sS>,E.Z7f]R\u0004\"aW1\n\u0005\td&A\u0004*fcV,7\u000f^#mK6,g\u000e\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B)\u0002\u0013I,\u0017/^3tiN\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u0005i\u0006<7/F\u0001i!\r\u0011\u0006,\u001b\t\u00047zS\u0007CA.l\u0013\taGL\u0001\u0006UC\u001e,E.Z7f]RDaA\u001c\u0001!\u0002\u0013A\u0017!\u0002;bON\u0004\u0003\"\u00029\u0001\t\u0003\t\u0018AD:uCJ$(+Z2pe\u0012Lgn\u001a\u000b\u0002\u0007\")1\u000f\u0001C\u0001i\u0006i1\u000f^8q%\u0016\u001cwN\u001d3j]\u001e$\"aQ;\t\u000bY\u0014\b\u0019A<\u0002\tM\fg/\u001a\t\u0003\u0019aL!!_\u0007\u0003\u000f\t{w\u000e\\3b]\")1\u0010\u0001C\u0001y\u0006y!/Z2fSZ,'+Z:q_:\u001cX\r\u0006\u0003D{\u0006-\u0001\"\u0002@{\u0001\u0004y\u0018a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0003\u0002\u000b5|G-\u001a7\n\t\u0005%\u00111\u0001\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fC\u0004\u0002\u000ei\u0004\r!a\u0004\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\u0001\u0002\u0012%!\u00111CA\u0002\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0011\u001d\t9\u0002\u0001C\u0001\u00033\ta!\u00193e)\u0006<GcA\"\u0002\u001c!A\u0011QDA\u000b\u0001\u0004\ty\"\u0001\u0003uKb$\b\u0003BA\u0011\u0003_qA!a\t\u0002,A\u0019\u0011QE\u0007\u000e\u0005\u0005\u001d\"bAA\u0015;\u00051AH]8pizJ1!!\f\u000e\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011GA\u001a\u0005\u0019\u0019FO]5oO*\u0019\u0011QF\u0007\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005\u00012/Z2ve\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0004\u0007\u0006m\u0002\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\u001dM,7-\u001e:fI\"{7\u000f^+S\u0013B!\u0011\u0011IA)\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013aA;sS*!\u0011\u0011JA&\u0003\r\t\u0007n\u0019\u0006\u0005\u0003\u001b\ny%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003{\u0019IA!a\u0015\u0002D\t\u0019QK]5\t\r\u0005]\u0003\u0001\"\u0001r\u0003I\u0019G.Z1s%\u0016\u001cwN\u001d3feN#\u0018\r^3")
public class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private volatile Mitm mitm;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        String harFilePath = this.frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(harFilePath)))) {
            this.frontEnd().handleMissingHarFile(harFilePath);
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = proceed = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.frontEnd().askSimulationOverwrite() : true;
            if (proceed) {
                RecorderMode recorderMode2 = selectedMode;
                if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                    Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, RecorderConfiguration$.MODULE$.configuration());
                    if (validation instanceof Failure) {
                        Failure failure = (Failure)validation;
                        String errMsg = failure.message();
                        this.frontEnd().handleHarExportFailure(errMsg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.frontEnd().handleHarExportSuccess();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                    this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, RecorderConfiguration$.MODULE$.configuration()));
                    this.frontEnd().recordingStarted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)recorderMode2);
                }
            }
        }
    }

    public void stopRecording(boolean save) {
        this.frontEnd().recordingStopped();
        try {
            if (this.requests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.requests()).asScala()).toVector(), (Seq<TimedScenarioElement<TagElement>>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tags()).asScala()).toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        block0: {
            if (!RecorderConfiguration$.MODULE$.configuration().filters().filters().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(request.uri())))) break block0;
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, RecorderConfiguration$.MODULE$.configuration())));
            Option previousSendTime = ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.requests()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)t -> {
                block0: {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                    if (!delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) break block0;
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEvent(new SslFrontEndEvent(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
    }
}

