/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render.template;

import io.gatling.commons.util.StringHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.render.DumpedBody;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.PauseElement;
import io.gatling.recorder.render.ProtocolDefinition;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.template.ExtractedUris;
import io.gatling.recorder.render.template.ExtractedUris$;
import io.gatling.recorder.render.template.ProtocolTemplate;
import io.gatling.recorder.render.template.RenderingFormat;
import io.gatling.recorder.render.template.RenderingFormat$Java11$;
import io.gatling.recorder.render.template.RenderingFormat$Java17$;
import io.gatling.recorder.render.template.RenderingFormat$Kotlin$;
import io.gatling.recorder.render.template.RenderingFormat$Scala$;
import io.gatling.recorder.render.template.RequestTemplate;
import io.gatling.recorder.render.template.SimulationTemplate$;
import io.gatling.recorder.render.template.UrlVal;
import io.gatling.recorder.render.template.package$;
import io.gatling.recorder.render.template.package$TemplateString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005esA\u0002\u000b\u0016\u0011\u00039rD\u0002\u0004\"+!\u0005qC\t\u0005\u0006S\u0005!\ta\u000b\u0005\u0006Y\u0005!\t!\f\u0005\t\u0003s\tA\u0011A\u000b\u0002<!A\u00111J\u0001\u0005\u0002U\ti\u0005C\u0005\u0002T\u0005\u0011\r\u0011\"\u0003\u0002V!9\u0011qK\u0001!\u0002\u00131f!B\u0011\u0016\u0001]y\u0003\u0002\u0003\u0019\t\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011qB!\u0011!Q\u0001\nEB\u0001\"\u0010\u0005\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\"\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0003B\u0001B\u0003%a\tC\u0003*\u0011\u0011\u0005\u0011\nC\u0003P\u0011\u0011%\u0001\u000bC\u0003f\u0011\u0011%a\rC\u0003z\u0011\u0011%!\u0010\u0003\u0004\u0000\u0011\u0011%\u0011\u0011\u0001\u0005\u00071!!\t!a\u0002\u0002%MKW.\u001e7bi&|g\u000eV3na2\fG/\u001a\u0006\u0003-]\t\u0001\u0002^3na2\fG/\u001a\u0006\u00031e\taA]3oI\u0016\u0014(B\u0001\u000e\u001c\u0003!\u0011XmY8sI\u0016\u0014(B\u0001\u000f\u001e\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AH\u0001\u0003S>\u0004\"\u0001I\u0001\u000e\u0003U\u0011!cU5nk2\fG/[8o)\u0016l\u0007\u000f\\1uKN\u0011\u0011a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aH\u0001\u0006CB\u0004H.\u001f\u000b\b]\u0005e\u0011QEA\u0015!\t\u0001\u0003b\u0005\u0002\tG\u0005Y\u0001/Y2lC\u001e,g*Y7f!\t\u0011\u0014H\u0004\u00024oA\u0011A'J\u0007\u0002k)\u0011aGK\u0001\u0007yI|w\u000e\u001e \n\u0005a*\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0013\u0002'MLW.\u001e7bi&|gn\u00117bgNt\u0015-\\3\u0002\r\u0019|'/\\1u!\t\u0001s(\u0003\u0002A+\ty!+\u001a8eKJLgn\u001a$pe6\fG/\u0001\tqe>$xnY8m)\u0016l\u0007\u000f\\1uKB\u0011\u0001eQ\u0005\u0003\tV\u0011\u0001\u0003\u0015:pi>\u001cw\u000e\u001c+f[Bd\u0017\r^3\u0002\u001fI,\u0017/^3tiR+W\u000e\u001d7bi\u0016\u0004\"\u0001I$\n\u0005!+\"a\u0004*fcV,7\u000f\u001e+f[Bd\u0017\r^3\u0015\r9R5\nT'O\u0011\u0015\u0001d\u00021\u00012\u0011\u0015ad\u00021\u00012\u0011\u0015id\u00021\u0001?\u0011\u0015\te\u00021\u0001C\u0011\u0015)e\u00021\u0001G\u00035\u0011XM\u001c3fe\"+\u0017\rZ3sgR\u0011\u0011'\u0015\u0005\u0006%>\u0001\raU\u0001\bQ\u0016\fG-\u001a:t!\u0011\u0011DKV-\n\u0005U[$aA'baB\u0011AeV\u0005\u00031\u0016\u00121!\u00138u!\rQvL\u0019\b\u00037vs!\u0001\u000e/\n\u0003\u0019J!AX\u0013\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u0004'\u0016\f(B\u00010&!\u0011!3-M\u0019\n\u0005\u0011,#A\u0002+va2,''A\u000bsK:$WM]*dK:\f'/[8FY\u0016lWM\u001c;\u0015\u0007\u001dtG\u000f\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!AO5\t\u000b=\u0004\u0002\u0019\u00019\u0002\u0005M,\u0007CA9s\u001b\u00059\u0012BA:\u0018\u0005IAE\u000f\u001e9Ue\u00064g-[2FY\u0016lWM\u001c;\t\u000bU\u0004\u0002\u0019\u0001<\u0002\u001b\u0015DHO]1di\u0016$WK]5t!\t\u0001s/\u0003\u0002y+\tiQ\t\u001f;sC\u000e$X\rZ+sSN\fQb\u00195bS:,E.Z7f]R\u001cHcA\u0019|y\")Q/\u0005a\u0001m\")Q0\u0005a\u0001}\u0006AQ\r\\3nK:$8\u000fE\u0002[?B\faB]3oI\u0016\u00148kY3oCJLw\u000eF\u00032\u0003\u0007\t)\u0001C\u0003v%\u0001\u0007a\u000fC\u0003~%\u0001\u0007a\u0010F\u00042\u0003\u0013\t\u0019\"!\u0006\t\u000f\u0005-1\u00031\u0001\u0002\u000e\u0005A\u0001O]8u_\u000e|G\u000eE\u0002r\u0003\u001fI1!!\u0005\u0018\u0005I\u0001&o\u001c;pG>dG)\u001a4j]&$\u0018n\u001c8\t\u000bI\u001b\u0002\u0019A*\t\r\u0005]1\u00031\u0001\u007f\u0003A\u00198-\u001a8be&|W\t\\3nK:$8\u000fC\u0004\u0002\u001c\r\u0001\r!!\b\u0002\u001bI,\u0017/^3ti\n{G-[3t!\u0015\u0011DKVA\u0010!\r\t\u0018\u0011E\u0005\u0004\u0003G9\"A\u0003#v[B,GMQ8es\"9\u0011qE\u0002A\u0002\u0005u\u0011A\u0004:fgB|gn]3C_\u0012LWm\u001d\u0005\b\u0003W\u0019\u0001\u0019AA\u0017\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024e\taaY8oM&<\u0017\u0002BA\u001c\u0003c\u0011QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g.A\tsK:$WM\u001d(p]\n\u000b7/Z+sYN$R!MA\u001f\u0003\u0013Bq!a\u0010\u0005\u0001\u0004\t\t%\u0001\u0004wC2,Xm\u001d\t\u00055~\u000b\u0019\u0005E\u0002!\u0003\u000bJ1!a\u0012\u0016\u0005\u0019)&\u000f\u001c,bY\")Q\b\u0002a\u0001}\u0005\u0001\u0002.Z1eKJ\u001c(\t\\8dW:\u000bW.\u001a\u000b\u0004O\u0006=\u0003BBA)\u000b\u0001\u0007a+\u0001\u0002jI\u0006\u0011R*\u0019=FY\u0016lWM\u001c;QKJ\u001c\u0005.Y5o+\u00051\u0016aE'bq\u0016cW-\\3oiB+'o\u00115bS:\u0004\u0003")
public class SimulationTemplate {
    private final String packageName;
    private final String simulationClassName;
    private final RenderingFormat format;
    private final ProtocolTemplate protocolTemplate;
    private final RequestTemplate requestTemplate;

    public static SimulationTemplate apply(Map<Object, DumpedBody> requestBodies, Map<Object, DumpedBody> responseBodies, RecorderConfiguration configuration) {
        return SimulationTemplate$.MODULE$.apply(requestBodies, responseBodies, configuration);
    }

    private String renderHeaders(Map<Object, Seq<Tuple2<String, String>>> headers) {
        return ((IterableOnceOps)headers.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int headersBlockIndex = tuple2._1$mcI$sp();
                Seq headersBlock = (Seq)tuple2._2();
                String headerReference = SimulationTemplate$.MODULE$.headersBlockName(headersBlockIndex);
                Seq protectedHeaders = (Seq)headersBlock.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return new Tuple2((Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(name), $this.format), (Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(value), $this.format));
                    }
                    throw new MatchError((Object)tuple2);
                });
                RenderingFormat renderingFormat = $this.format;
                if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple22;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple22 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple22._1();
                        String protectedValue = (String)tuple22._2();
                        return "private val " + headerReference + " = Map(" + protectedName + " -> " + protectedValue + ")";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private val " + headerReference + " = Map(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "\t\t" + protectedName + " -> " + protectedValue;
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |)"));
                }
                if (RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple23;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple23 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple23._1();
                        String protectedValue = (String)tuple23._2();
                        return "private val " + headerReference + " = mapOf(" + protectedName + " to " + protectedValue + ")";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private val " + headerReference + " = mapOf(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "  " + protectedName + " to " + protectedValue;
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |)"));
                }
                if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple24;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple24 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple24._1();
                        String protectedValue = (String)tuple24._2();
                        return "private Map<CharSequence, String> " + headerReference + " = Map.of(" + protectedName + ", " + protectedValue + ");";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private Map<CharSequence, String> " + headerReference + " = Map.ofEntries(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "  Map.entry(" + protectedName + ", " + protectedValue + ")";
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |);"));
                }
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Map<CharSequence, String> " + headerReference + " = new HashMap<>();\n               |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$6 -> {
                    Tuple2 tuple2 = x0$6;
                    if (tuple2 != null) {
                        String protectedName = (String)tuple2._1();
                        String protectedValue = (String)tuple2._2();
                        return headerReference + ".put(" + protectedName + ", " + protectedValue + ");";
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(StringHelper$.MODULE$.Eol())));
            }
            throw new MatchError((Object)tuple2);
        })).mkString(StringHelper$.MODULE$.Eol(), StringHelper$.MODULE$.Eol() + StringHelper$.MODULE$.Eol(), "");
    }

    private String renderScenarioElement(HttpTrafficElement se, ExtractedUris extractedUris) {
        HttpTrafficElement httpTrafficElement = se;
        if (httpTrafficElement instanceof TagElement) {
            TagElement tagElement = (TagElement)httpTrafficElement;
            String text = tagElement.text();
            return "// " + text;
        }
        if (httpTrafficElement instanceof PauseElement) {
            RenderingFormat renderingFormat;
            PauseElement pauseElement = (PauseElement)httpTrafficElement;
            FiniteDuration duration = pauseElement.duration();
            String pauseString = duration.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()) ? Long.toString(duration.toSeconds()) : (RenderingFormat$Scala$.MODULE$.equals(renderingFormat = this.format) ? duration.toMillis() + ".milliseconds" : "Duration.ofMillis(" + duration.toMillis() + ")");
            return "pause(" + pauseString + ")";
        }
        if (httpTrafficElement instanceof RequestElement) {
            RequestElement requestElement = (RequestElement)httpTrafficElement;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(String.valueOf(this.requestTemplate.render(this.simulationClassName, requestElement, extractedUris))));
        }
        throw new MatchError((Object)httpTrafficElement);
    }

    private String chainElements(ExtractedUris extractedUris, Seq<HttpTrafficElement> elements) {
        return ((IterableOnceOps)elements.map((Function1 & Serializable)x$2 -> this.renderScenarioElement((HttpTrafficElement)x$2, extractedUris))).mkString("," + StringHelper$.MODULE$.Eol());
    }

    private String renderScenario(ExtractedUris extractedUris, Seq<HttpTrafficElement> elements) {
        String string;
        String string2;
        RenderingFormat renderingFormat = this.format;
        if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
            string2 = "val";
        } else if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
            string2 = "ScenarioBuilder";
        } else {
            throw new MatchError((Object)renderingFormat);
        }
        String scenarioReferenceType = string2;
        if (IterableOps.SizeCompareOps$.MODULE$.$less$eq$extension(elements.sizeIs(), SimulationTemplate$.MODULE$.io$gatling$recorder$render$template$SimulationTemplate$$MaxElementPerChain())) {
            String scenarioElements = this.chainElements(extractedUris, elements);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private " + scenarioReferenceType + " scn = scenario(\"" + this.simulationClassName + "\")\n         |  .exec(\n         |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(String.valueOf(scenarioElements)), 4) + "\n         |  )" + this.format.lineTermination()));
        }
        List chains = ((List)elements.grouped(SimulationTemplate$.MODULE$.io$gatling$recorder$render$template$SimulationTemplate$$MaxElementPerChain()).toList().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq chain = (Seq)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)this.chainElements(extractedUris, (Seq<HttpTrafficElement>)chain));
            }
            throw new MatchError((Object)tuple2);
        });
        RenderingFormat renderingFormat2 = this.format;
        if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat2) ? true : RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat2)) {
            string = "val";
        } else if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat2) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat2)) {
            string = "ChainBuilder";
        } else {
            throw new MatchError((Object)renderingFormat2);
        }
        String chainReferenceType = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(((IterableOnceOps)chains.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int i = tuple2._1$mcI$sp();
                String content = (String)tuple2._2();
                return "private " + chainReferenceType + " chain_" + i + " =" + StringHelper$.MODULE$.Eol() + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(content), 2);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(this.format.lineTermination() + StringHelper$.MODULE$.Eol() + StringHelper$.MODULE$.Eol()) + "\n         |\n         |" + scenarioReferenceType + " scn = scenario(\"" + this.simulationClassName + "\")\n         |  .exec(" + ((IterableOnceOps)chains.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int i = tuple2._1$mcI$sp();
                return "chain_" + i;
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ") + ")" + this.format.lineTermination()));
    }

    public String render(ProtocolDefinition protocol, Map<Object, Seq<Tuple2<String, String>>> headers, Seq<HttpTrafficElement> scenarioElements) {
        ExtractedUris extractedUris = ExtractedUris$.MODULE$.apply(scenarioElements, this.format);
        Seq<UrlVal> nonBaseUrls = extractedUris.nonBaseUrls(protocol.baseUrl());
        RenderingFormat renderingFormat = this.format;
        if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + StringHelper$.MODULE$.Eol() : "") + "\n           |import scala.concurrent.duration._\n           |\n           |import io.gatling.core.Predef._\n           |import io.gatling.http.Predef._\n           |import io.gatling.jdbc.Predef._\n           |\n           |class " + this.simulationClassName + " extends Simulation {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |\tsetUp(scn.inject(atOnceUsers(1))).protocols(httpProtocol)\n           |}\n           |"));
        }
        if (RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + StringHelper$.MODULE$.Eol() : "") + "\n           |import java.time.Duration\n           |\n           |import io.gatling.javaapi.core.*\n           |import io.gatling.javaapi.http.*\n           |import io.gatling.javaapi.jdbc.*\n           |\n           |import io.gatling.javaapi.core.CoreDsl.*\n           |import io.gatling.javaapi.http.HttpDsl.*\n           |import io.gatling.javaapi.jdbc.JdbcDsl.*\n           |\n           |class " + this.simulationClassName + " : Simulation() {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |  init {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol)\n           |  }\n           |}\n           |"));
        }
        if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + ";" + StringHelper$.MODULE$.Eol() : "") + "\n           |import java.time.Duration;\n           |import java.util.*;\n           |\n           |import io.gatling.javaapi.core.*;\n           |import io.gatling.javaapi.http.*;\n           |import io.gatling.javaapi.jdbc.*;\n           |\n           |import static io.gatling.javaapi.core.CoreDsl.*;\n           |import static io.gatling.javaapi.http.HttpDsl.*;\n           |import static io.gatling.javaapi.jdbc.JdbcDsl.*;\n           |\n           |public class " + this.simulationClassName + " extends Simulation {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |  {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol);\n           |  }\n           |}\n           |"));
        }
        throw new MatchError((Object)renderingFormat);
    }

    public SimulationTemplate(String packageName, String simulationClassName, RenderingFormat format, ProtocolTemplate protocolTemplate, RequestTemplate requestTemplate) {
        this.packageName = packageName;
        this.simulationClassName = simulationClassName;
        this.format = format;
        this.protocolTemplate = protocolTemplate;
        this.requestTemplate = requestTemplate;
    }
}

