/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render.template;

import io.gatling.commons.util.StringHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.render.DumpedBody;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.PauseElement;
import io.gatling.recorder.render.ProtocolDefinition;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.template.ExtractedUris;
import io.gatling.recorder.render.template.ExtractedUris$;
import io.gatling.recorder.render.template.ProtocolTemplate;
import io.gatling.recorder.render.template.RenderingFormat;
import io.gatling.recorder.render.template.RenderingFormat$Java11$;
import io.gatling.recorder.render.template.RenderingFormat$Java17$;
import io.gatling.recorder.render.template.RenderingFormat$JavaScript$;
import io.gatling.recorder.render.template.RenderingFormat$Kotlin$;
import io.gatling.recorder.render.template.RenderingFormat$Scala$;
import io.gatling.recorder.render.template.RenderingFormat$TypeScript$;
import io.gatling.recorder.render.template.RequestTemplate;
import io.gatling.recorder.render.template.SimulationTemplate$;
import io.gatling.recorder.render.template.UrlVal;
import io.gatling.recorder.render.template.package$;
import io.gatling.recorder.render.template.package$TemplateString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015sAB\t\u0013\u0011\u0003!BD\u0002\u0004\u001f%!\u0005Ac\b\u0005\u0006M\u0005!\t\u0001\u000b\u0005\u0006S\u0005!\tA\u000b\u0005\t\u0003W\tA\u0011\u0001\n\u0002.!A\u0011QH\u0001\u0005\u0002I\tyDB\u0003\u001f%\u0001!B\u0006\u0003\u0005.\r\t\u0005\t\u0015!\u0003/\u0011!IdA!A!\u0002\u0013q\u0003\u0002\u0003\u001e\u0007\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011y2!\u0011!Q\u0001\n}B\u0001B\u0011\u0004\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006M\u0019!\tA\u0012\u0005\u0006\u0019\u001a!I!\u0014\u0005\u0006E\u001a!Ia\u0019\u0005\u0006m\u001a!Ia\u001e\u0005\u0006+\u0019!\t\u0001`\u0001\u0013'&lW\u000f\\1uS>tG+Z7qY\u0006$XM\u0003\u0002\u0014)\u0005AA/Z7qY\u0006$XM\u0003\u0002\u0016-\u00051!/\u001a8eKJT!a\u0006\r\u0002\u0011I,7m\u001c:eKJT!!\u0007\u000e\u0002\u000f\u001d\fG\u000f\\5oO*\t1$\u0001\u0002j_B\u0011Q$A\u0007\u0002%\t\u00112+[7vY\u0006$\u0018n\u001c8UK6\u0004H.\u0019;f'\t\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA$A\u0003baBd\u0017\u0010F\u0004,\u0003\u0017\t9\"a\u0007\u0011\u0005u11C\u0001\u0004!\u0003-\u0001\u0018mY6bO\u0016t\u0015-\\3\u0011\u0005=2dB\u0001\u00195!\t\t$%D\u00013\u0015\t\u0019t%\u0001\u0004=e>|GOP\u0005\u0003k\t\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QGI\u0001\u0014g&lW\u000f\\1uS>t7\t\\1tg:\u000bW.Z\u0001\u0007M>\u0014X.\u0019;\u0011\u0005ua\u0014BA\u001f\u0013\u0005=\u0011VM\u001c3fe&twMR8s[\u0006$\u0018\u0001\u00059s_R|7m\u001c7UK6\u0004H.\u0019;f!\ti\u0002)\u0003\u0002B%\t\u0001\u0002K]8u_\u000e|G\u000eV3na2\fG/Z\u0001\u0010e\u0016\fX/Z:u)\u0016l\u0007\u000f\\1uKB\u0011Q\u0004R\u0005\u0003\u000bJ\u0011qBU3rk\u0016\u001cH\u000fV3na2\fG/\u001a\u000b\u0007W\u001dC\u0015JS&\t\u000b5b\u0001\u0019\u0001\u0018\t\u000beb\u0001\u0019\u0001\u0018\t\u000bib\u0001\u0019A\u001e\t\u000byb\u0001\u0019A \t\u000b\tc\u0001\u0019A\"\u0002\u001bI,g\u000eZ3s\u0011\u0016\fG-\u001a:t)\tqc\nC\u0003P\u001b\u0001\u0007\u0001+A\u0004iK\u0006$WM]:\u0011\t=\n6KV\u0005\u0003%b\u00121!T1q!\t\tC+\u0003\u0002VE\t\u0019\u0011J\u001c;\u0011\u0007]cvL\u0004\u0002Y5:\u0011\u0011'W\u0005\u0002G%\u00111LI\u0001\ba\u0006\u001c7.Y4f\u0013\tifLA\u0002TKFT!a\u0017\u0012\u0011\t\u0005\u0002gFL\u0005\u0003C\n\u0012a\u0001V;qY\u0016\u0014\u0014!\u0006:f]\u0012,'oU2f]\u0006\u0014\u0018n\\#mK6,g\u000e\u001e\u000b\u0004I.\f\bCA3k\u001b\u00051'BA4i\u0003\u0011a\u0017M\\4\u000b\u0003%\fAA[1wC&\u0011qG\u001a\u0005\u0006Y:\u0001\r!\\\u0001\u0003g\u0016\u0004\"A\\8\u000e\u0003QI!\u0001\u001d\u000b\u0003%!#H\u000f\u001d+sC\u001a4\u0017nY#mK6,g\u000e\u001e\u0005\u0006e:\u0001\ra]\u0001\u000eKb$(/Y2uK\u0012,&/[:\u0011\u0005u!\u0018BA;\u0013\u00055)\u0005\u0010\u001e:bGR,G-\u0016:jg\u0006q!/\u001a8eKJ\u001c6-\u001a8be&|Gc\u0001\u0018ys\")!o\u0004a\u0001g\")!p\u0004a\u0001w\u0006AQ\r\\3nK:$8\u000fE\u0002X96$bAL?\u0002\u0006\u0005\u001d\u0001\"\u0002@\u0011\u0001\u0004y\u0018\u0001\u00039s_R|7m\u001c7\u0011\u00079\f\t!C\u0002\u0002\u0004Q\u0011!\u0003\u0015:pi>\u001cw\u000e\u001c#fM&t\u0017\u000e^5p]\")q\n\u0005a\u0001!\"1\u0011\u0011\u0002\tA\u0002m\f\u0001c]2f]\u0006\u0014\u0018n\\#mK6,g\u000e^:\t\u000f\u000551\u00011\u0001\u0002\u0010\u0005i!/Z9vKN$(i\u001c3jKN\u0004RaL)T\u0003#\u00012A\\A\n\u0013\r\t)\u0002\u0006\u0002\u000b\tVl\u0007/\u001a3C_\u0012L\bbBA\r\u0007\u0001\u0007\u0011qB\u0001\u000fe\u0016\u001c\bo\u001c8tK\n{G-[3t\u0011\u001d\tib\u0001a\u0001\u0003?\tQbY8oM&<WO]1uS>t\u0007\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015b#\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003S\t\u0019CA\u000bSK\u000e|'\u000fZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002#I,g\u000eZ3s\u001d>t')Y:f+Jd7\u000fF\u0003/\u0003_\tY\u0004C\u0004\u00022\u0011\u0001\r!a\r\u0002\rY\fG.^3t!\u00119F,!\u000e\u0011\u0007u\t9$C\u0002\u0002:I\u0011a!\u0016:m-\u0006d\u0007\"\u0002\u001e\u0005\u0001\u0004Y\u0014\u0001\u00055fC\u0012,'o\u001d\"m_\u000e\\g*Y7f)\r!\u0017\u0011\t\u0005\u0007\u0003\u0007*\u0001\u0019A*\u0002\u0005%$\u0007")
public class SimulationTemplate {
    private final String packageName;
    private final String simulationClassName;
    private final RenderingFormat format;
    private final ProtocolTemplate protocolTemplate;
    private final RequestTemplate requestTemplate;

    public static SimulationTemplate apply(Map<Object, DumpedBody> requestBodies, Map<Object, DumpedBody> responseBodies, RecorderConfiguration configuration) {
        return SimulationTemplate$.MODULE$.apply(requestBodies, responseBodies, configuration);
    }

    private String renderHeaders(Map<Object, Seq<Tuple2<String, String>>> headers) {
        return ((IterableOnceOps)headers.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int headersBlockIndex = tuple2._1$mcI$sp();
                Seq headersBlock = (Seq)tuple2._2();
                String headerReference = SimulationTemplate$.MODULE$.headersBlockName(headersBlockIndex);
                Seq protectedHeaders = (Seq)headersBlock.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return new Tuple2((Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(name), $this.format), (Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(value), $this.format));
                    }
                    throw new MatchError((Object)tuple2);
                });
                RenderingFormat renderingFormat = $this.format;
                if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple22;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple22 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple22._1();
                        String protectedValue = (String)tuple22._2();
                        return "private val " + headerReference + " = Map(" + protectedName + " -> " + protectedValue + ")";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private val " + headerReference + " = Map(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "\t\t" + protectedName + " -> " + protectedValue;
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |)"));
                }
                if (RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple23;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple23 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple23._1();
                        String protectedValue = (String)tuple23._2();
                        return "private val " + headerReference + " = mapOf(" + protectedName + " to " + protectedValue + ")";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private val " + headerReference + " = mapOf(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "  " + protectedName + " to " + protectedValue;
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |)"));
                }
                if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
                    Tuple2 tuple24;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple24 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple24._1();
                        String protectedValue = (String)tuple24._2();
                        return "private Map<CharSequence, String> " + headerReference + " = Map.of(" + protectedName + ", " + protectedValue + ");";
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("private Map<CharSequence, String> " + headerReference + " = Map.ofEntries(\n                   |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "  Map.entry(" + protectedName + ", " + protectedValue + ")";
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n                   |);"));
                }
                if (RenderingFormat$JavaScript$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$TypeScript$.MODULE$.equals(renderingFormat)) {
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("const " + headerReference + " = {\n               |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$6 -> {
                        Tuple2 tuple2 = x0$6;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return "  " + protectedName + ": " + protectedValue;
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("," + StringHelper$.MODULE$.Eol()) + "\n               |};"));
                }
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Map<CharSequence, String> " + headerReference + " = new HashMap<>();\n               |" + ((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$7 -> {
                    Tuple2 tuple2 = x0$7;
                    if (tuple2 != null) {
                        String protectedName = (String)tuple2._1();
                        String protectedValue = (String)tuple2._2();
                        return headerReference + ".put(" + protectedName + ", " + protectedValue + ");";
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(StringHelper$.MODULE$.Eol())));
            }
            throw new MatchError((Object)tuple2);
        })).mkString(StringHelper$.MODULE$.Eol(), StringHelper$.MODULE$.Eol() + StringHelper$.MODULE$.Eol(), "");
    }

    private String renderScenarioElement(HttpTrafficElement se, ExtractedUris extractedUris) {
        HttpTrafficElement httpTrafficElement = se;
        if (httpTrafficElement instanceof TagElement) {
            TagElement tagElement = (TagElement)httpTrafficElement;
            String text = tagElement.text();
            return "// " + text;
        }
        if (httpTrafficElement instanceof PauseElement) {
            RenderingFormat renderingFormat;
            PauseElement pauseElement = (PauseElement)httpTrafficElement;
            FiniteDuration duration = pauseElement.duration();
            String pauseString = duration.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()) ? Long.toString(duration.toSeconds()) : (RenderingFormat$Scala$.MODULE$.equals(renderingFormat = this.format) ? duration.toMillis() + ".milliseconds" : ((RenderingFormat$JavaScript$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$TypeScript$.MODULE$.equals(renderingFormat)) ? "{ amount: " + duration.toMillis() + ", unit: \"milliseconds\" }" : "Duration.ofMillis(" + duration.toMillis() + ")"));
            return "pause(" + pauseString + ")";
        }
        if (httpTrafficElement instanceof RequestElement) {
            RequestElement requestElement = (RequestElement)httpTrafficElement;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(String.valueOf(this.requestTemplate.render(this.simulationClassName, requestElement, extractedUris))));
        }
        throw new MatchError((Object)httpTrafficElement);
    }

    private String renderScenario(ExtractedUris extractedUris, Seq<HttpTrafficElement> elements) {
        String string;
        RenderingFormat renderingFormat = this.format;
        if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
            string = "private val";
        } else if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
            string = "private ScenarioBuilder";
        } else if (RenderingFormat$JavaScript$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$TypeScript$.MODULE$.equals(renderingFormat)) {
            string = "const";
        } else {
            throw new MatchError((Object)renderingFormat);
        }
        String scenarioReferenceType = string;
        String scenarioElements = ((IterableOnceOps)elements.map((Function1 & Serializable)x$2 -> this.renderScenarioElement((HttpTrafficElement)x$2, extractedUris))).mkString("," + StringHelper$.MODULE$.Eol());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(scenarioReferenceType + " scn = scenario(\"" + this.simulationClassName + "\")\n       |  .exec(\n       |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(String.valueOf(scenarioElements)), 4) + "\n       |  )" + this.format.lineTermination()));
    }

    public String render(ProtocolDefinition protocol, Map<Object, Seq<Tuple2<String, String>>> headers, Seq<HttpTrafficElement> scenarioElements) {
        ExtractedUris extractedUris = ExtractedUris$.MODULE$.apply(scenarioElements, this.format);
        Seq<UrlVal> nonBaseUrls = extractedUris.nonBaseUrls(protocol.baseUrl());
        RenderingFormat renderingFormat = this.format;
        if (RenderingFormat$Scala$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + StringHelper$.MODULE$.Eol() : "") + "\n           |import scala.concurrent.duration._\n           |\n           |import io.gatling.core.Predef._\n           |import io.gatling.http.Predef._\n           |import io.gatling.jdbc.Predef._\n           |\n           |class " + this.simulationClassName + " extends Simulation {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |\tsetUp(scn.inject(atOnceUsers(1))).protocols(httpProtocol)\n           |}\n           |"));
        }
        if (RenderingFormat$Kotlin$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + StringHelper$.MODULE$.Eol() : "") + "\n           |import java.time.Duration\n           |\n           |import io.gatling.javaapi.core.*\n           |import io.gatling.javaapi.http.*\n           |import io.gatling.javaapi.jdbc.*\n           |\n           |import io.gatling.javaapi.core.CoreDsl.*\n           |import io.gatling.javaapi.http.HttpDsl.*\n           |import io.gatling.javaapi.jdbc.JdbcDsl.*\n           |\n           |class " + this.simulationClassName + " : Simulation() {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |  init {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol)\n           |  }\n           |}\n           |"));
        }
        if (RenderingFormat$Java11$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$Java17$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString((StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? "package " + this.packageName + ";" + StringHelper$.MODULE$.Eol() : "") + "\n           |import java.time.Duration;\n           |import java.util.*;\n           |\n           |import io.gatling.javaapi.core.*;\n           |import io.gatling.javaapi.http.*;\n           |import io.gatling.javaapi.jdbc.*;\n           |\n           |import static io.gatling.javaapi.core.CoreDsl.*;\n           |import static io.gatling.javaapi.http.HttpDsl.*;\n           |import static io.gatling.javaapi.jdbc.JdbcDsl.*;\n           |\n           |public class " + this.simulationClassName + " extends Simulation {\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |  {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol);\n           |  }\n           |}\n           |"));
        }
        if (RenderingFormat$JavaScript$.MODULE$.equals(renderingFormat) ? true : RenderingFormat$TypeScript$.MODULE$.equals(renderingFormat)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import { simulation, scenario, pause, atOnceUsers, RawFileBody } from \"@gatling.io/core\";\n           |import { http, status } from \"@gatling.io/http\";\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2) + "\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2) + "\n           |\n           |" + package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2) + "\n           |\n           |export default simulation((setUp) => {\n           |  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol);\n           |});\n           |"));
        }
        throw new MatchError((Object)renderingFormat);
    }

    public SimulationTemplate(String packageName, String simulationClassName, RenderingFormat format, ProtocolTemplate protocolTemplate, RequestTemplate requestTemplate) {
        this.packageName = packageName;
        this.simulationClassName = simulationClassName;
        this.format = format;
        this.protocolTemplate = protocolTemplate;
        this.requestTemplate = requestTemplate;
    }
}

