/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.har.HarReader$;
import io.gatling.recorder.har.HttpTransaction;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.render.DumpedBodies;
import io.gatling.recorder.render.DumpedBodies$;
import io.gatling.recorder.render.DumpedBody;
import io.gatling.recorder.render.HttpTraffic;
import io.gatling.recorder.render.HttpTraffic$;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.ProtocolDefinition;
import io.gatling.recorder.render.ProtocolDefinition$;
import io.gatling.recorder.render.RequestBody;
import io.gatling.recorder.render.RequestBodyBytes;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.RequestElement$;
import io.gatling.recorder.render.ResponseBody;
import io.gatling.recorder.render.ResponseBodyBytes;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.TimedScenarioElement;
import io.gatling.recorder.render.template.SimulationTemplate$;
import io.gatling.recorder.util.HttpUtils$;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.AsciiString;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!\u0002\u0007\u000e\u0001=)\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b5\u0002A\u0011\u0001\u0018\t\u000fI\u0002!\u0019!C\u0005g!1a\b\u0001Q\u0001\nQBQa\u0010\u0001\u0005\u0002\u0001CQ\u0001\u0012\u0001\u0005\n\u0015CQA\u0014\u0001\u0005\u0002=CQA\u0017\u0001\u0005\u0002mCQ!\u0019\u0001\u0005\n\tDQ\u0001\u001d\u0001\u0005\nEDq!!\u0007\u0001\t\u0013\tYB\u0001\u000bIiR\u0004HK]1gM&\u001c7i\u001c8wKJ$XM\u001d\u0006\u0003\u001d=\taA]3oI\u0016\u0014(B\u0001\t\u0012\u0003!\u0011XmY8sI\u0016\u0014(B\u0001\n\u0014\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001F\u0001\u0003S>\u001c2\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011Q\u0004J\u0007\u0002=)\u0011q\u0004I\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003C\t\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002G\u0005\u00191m\\7\n\u0005\u0015r\"!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0004d_:4\u0017nZ\u0002\u0001!\tI3&D\u0001+\u0015\t1s\"\u0003\u0002-U\t)\"+Z2pe\u0012,'oQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u00020cA\u0011\u0001\u0007A\u0007\u0002\u001b!)aE\u0001a\u0001Q\u0005q1/[7vY\u0006$\u0018n\u001c8GS2,W#\u0001\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00024jY\u0016T!!\u000f\u001e\u0002\u00079LwNC\u0001<\u0003\u0011Q\u0017M^1\n\u0005u2$\u0001\u0002)bi\"\fqb]5nk2\fG/[8o\r&dW\rI\u0001\u0015g&lW\u000f\\1uS>tg)\u001b7f\u000bbL7\u000f^:\u0016\u0003\u0005\u0003\"a\u0006\"\n\u0005\rC\"a\u0002\"p_2,\u0017M\\\u0001\tIVl\u0007OQ8esR\u0011a)\u0013\t\u0003/\u001dK!\u0001\u0013\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u001a\u0001\raS\u0001\u0005E>$\u0017\u0010\u0005\u00021\u0019&\u0011Q*\u0004\u0002\u000b\tVl\u0007/\u001a3C_\u0012L\u0018!\u0004:f]\u0012,'\u000fS1s\r&dW\r\u0006\u0002Q1B\u0019\u0011K\u0016$\u000e\u0003IS!a\u0015+\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002V#\u000591m\\7n_:\u001c\u0018BA,S\u0005)1\u0016\r\\5eCRLwN\u001c\u0005\u00063\u001e\u0001\r\u0001N\u0001\bQ\u0006\u0014h)\u001b7f\u0003E\u0011XM\u001c3fe\"#H\u000f\u001d+sC\u001a4\u0017n\u0019\u000b\u0003\rrCQ!\u0018\u0005A\u0002y\u000b\u0001c]2f]\u0006\u0014\u0018n\\#mK6,g\u000e^:\u0011\u0005Az\u0016B\u00011\u000e\u0005-AE\u000f\u001e9Ue\u00064g-[2\u00027I,g\u000eZ3s'\u000e,g.\u0019:j_\u0006sG\rR;na\n{G-[3t)\t\u0019g\u000e\u0005\u0002eW:\u0011Q-\u001b\t\u0003Mbi\u0011a\u001a\u0006\u0003Q\u001e\na\u0001\u0010:p_Rt\u0014B\u00016\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)D\u0002\"B8\n\u0001\u0004q\u0016\u0001C:dK:\f'/[8\u0002\u001d\u001d,GOQ1tK\"+\u0017\rZ3sgR\u0011!O \t\u0003grl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\u001b;ua*\u0011q\u000f_\u0001\u0006G>$Wm\u0019\u0006\u0003sj\fq\u0001[1oI2,'O\u0003\u0002|'\u0005)a.\u001a;us&\u0011Q\u0010\u001e\u0002\f\u0011R$\b\u000fS3bI\u0016\u00148\u000f\u0003\u0004\u0000\u0015\u0001\u0007\u0011\u0011A\u0001\u0010e\u0016\fX/Z:u\u000b2,W.\u001a8ugB1\u00111AA\u0007\u0003'qA!!\u0002\u0002\n9\u0019a-a\u0002\n\u0003eI1!a\u0003\u0019\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0004\u0002\u0012\t\u00191+Z9\u000b\u0007\u0005-\u0001\u0004E\u00021\u0003+I1!a\u0006\u000e\u00059\u0011V-];fgR,E.Z7f]R\f!bZ3u\u0005\u0006\u001cX-\u0016:m)\r\u0019\u0017Q\u0004\u0005\u0007\u007f.\u0001\r!!\u0001")
public class HttpTrafficConverter
implements StrictLogging {
    private final RecorderConfiguration config;
    private final Path simulationFile;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Path simulationFile() {
        return this.simulationFile;
    }

    public boolean simulationFileExists() {
        return Files.exists(this.simulationFile(), new LinkOption[0]);
    }

    private void dumpBody(DumpedBody body) {
        Using$.MODULE$.resource((Object)new BufferedOutputStream(Files.newOutputStream(body.filePath(), new OpenOption[0])), (Function1 & Serializable)fw -> {
            HttpTrafficConverter.$anonfun$dumpBody$1(this, body, fw);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Validation<BoxedUnit> renderHarFile(Path harFile) {
        return io.gatling.commons.validation.package$.MODULE$.safely((Function1 & Serializable)error -> "Error while processing HAR file: " + error, (Function0 & Serializable)() -> {
            List<HttpTransaction> transactions = HarReader$.MODULE$.readFile(harFile, $this.config.filters().filters());
            if (transactions.isEmpty()) {
                return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("the selected file doesn't contain any valid HTTP requests"));
            }
            List scenarioElements = transactions.map((Function1 & Serializable)x0$1 -> {
                HttpTransaction httpTransaction = x0$1;
                if (httpTransaction != null) {
                    HttpRequest request = httpTransaction.request();
                    HttpResponse response = httpTransaction.response();
                    RequestElement element = RequestElement$.MODULE$.apply(request, response, $this.config);
                    return new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), element);
                }
                throw new MatchError((Object)httpTransaction);
            });
            this.renderHttpTraffic(HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)scenarioElements, (List<TimedScenarioElement<TagElement>>)Nil$.MODULE$, $this.config));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)BoxedUnit.UNIT));
        });
    }

    public void renderHttpTraffic(HttpTraffic scenarioElements) {
        Predef$.MODULE$.require(!scenarioElements.isEmpty());
        String output = this.renderScenarioAndDumpBodies(scenarioElements);
        Using$.MODULE$.resource((Object)new BufferedOutputStream(Files.newOutputStream(this.simulationFile(), new OpenOption[0])), (Function1 & Serializable)x$5 -> {
            x$5.write(output.getBytes(this.config.core().encoding()));
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private String renderScenarioAndDumpBodies(HttpTraffic scenario) {
        Set filteredHeaders = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.COOKIE, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderNames.HOST}))).$plus$plus((IterableOnce)(this.config.http().automaticReferer() ? (IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.REFERER})) : Predef$.MODULE$.Set().empty()));
        List<HttpTrafficElement> scenarioElements = scenario.elements();
        List mainRequestElements = scenarioElements.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends HttpTrafficElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)A1;
                    return (B1)requestElement;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(HttpTrafficElement x1) {
                HttpTrafficElement httpTrafficElement = x1;
                return httpTrafficElement instanceof RequestElement;
            }
        });
        List requestElements = mainRequestElements.flatMap((Function1 & Serializable)req -> {
            RequestElement requestElement = req;
            return req.nonEmbeddedResources().$colon$colon((Object)requestElement);
        });
        requestElements.foreach((Function1 & Serializable)requestElement -> {
            Object object = requestElement.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true) ? requestElement.headers().remove((CharSequence)HttpHeaderNames.CONNECTION) : BoxedUnit.UNIT;
            java.util.List authorizationHeaders = requestElement.headers().getAll((CharSequence)HttpHeaderNames.AUTHORIZATION);
            return requestElement.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (java.lang.Iterable)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(authorizationHeaders).asScala().filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith("Basic ")))).asJava());
        });
        String baseUrl = this.getBaseUrl((Seq<RequestElement>)mainRequestElements);
        HttpHeaders baseHeaders = this.getBaseHeaders((Seq<RequestElement>)requestElements);
        ProtocolDefinition protocolConfigElement = new ProtocolDefinition(baseUrl, baseHeaders);
        List elements = scenarioElements.map((Function1 & Serializable)x0$1 -> {
            HttpTrafficElement httpTrafficElement = x0$1;
            if (httpTrafficElement instanceof RequestElement) {
                RequestElement requestElement = (RequestElement)httpTrafficElement;
                requestElement.nonEmbeddedResources().foreach((Function1 & Serializable)x$7 -> x$7.makeRelativeTo(baseUrl));
                return requestElement.makeRelativeTo(baseUrl);
            }
            return httpTrafficElement;
        });
        ((List)requestElements.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                RequestElement reqEl = (RequestElement)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return reqEl.setId(index);
            }
            throw new MatchError((Object)tuple2);
        });
        DumpedBodies dumpedBodies = DumpedBodies$.MODULE$.apply(this.config);
        Map requestBodies = requestElements.flatMap((Function1 & Serializable)request -> request.body().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RequestBody, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RequestBodyBytes) {
                    RequestBodyBytes requestBodyBytes = (RequestBodyBytes)A1;
                    byte[] bytes = requestBodyBytes.bytes();
                    return (B1)bytes;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(RequestBody x2) {
                RequestBody requestBody = x2;
                return requestBody instanceof RequestBodyBytes;
            }
        }).toList().map((Function1 & Serializable)bytes -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)request.id())), (Object)dumpedBodies.forRequest((RequestElement)request, (byte[])bytes)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map responseBodies = this.config.http().checkResponseBodies() ? requestElements.flatMap((Function1 & Serializable)request -> request.responseBody().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ResponseBody, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof ResponseBodyBytes) {
                    ResponseBodyBytes responseBodyBytes = (ResponseBodyBytes)A1;
                    byte[] bytes = responseBodyBytes.bytes();
                    return (B1)bytes;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(ResponseBody x3) {
                ResponseBody responseBody = x3;
                return responseBody instanceof ResponseBodyBytes;
            }
        }).toList().map((Function1 & Serializable)bytes -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)request.id())), (Object)dumpedBodies.forResponse((RequestElement)request, (byte[])bytes)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
        requestBodies.values().foreach((Function1 & Serializable)body -> {
            this.dumpBody(body);
            return BoxedUnit.UNIT;
        });
        responseBodies.values().foreach((Function1 & Serializable)body -> {
            this.dumpBody(body);
            return BoxedUnit.UNIT;
        });
        Map headers = (Map)SortedMap$.MODULE$.apply(this.generateHeaders$1(requestElements, Predef$.MODULE$.Map().empty(), filteredHeaders, baseHeaders).toSeq(), (Ordering)Ordering.Int$.MODULE$);
        return SimulationTemplate$.MODULE$.apply((Map<Object, DumpedBody>)requestBodies, (Map<Object, DumpedBody>)responseBodies, this.config).render(protocolConfigElement, (Map<Object, Seq<Tuple2<String, String>>>)headers, (Seq<HttpTrafficElement>)elements);
    }

    private HttpHeaders getBaseHeaders(Seq<RequestElement> requestElements) {
        DefaultHttpHeaders baseHeaders = new DefaultHttpHeaders(false);
        CollectionConverters$.MODULE$.SetHasAsScala(ProtocolDefinition$.MODULE$.BaseHeadersAndProtocolMethods().names()).asScala().foreach((Function1 & Serializable)headerName -> {
            Option option = HttpTrafficConverter.getMostFrequentHeaderValue$1(headerName, requestElements);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mostFrequentValue = (String)some.value();
                return baseHeaders.add(headerName, (Object)mostFrequentValue);
            }
            return BoxedUnit.UNIT;
        });
        return baseHeaders;
    }

    private String getBaseUrl(Seq<RequestElement> requestElements) {
        Seq urlsOccurrences = (Seq)((IterableOps)requestElements.map((Function1 & Serializable)x$12 -> x$12.baseUrl())).groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
        return (String)((Tuple2)urlsOccurrences.maxBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    public static final /* synthetic */ void $anonfun$dumpBody$1(HttpTrafficConverter $this, DumpedBody body$1, BufferedOutputStream fw) {
        block3: {
            try {
                fw.write(body$1.bytes());
            }
            catch (IOException e) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error("Failed to dump body " + body$1.filePath(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$14(Set filteredHeaders$1, HttpHeaders baseHeaders$1, RequestElement element$1, Tuple2 x0$1) {
        block2: {
            var5_4 = x0$1;
            if (var5_4 == null) break block2;
            headerName = (String)var5_4._1();
            headerValue = (String)var5_4._2();
            isFiltered = HttpUtils$.MODULE$.containsIgnoreCase((Iterable<AsciiString>)filteredHeaders$1, headerName) != false || HttpUtils$.MODULE$.isHttp2PseudoHeader(headerName) != false;
            isAlreadyInBaseHeaders = HttpUtils$.MODULE$.getIgnoreCase(baseHeaders$1, headerName).contains((Object)headerValue);
            v0 = element$1.method();
            var11_9 = HttpMethod.POST.name();
            v1 = !(v0 != null ? v0.equals(var11_9) == false : var11_9 != null) && HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEqualsIgnoreCase((CharSequence)headerValue) != false ? true : (isPostWithFormParams = false);
            if (!HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)headerName)) ** GOTO lbl-1000
            v2 = headerValue;
            var13_11 = "0";
            if (!(v2 != null ? v2.equals(var13_11) == false : var13_11 != null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            isEmptyContentLength = v3;
            return isFiltered != false || isAlreadyInBaseHeaders != false || isPostWithFormParams != false || isEmptyContentLength != false;
        }
        throw new MatchError((Object)var5_4);
    }

    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$16(List acceptedHeaders$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            List existingHeaders;
            List list = existingHeaders = (List)tuple2._2();
            List list2 = acceptedHeaders$1;
            return !(list != null ? !list.equals(list2) : list2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Map generateHeaders$1(List elements, Map headers, Set filteredHeaders$1, HttpHeaders baseHeaders$1) {
        List list;
        while (true) {
            Map newHeaders;
            Map map;
            if (Nil$.MODULE$.equals(list = elements)) {
                return headers;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            RequestElement element = (RequestElement)colon2.head();
            List others = colon2.next$access$1();
            List acceptedHeaders = (List)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(element.headers().entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), e.getValue()))).toList().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpTrafficConverter.$anonfun$renderScenarioAndDumpBodies$14(filteredHeaders$1, baseHeaders$1, element, x0$1))).sortBy((Function1 & Serializable)x$8 -> (String)x$8._1(), (Ordering)Ordering.String$.MODULE$);
            if (acceptedHeaders.isEmpty()) {
                element.filteredHeadersId_$eq((Option<Object>)None$.MODULE$);
                map = headers;
            } else {
                Seq headersSeq = headers.toSeq();
                int n = headersSeq.indexWhere((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)HttpTrafficConverter.$anonfun$renderScenarioAndDumpBodies$16(acceptedHeaders, x0$2)));
                switch (n) {
                    case -1: {
                        element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)element.id())));
                        map = (Map)headers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)element.id())), (Object)acceptedHeaders));
                        break;
                    }
                    default: {
                        element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((Tuple2)headersSeq.apply(n))._1$mcI$sp())));
                        map = headers;
                        break;
                    }
                }
            }
            headers = newHeaders = map;
            elements = others;
        }
        throw new MatchError((Object)list);
    }

    private static final Option getMostFrequentHeaderValue$1(String headerName, Seq requestElements$1) {
        Seq headerValues = (Seq)requestElements$1.flatMap((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.ListHasAsScala(x$9.headers().getAll(headerName)).asScala());
        if (headerValues.isEmpty() || headerValues.length() != requestElements$1.length()) {
            return None$.MODULE$;
        }
        Seq headersValuesOccurrences = (Seq)headerValues.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
        String mostFrequentValue = (String)((Tuple2)headersValuesOccurrences.maxBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
        return new Some((Object)mostFrequentValue);
    }

    public HttpTrafficConverter(RecorderConfiguration config) {
        this.config = config;
        StrictLogging.$init$((StrictLogging)this);
        Path sourcesFolderPath = (Path)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])config.core().pkg().split("\\.")), (Object)config.core().simulationsFolder(), (Function2 & Serializable)(x$3, x$4) -> x$3.resolve((String)x$4));
        Files.createDirectories(sourcesFolderPath, new FileAttribute[0]);
        this.simulationFile = sourcesFolderPath.resolve(config.core().className() + "." + config.core().format().fileExtension());
        Statics.releaseFence();
    }
}

