/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.core.filter.Filters$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.http.mitm.Mitm;
import io.gatling.recorder.http.mitm.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.render.HttpTraffic;
import io.gatling.recorder.render.HttpTraffic$;
import io.gatling.recorder.render.HttpTrafficConverter;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.RequestElement$;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.TimedScenarioElement;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!\u0002\u000b\u0016\u0005]i\u0002\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u000ba\u0002A\u0011A\u001d\t\u000fu\u0002!\u0019!C\u0005}!1Q\t\u0001Q\u0001\n}B\u0011B\u0012\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%9\u0006\u00011AA\u0002\u0013%\u0001\fC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"I!\r\u0001a\u0001\u0002\u0003\u0006K!\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019!\b\u0001)A\u0005K\"9Q\u000f\u0001b\u0001\n\u00131\bB\u0002?\u0001A\u0003%q\u000fC\u0003~\u0001\u0011\u0005a\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aa!!\u0013\u0001\t\u0003q(A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!AF\f\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u00193\u0005A!/Z2pe\u0012,'O\u0003\u0002\u001b7\u00059q-\u0019;mS:<'\"\u0001\u000f\u0002\u0005%|7c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005%R\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003-\n1aY8n\u0013\ticEA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0006G2|7m[\u0002\u0001!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003vi&d'BA\u001b\u001a\u0003\u001d\u0019w.\\7p]NL!a\u000e\u001a\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\tQD\b\u0005\u0002<\u00015\tQ\u0003C\u0003/\u0005\u0001\u0007\u0001'\u0001\u0005ge>tG/\u00128e+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0018\u0003\t)\u0018.\u0003\u0002E\u0003\n\u0001\"+Z2pe\u0012,'O\u0012:p]R,e\u000eZ\u0001\nMJ|g\u000e^#oI\u0002\nA!\\5u[V\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u0002G\u0017*\u0011AjF\u0001\u0005QR$\b/\u0003\u0002O\u0015\n!Q*\u001b;n\u0003!i\u0017\u000e^7`I\u0015\fHCA)U!\ty\"+\u0003\u0002TA\t!QK\\5u\u0011\u001d)f!!AA\u0002!\u000b1\u0001\u001f\u00132\u0003\u0015i\u0017\u000e^7!\u0003%\u0019wN\u001c<feR,'/F\u0001Z!\tQV,D\u0001\\\u0015\tav#\u0001\u0004sK:$WM]\u0005\u0003=n\u0013A\u0003\u0013;uaR\u0013\u0018M\u001a4jG\u000e{gN^3si\u0016\u0014\u0018!D2p]Z,'\u000f^3s?\u0012*\u0017\u000f\u0006\u0002RC\"9Q+CA\u0001\u0002\u0004I\u0016AC2p]Z,'\u000f^3sA\u0005A!/Z9vKN$8/F\u0001f!\r1GN\\\u0007\u0002O*\u0011\u0001.[\u0001\u000bG>t7-\u001e:sK:$(BA\u001ak\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\\4\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u0019!l\\9\n\u0005A\\&\u0001\u0006+j[\u0016$7kY3oCJLw.\u00127f[\u0016tG\u000f\u0005\u0002[e&\u00111o\u0017\u0002\u000f%\u0016\fX/Z:u\u000b2,W.\u001a8u\u0003%\u0011X-];fgR\u001c\b%\u0001\u0003uC\u001e\u001cX#A<\u0011\u0007\u0019d\u0007\u0010E\u0002[_f\u0004\"A\u0017>\n\u0005m\\&A\u0003+bO\u0016cW-\\3oi\u0006)A/Y4tA\u0005q1\u000f^1siJ+7m\u001c:eS:<G#A)\u0002\u001bM$x\u000e\u001d*fG>\u0014H-\u001b8h)\r\t\u00161\u0001\u0005\b\u0003\u000b\u0001\u0002\u0019AA\u0004\u0003\u0011\u0019\u0018M^3\u0011\u0007}\tI!C\u0002\u0002\f\u0001\u0012qAQ8pY\u0016\fg.A\bsK\u000e,\u0017N^3SKN\u0004xN\\:f)\u0015\t\u0016\u0011CA\u0011\u0011\u001d\t\u0019\"\u0005a\u0001\u0003+\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYbF\u0001\u0006[>$W\r\\\u0005\u0005\u0003?\tIBA\u0006IiR\u0004(+Z9vKN$\bbBA\u0012#\u0001\u0007\u0011QE\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011qCA\u0014\u0013\u0011\tI#!\u0007\u0003\u0019!#H\u000f\u001d*fgB|gn]3\u0002\r\u0005$G\rV1h)\r\t\u0016q\u0006\u0005\b\u0003c\u0011\u0002\u0019AA\u001a\u0003\u0011!X\r\u001f;\u0011\t\u0005U\u00121\t\b\u0005\u0003o\ty\u0004E\u0002\u0002:\u0001j!!a\u000f\u000b\u0007\u0005ur&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#AB*ue&twMC\u0002\u0002B\u0001\n!c\u00197fCJ\u0014VmY8sI\u0016\u00148\u000b^1uK\u0002")
public final class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private Mitm mitm;
    private HttpTrafficConverter converter;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private HttpTrafficConverter converter() {
        return this.converter;
    }

    private void converter_$eq(HttpTrafficConverter x$1) {
        this.converter = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        boolean proceed;
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        this.converter_$eq(new HttpTrafficConverter(config));
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        Path harFile = this.frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !Files.exists(harFile, new LinkOption[0])) {
            this.frontEnd().handleMissingHarFile(harFile);
            return;
        }
        boolean bl = proceed = this.converter().simulationFileExists() ? this.frontEnd().askSimulationOverwrite() : true;
        if (proceed) {
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = this.converter().renderHarFile(harFile);
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.frontEnd().handleHarExportFailure(errMsg);
                } else {
                    this.frontEnd().handleHarExportSuccess();
                }
                return;
            }
            if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, config));
                this.frontEnd().recordingStarted();
                return;
            }
            throw new MatchError((Object)recorderMode2);
        }
    }

    public void stopRecording(boolean save) {
        try {
            this.frontEnd().recordingStopped();
            if (save) {
                if (this.requests().isEmpty()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Nothing was recorded, skipping Simulation generation");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
                    HttpTraffic traffic = HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().toList(), (List<TimedScenarioElement<TagElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.tags()).asScala().toList(), config);
                    this.converter().renderHttpTraffic(traffic);
                }
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        if (config.filters().filters().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accept(request.uri()))) && Filters$.MODULE$.BrowserNoiseFilters().accept(request.uri())) {
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, config)));
            Option previousSendTime = CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().lastOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)t -> {
                FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                if (delta.$greater((Object)config.core().thresholdForPauseCreation())) {
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                    return;
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, config));
            return;
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.recorderConfiguration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
        Statics.releaseFence();
    }
}

