/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Io$;
import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.har.HarReader$;
import io.gatling.recorder.har.HttpTransaction;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.scenario.ProtocolDefinition;
import io.gatling.recorder.scenario.ProtocolDefinition$;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ResponseBody;
import io.gatling.recorder.scenario.ResponseBodyBytes;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioElement;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.scenario.template.SimulationTemplate$;
import io.gatling.recorder.util.HttpUtils$;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ScenarioExporter$
implements StrictLogging {
    public static ScenarioExporter$ MODULE$;
    private final int EventsGrouping;
    private final Logger logger;

    static {
        new ScenarioExporter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int EventsGrouping() {
        return this.EventsGrouping;
    }

    private String packageAsFolderPath(String separator, RecorderConfiguration config) {
        return config.core().pkg().replace(".", separator);
    }

    private String classNameToFolderName(RecorderConfiguration config) {
        return config.core().className().toLowerCase(Locale.ROOT);
    }

    public Path simulationFilePath(RecorderConfiguration config) {
        String path = new StringBuilder(0).append(config.core().simulationsFolder()).append(File.separator).append(this.packageAsFolderPath(File.separator, config)).toString();
        return PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(this.getFolder(path)), new StringBuilder(6).append(config.core().className()).append(".scala").toString());
    }

    private Path resourcesFolderPath(RecorderConfiguration config) {
        String path = new StringBuilder(0).append(config.core().resourcesFolder()).append(File.separator).append(this.packageAsFolderPath(File.separator, config)).append(File.separator).append(this.classNameToFolderName(config)).toString();
        return this.getFolder(path);
    }

    private String requestBodyFileName(RequestElement request) {
        return new StringBuilder(9).append(StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToInteger((int)request.id())).toString()), 4, "0")).append("_request.").append(request.fileExtension()).toString();
    }

    public String requestBodyRelativeFilePath(RequestElement request, RecorderConfiguration config) {
        return new StringBuilder(2).append(this.packageAsFolderPath("/", config)).append("/").append(this.classNameToFolderName(config)).append("/").append(this.requestBodyFileName(request)).toString();
    }

    private String responseBodyFileName(RequestElement request) {
        return new StringBuilder(10).append(StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(((Object)BoxesRunTime.boxToInteger((int)request.id())).toString()), 4, "0")).append("_response.").append(request.responseFileExtension()).toString();
    }

    public String responseBodyRelativeFilePath(RequestElement request, RecorderConfiguration config) {
        return new StringBuilder(2).append(this.packageAsFolderPath("/", config)).append("/").append(this.classNameToFolderName(config)).append("/").append(this.responseBodyFileName(request)).toString();
    }

    public Validation<BoxedUnit> exportScenario(String harFilePath, RecorderConfiguration config) {
        return io.gatling.commons.validation.package$.MODULE$.safely((Function1 & Serializable & scala.Serializable)error -> new StringBuilder(33).append("Error while processing HAR file: ").append((String)error).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            Failure failure;
            Seq<HttpTransaction> transactions = HarReader$.MODULE$.readFile(harFilePath, config.filters().filters());
            if (transactions.isEmpty()) {
                failure = package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("the selected file doesn't contain any valid HTTP requests"));
            } else {
                Seq scenarioElements = (Seq)transactions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HttpTransaction httpTransaction = x0$1;
                    if (httpTransaction == null) {
                        throw new MatchError((Object)httpTransaction);
                    }
                    HttpRequest request = httpTransaction.request();
                    HttpResponse response = httpTransaction.response();
                    RequestElement element = RequestElement$.MODULE$.apply(request, response, config);
                    TimedScenarioElement<RequestElement> timedScenarioElement = new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), element);
                    return timedScenarioElement;
                }, Seq$.MODULE$.canBuildFrom());
                MODULE$.saveScenario(ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)scenarioElements, (Seq<TimedScenarioElement<TagElement>>)Nil$.MODULE$, config), config);
                failure = package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)BoxedUnit.UNIT));
            }
            return failure;
        });
    }

    public void saveScenario(ScenarioDefinition scenarioElements, RecorderConfiguration config) {
        Predef$.MODULE$.require(!scenarioElements.isEmpty());
        String output = this.renderScenarioAndDumpBodies(scenarioElements, config);
        Io$.MODULE$.withCloseable((AutoCloseable)PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(this.simulationFilePath(config))), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.write(output.getBytes(config.core().encoding()));
            return BoxedUnit.UNIT;
        });
    }

    private String renderScenarioAndDumpBodies(ScenarioDefinition scenario, RecorderConfiguration config) {
        Set filteredHeaders = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.COOKIE, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderNames.HOST}))).$plus$plus((GenTraversableOnce)(config.http().automaticReferer() ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.REFERER})) : Predef$.MODULE$.Set().empty()));
        Seq<ScenarioElement> scenarioElements = scenario.elements();
        Seq mainRequestElements = (Seq)scenarioElements.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScenarioElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)A1;
                    object = requestElement;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScenarioElement x1) {
                ScenarioElement scenarioElement = x1;
                boolean bl = scenarioElement instanceof RequestElement;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq requestElements = (Seq)mainRequestElements.flatMap((Function1 & Serializable & scala.Serializable)req -> {
            RequestElement requestElement = req;
            return req.nonEmbeddedResources().$colon$colon((Object)requestElement);
        }, Seq$.MODULE$.canBuildFrom());
        requestElements.foreach((Function1 & Serializable & scala.Serializable)requestElement -> {
            Object object = requestElement.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true) ? requestElement.headers().remove((CharSequence)HttpHeaderNames.CONNECTION) : BoxedUnit.UNIT;
            java.util.List authorizationHeaders = requestElement.headers().getAll((CharSequence)HttpHeaderNames.AUTHORIZATION);
            return requestElement.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (java.lang.Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizationHeaders).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("Basic ")))).asJava());
        });
        String baseUrl = this.getBaseUrl((Seq<RequestElement>)mainRequestElements);
        HttpHeaders baseHeaders = this.getBaseHeaders((Seq<RequestElement>)requestElements);
        ProtocolDefinition protocolConfigElement = new ProtocolDefinition(baseUrl, baseHeaders);
        Seq elements = (Seq)scenarioElements.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScenarioElement scenarioElement;
            ScenarioElement scenarioElement2 = x0$1;
            if (scenarioElement2 instanceof RequestElement) {
                RequestElement requestElement = (RequestElement)scenarioElement2;
                requestElement.nonEmbeddedResources().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.makeRelativeTo(baseUrl));
                scenarioElement = requestElement.makeRelativeTo(baseUrl);
            } else {
                scenarioElement = scenarioElement2;
            }
            return scenarioElement;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)requestElements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RequestElement reqEl = (RequestElement)tuple2._1();
            int index = tuple2._2$mcI$sp();
            RequestElement requestElement = reqEl.setId(index);
            return requestElement;
        }, Seq$.MODULE$.canBuildFrom());
        requestElements.foreach((Function1 & Serializable & scala.Serializable)el -> {
            ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$7(config, el);
            return BoxedUnit.UNIT;
        });
        if (config.http().checkResponseBodies()) {
            requestElements.foreach((Function1 & Serializable & scala.Serializable)el -> {
                ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$9(config, el);
                return BoxedUnit.UNIT;
            });
        }
        Map headers = (Map)SortedMap$.MODULE$.apply(this.generateHeaders$1(requestElements, Predef$.MODULE$.Map().empty(), filteredHeaders, baseHeaders).toSeq(), (Ordering)Ordering.Int$.MODULE$);
        Either<Seq<ScenarioElement>, List<Seq<ScenarioElement>>> newScenarioElements = this.getChains((Seq<ScenarioElement>)elements);
        return SimulationTemplate$.MODULE$.render(config.core().pkg(), config.core().className(), protocolConfigElement, (Map<Object, Seq<Tuple2<String, String>>>)headers, config.core().className(), newScenarioElements, config);
    }

    /*
     * WARNING - void declaration
     */
    private HttpHeaders getBaseHeaders(Seq<RequestElement> requestElements) {
        void var2_2;
        DefaultHttpHeaders baseHeaders = new DefaultHttpHeaders(false);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(ProtocolDefinition$.MODULE$.BaseHeadersAndProtocolMethods().names()).asScala()).foreach((Function1 & Serializable & scala.Serializable)headerName -> {
            BoxedUnit boxedUnit;
            Option option = ScenarioExporter$.getMostFrequentHeaderValue$1(headerName, requestElements);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mostFrequentValue = (String)some.value();
                boxedUnit = baseHeaders.add(headerName, (Object)mostFrequentValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var2_2;
    }

    private String getBaseUrl(Seq<RequestElement> requestElements) {
        Seq urlsOccurrences = ((TraversableLike)requestElements.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.baseUrl(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size())).toSeq();
        return (String)((Tuple2)urlsOccurrences.maxBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private Either<Seq<ScenarioElement>, List<Seq<ScenarioElement>>> getChains(Seq<ScenarioElement> scenarioElements) {
        return scenarioElements.size() > this.EventsGrouping() ? package$.MODULE$.Right().apply((Object)scenarioElements.grouped(this.EventsGrouping()).toList()) : package$.MODULE$.Left().apply(scenarioElements);
    }

    private void dumpBody(String fileName, byte[] content, RecorderConfiguration config) {
        Io$.MODULE$.withCloseable((AutoCloseable)PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(PathHelper.RichPath$.MODULE$.$div$extension0(PathHelper$.MODULE$.RichPath(this.resourcesFolderPath(config)), fileName))), (Function1 & Serializable & scala.Serializable)fw -> {
            ScenarioExporter$.$anonfun$dumpBody$1(content, fileName, fw);
            return BoxedUnit.UNIT;
        });
    }

    private Path getFolder(String folderPath) {
        return PathHelper.RichPath$.MODULE$.mkdirs$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(folderPath)));
    }

    public static final /* synthetic */ void $anonfun$renderScenarioAndDumpBodies$8(RequestElement el$1, RecorderConfiguration config$3, RequestBody x0$3) {
        RequestBody requestBody = x0$3;
        if (requestBody instanceof RequestBodyBytes) {
            RequestBodyBytes requestBodyBytes = (RequestBodyBytes)requestBody;
            byte[] bytes = requestBodyBytes.bytes();
            MODULE$.dumpBody(MODULE$.requestBodyFileName(el$1), bytes, config$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$renderScenarioAndDumpBodies$7(RecorderConfiguration config$3, RequestElement el) {
        el.body().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$8(el, config$3, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$renderScenarioAndDumpBodies$10(RequestElement el$2, RecorderConfiguration config$3, ResponseBody x0$4) {
        ResponseBody responseBody = x0$4;
        if (responseBody instanceof ResponseBodyBytes) {
            ResponseBodyBytes responseBodyBytes = (ResponseBodyBytes)responseBody;
            byte[] bytes = responseBodyBytes.bytes();
            MODULE$.dumpBody(MODULE$.responseBodyFileName(el$2), bytes, config$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$renderScenarioAndDumpBodies$9(RecorderConfiguration config$3, RequestElement el) {
        el.responseBody().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$10(el, config$3, x0$4);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$12(Set filteredHeaders$1, HttpHeaders baseHeaders$1, RequestElement element$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var5_4 = x0$1;
                if (var5_4 == null) break block2;
                headerName = (String)var5_4._1();
                headerValue = (String)var5_4._2();
                isFiltered = HttpUtils$.MODULE$.containsIgnoreCase((Iterable<AsciiString>)filteredHeaders$1, headerName) != false || HttpUtils$.MODULE$.isHttp2PseudoHeader(headerName) != false;
                isAlreadyInBaseHeaders = HttpUtils$.MODULE$.getIgnoreCase(baseHeaders$1, headerName).contains((Object)headerValue);
                v0 = element$1.method();
                var11_9 = HttpMethod.POST.name();
                v1 = !(v0 != null ? v0.equals(var11_9) == false : var11_9 != null) && HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEqualsIgnoreCase((CharSequence)headerValue) != false ? true : (isPostWithFormParams = false);
                if (!HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)headerName)) ** GOTO lbl-1000
                v2 = headerValue;
                var13_11 = "0";
                if (!(v2 != null ? v2.equals(var13_11) == false : var13_11 != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                break block3;
            }
            throw new MatchError((Object)var5_4);
        }
        isEmptyContentLength = v3;
        var4_13 = isFiltered != false || isAlreadyInBaseHeaders != false || isPostWithFormParams != false || isEmptyContentLength != false;
        return var4_13;
    }

    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$14(List acceptedHeaders$1, Tuple2 x0$2) {
        List existingHeaders;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List list = existingHeaders = (List)tuple2._2();
        List list2 = acceptedHeaders$1;
        boolean bl = !(list != null ? !list.equals(list2) : list2 != null);
        return bl;
    }

    private final Map generateHeaders$1(Seq elements, Map headers, Set filteredHeaders$1, HttpHeaders baseHeaders$1) {
        block6: {
            Seq seq;
            while (true) {
                Map newHeaders;
                Map map;
                Some some;
                if (!(some = Seq$.MODULE$.unapplySeq(seq = elements)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) break block6;
                Option option = package$.MODULE$.$plus$colon().unapply((SeqLike)seq);
                if (option.isEmpty()) break;
                RequestElement element = (RequestElement)((Tuple2)option.get())._1();
                Seq others = (Seq)((Tuple2)option.get())._2();
                List acceptedHeaders = (List)((SeqLike)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(element.headers().entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), e.getValue()), Buffer$.MODULE$.canBuildFrom())).toList().filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$12(filteredHeaders$1, baseHeaders$1, element, x0$1)))).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), (Ordering)Ordering.String$.MODULE$);
                if (acceptedHeaders.isEmpty()) {
                    element.filteredHeadersId_$eq((Option<Object>)None$.MODULE$);
                    map = headers;
                } else {
                    Seq headersSeq = headers.toSeq();
                    int n = headersSeq.indexWhere((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ScenarioExporter$.$anonfun$renderScenarioAndDumpBodies$14(acceptedHeaders, x0$2)));
                    switch (n) {
                        case -1: {
                            element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)element.id())));
                            map = headers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)element.id())), (Object)acceptedHeaders));
                            break;
                        }
                        default: {
                            element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((Tuple2)headersSeq.apply(n))._1$mcI$sp())));
                            map = headers;
                            break;
                        }
                    }
                }
                headers = newHeaders = map;
                elements = others;
            }
            throw new MatchError((Object)seq);
        }
        Map map = headers;
        return map;
    }

    private static final Option getMostFrequentHeaderValue$1(String headerName, Seq requestElements$1) {
        None$ none$;
        Seq headers = (Seq)requestElements$1.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.headers().getAll(headerName)).asScala(), Seq$.MODULE$.canBuildFrom());
        if (headers.isEmpty() || headers.length() != requestElements$1.length()) {
            none$ = None$.MODULE$;
        } else {
            Seq headersValuesOccurrences = headers.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size())).toSeq();
            String mostFrequentValue = (String)((Tuple2)headersValuesOccurrences.maxBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
            none$ = new Some((Object)mostFrequentValue);
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$dumpBody$1(byte[] content$1, String fileName$1, OutputStream fw) {
        block3: {
            try {
                fw.write(content$1);
            }
            catch (IOException e) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(new StringBuilder(29).append("Error, while dumping body ").append(fileName$1).append("...").toString(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private ScenarioExporter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.EventsGrouping = 100;
    }
}

