/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.shared.unstable.util.PathHelper;
import io.gatling.commons.shared.unstable.util.PathHelper$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.core.filter.Filters$;
import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.http.Mitm;
import io.gatling.recorder.http.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.SslFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!\u0002\n\u0014\u0001UY\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bY\u0002A\u0011A\u001c\t\u000fm\u0002!\u0019!C\u0005y!11\t\u0001Q\u0001\nuB\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011B#\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"C*\u0001\u0001\u0004\u0005\t\u0015)\u0003G\u0011\u001dA\u0006A1A\u0005\neCa\u0001\u001c\u0001!\u0002\u0013Q\u0006bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007i\u0002\u0001\u000b\u0011B8\t\u000bU\u0004A\u0011\u0001<\t\u000b]\u0004A\u0011\u0001=\t\u000by\u0004A\u0011A@\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002BBA*\u0001\u0011\u0005aO\u0001\nSK\u000e|'\u000fZ3s\u0007>tGO]8mY\u0016\u0014(B\u0001\u000b\u0016\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0003-]\t\u0001B]3d_J$WM\u001d\u0006\u00031e\tqaZ1uY&twMC\u0001\u001b\u0003\tIwnE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012+\u001b\u0005!#BA\u0013'\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0003&\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0013aA2p[&\u00111\u0006\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u000b\rdwnY6\u0004\u0001A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGN\u0003\u00024/\u000591m\\7n_:\u001c\u0018BA\u001b1\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q\u0011\u0001H\u000f\t\u0003s\u0001i\u0011a\u0005\u0005\u0006Y\t\u0001\rAL\u0001\tMJ|g\u000e^#oIV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A+\u0005\u0011Q/[\u0005\u0003\u0005~\u0012\u0001CU3d_J$WM\u001d$s_:$XI\u001c3\u0002\u0013\u0019\u0014xN\u001c;F]\u0012\u0004\u0013\u0001B7ji6,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013V\tA\u0001\u001b;ua&\u00111\n\u0013\u0002\u0005\u001b&$X.\u0001\u0005nSRlw\fJ3r)\tq\u0015\u000b\u0005\u0002\u001e\u001f&\u0011\u0001K\b\u0002\u0005+:LG\u000fC\u0004S\r\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'A\u0003nSRl\u0007\u0005\u000b\u0002\b+B\u0011QDV\u0005\u0003/z\u0011\u0001B^8mCRLG.Z\u0001\te\u0016\fX/Z:ugV\t!\fE\u0002\\C\u000el\u0011\u0001\u0018\u0006\u0003;z\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\ttLC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\td&!F\"p]\u000e,(O]3oi2Kgn[3e#V,W/\u001a\t\u0004I\u001eLW\"A3\u000b\u0005\u0019,\u0012\u0001C:dK:\f'/[8\n\u0005!,'\u0001\u0006+j[\u0016$7kY3oCJLw.\u00127f[\u0016tG\u000f\u0005\u0002eU&\u00111.\u001a\u0002\u000f%\u0016\fX/Z:u\u000b2,W.\u001a8u\u0003%\u0011X-];fgR\u001c\b%\u0001\u0003uC\u001e\u001cX#A8\u0011\u0007m\u000b\u0007\u000fE\u0002eOF\u0004\"\u0001\u001a:\n\u0005M,'A\u0003+bO\u0016cW-\\3oi\u0006)A/Y4tA\u0005q1\u000f^1siJ+7m\u001c:eS:<G#\u0001(\u0002\u001bM$x\u000e\u001d*fG>\u0014H-\u001b8h)\tq\u0015\u0010C\u0003{\u001b\u0001\u000710\u0001\u0003tCZ,\u0007CA\u000f}\u0013\tihDA\u0004C_>dW-\u00198\u0002\u001fI,7-Z5wKJ+7\u000f]8og\u0016$RATA\u0001\u0003#Aq!a\u0001\u000f\u0001\u0004\t)!A\u0004sKF,Xm\u001d;\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u0016\u0003\u0015iw\u000eZ3m\u0013\u0011\ty!!\u0003\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0003'q\u0001\u0019AA\u000b\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA\u0004\u0003/IA!!\u0007\u0002\n\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u00061\u0011\r\u001a3UC\u001e$2ATA\u0010\u0011\u001d\t\tc\u0004a\u0001\u0003G\tA\u0001^3yiB!\u0011QEA\u001a\u001d\u0011\t9#a\f\u0011\u0007\u0005%b$\u0004\u0002\u0002,)\u0019\u0011QF\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t\tDH\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Eb$\u0001\ttK\u000e,(/Z\"p]:,7\r^5p]R\u0019a*!\u0010\t\u000f\u0005}\u0002\u00031\u0001\u0002B\u0005q1/Z2ve\u0016$\u0007j\\:u+JK\u0005\u0003BA\"\u0003\u001fj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0004kJL'\u0002BA&\u0003\u001b\naa\u00197jK:$(BA%\u0018\u0013\u0011\t\t&!\u0012\u0003\u0007U\u0013\u0018.\u0001\ndY\u0016\f'OU3d_J$WM]*uCR,\u0007")
public class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private volatile Mitm mitm;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        String harFilePath = this.frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(Paths.get(harFilePath, new String[0])))) {
            this.frontEnd().handleMissingHarFile(harFilePath);
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = proceed = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.frontEnd().askSimulationOverwrite() : true;
            if (proceed) {
                RecorderMode recorderMode2 = selectedMode;
                if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                    Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, RecorderConfiguration$.MODULE$.configuration());
                    if (validation instanceof Failure) {
                        Failure failure = (Failure)validation;
                        String errMsg = failure.message();
                        this.frontEnd().handleHarExportFailure(errMsg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.frontEnd().handleHarExportSuccess();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                    this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, RecorderConfiguration$.MODULE$.configuration()));
                    this.frontEnd().recordingStarted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)recorderMode2);
                }
            }
        }
    }

    public void stopRecording(boolean save) {
        this.frontEnd().recordingStopped();
        try {
            if (this.requests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().toVector(), (Seq<TimedScenarioElement<TagElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.tags()).asScala().toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        block0: {
            if (!RecorderConfiguration$.MODULE$.configuration().filters().filters().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.accept(request.uri()))) || !Filters$.MODULE$.BrowserNoiseFilters().accept(request.uri())) break block0;
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, RecorderConfiguration$.MODULE$.configuration())));
            Option previousSendTime = CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)t -> {
                block0: {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                    if (!delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) break block0;
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEvent(new SslFrontEndEvent(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
        Statics.releaseFence();
    }
}

