/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario.template;

import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.scenario.PauseElement;
import io.gatling.recorder.scenario.ProtocolDefinition;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.ScenarioElement;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.template.ExtractedUris;
import io.gatling.recorder.scenario.template.PauseTemplate$;
import io.gatling.recorder.scenario.template.ProtocolTemplate$;
import io.gatling.recorder.scenario.template.RequestTemplate$;
import io.gatling.recorder.scenario.template.Value;
import io.gatling.recorder.scenario.template.ValuesTemplate$;
import io.gatling.recorder.scenario.template.package$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SimulationTemplate$ {
    public static final SimulationTemplate$ MODULE$ = new SimulationTemplate$();

    public String render(String packageName, String simulationClassName, ProtocolDefinition protocol, Map<Object, Seq<Tuple2<String, String>>> headers, String scenarioName, Either<Seq<ScenarioElement>, Seq<Seq<ScenarioElement>>> scenarioElements, RecorderConfiguration config) {
        ExtractedUris extractedUris = new ExtractedUris((Seq<ScenarioElement>)SimulationTemplate$.flatScenarioElements$1(scenarioElements));
        List nonBaseUrls = extractedUris.vals().filter((Function1 & Serializable)extractedUri -> BoxesRunTime.boxToBoolean((boolean)SimulationTemplate$.$anonfun$render$7(protocol, extractedUri)));
        return new StringBuilder(256).append(SimulationTemplate$.renderPackage$1(packageName)).append("\nimport scala.concurrent.duration._\n\nimport io.gatling.core.Predef._\nimport io.gatling.http.Predef._\nimport io.gatling.jdbc.Predef._\n\nclass ").append(simulationClassName).append(" extends Simulation {\n\n\tval httpProtocol = http").append(SimulationTemplate$.renderProtocol$1(protocol, config)).append("\n\n").append(SimulationTemplate$.renderHeaders$1(headers)).append("\n\n").append(ValuesTemplate$.MODULE$.render((Seq<Value>)nonBaseUrls)).append("\n\n\t").append(SimulationTemplate$.renderScenario$1(extractedUris, scenarioElements, scenarioName, simulationClassName, config)).append("\n\n\tsetUp(scn.inject(atOnceUsers(1))).protocols(httpProtocol)\n}").toString();
    }

    private static final String renderPackage$1(String packageName$1) {
        return !packageName$1.isEmpty() ? new StringBuilder(9).append("package ").append(packageName$1).append("\n").toString() : "";
    }

    private static final String printHeaders$1(Seq headers) {
        String string;
        Tuple2 tuple2;
        SeqOps seqOps;
        Seq seq = headers;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            string = new StringBuilder(9).append("Map(").append(package$.MODULE$.protectWithTripleQuotes(name)).append(" -> ").append(package$.MODULE$.protectWithTripleQuotes(value)).append(")").toString();
        } else {
            String mapContent = ((IterableOnceOps)headers.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = new StringBuilder(6).append("\t\t").append(package$.MODULE$.protectWithTripleQuotes(name)).append(" -> ").append(package$.MODULE$.protectWithTripleQuotes(value)).toString();
                return string;
            })).mkString(",\n");
            string = new StringBuilder(6).append("Map(\n").append(mapContent).append(")").toString();
        }
        return string;
    }

    private static final String renderHeaders$1(Map headers$1) {
        return ((IterableOnceOps)headers$1.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int headersBlockIndex = tuple2._1$mcI$sp();
            Seq headersBlock = (Seq)tuple2._2();
            String string = new StringBuilder(8).append("\tval ").append(RequestTemplate$.MODULE$.headersBlockName(headersBlockIndex)).append(" = ").append(SimulationTemplate$.printHeaders$1(headersBlock)).toString();
            return string;
        })).mkString("\n\n");
    }

    private static final String renderScenarioElement$1(ScenarioElement se, ExtractedUris extractedUris, String simulationClassName$1, RecorderConfiguration config$1) {
        String string;
        ScenarioElement scenarioElement = se;
        if (scenarioElement instanceof TagElement) {
            TagElement tagElement = (TagElement)scenarioElement;
            String text = tagElement.text();
            string = new StringBuilder(3).append("// ").append(text).toString();
        } else if (scenarioElement instanceof PauseElement) {
            PauseElement pauseElement = (PauseElement)scenarioElement;
            FiniteDuration duration = pauseElement.duration();
            string = PauseTemplate$.MODULE$.render(duration);
        } else if (scenarioElement instanceof RequestElement) {
            RequestElement requestElement = (RequestElement)scenarioElement;
            string = RequestTemplate$.MODULE$.render(simulationClassName$1, requestElement, extractedUris, config$1);
        } else {
            throw new MatchError((Object)scenarioElement);
        }
        return string;
    }

    private static final String renderProtocol$1(ProtocolDefinition p, RecorderConfiguration config$1) {
        return ProtocolTemplate$.MODULE$.render(p, config$1);
    }

    public static final /* synthetic */ String $anonfun$render$6(int i) {
        return new StringBuilder(6).append("chain_").append(i).toString();
    }

    private static final String renderScenario$1(ExtractedUris extractedUris, Either scenarioElements$1, String scenarioName$1, String simulationClassName$1, RecorderConfiguration config$1) {
        String string;
        Either either = scenarioElements$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            Seq elements = (Seq)left.value();
            String scenarioElements = ((IterableOnceOps)elements.map((Function1 & Serializable)element -> {
                ScenarioElement scenarioElement = element;
                String string = scenarioElement instanceof TagElement ? "" : ".";
                String prefix = string;
                return new StringBuilder(0).append(prefix).append(SimulationTemplate$.renderScenarioElement$1(element, extractedUris, simulationClassName$1, config$1)).toString();
            })).mkString("\n\t\t");
            string = new StringBuilder(25).append("val scn = scenario(\"").append(scenarioName$1).append("\")\n\t\t").append(scenarioElements).toString();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq chains = (Seq)right.value();
            String chainElements = ((IterableOnceOps)((IterableOps)chains.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq chain = (Seq)tuple2._1();
                int i = tuple2._2$mcI$sp();
                BooleanRef firstNonTagElement = BooleanRef.create((boolean)true);
                String chainContent = ((IterableOnceOps)chain.map((Function1 & Serializable)element -> {
                    String string;
                    ScenarioElement scenarioElement = element;
                    if (scenarioElement instanceof TagElement) {
                        string = "";
                    } else {
                        String string2;
                        if (firstNonTagElement$1.elem) {
                            firstNonTagElement$1.elem = false;
                            string2 = "";
                        } else {
                            string2 = ".";
                        }
                        string = string2;
                    }
                    String prefix = string;
                    return new StringBuilder(0).append(prefix).append(SimulationTemplate$.renderScenarioElement$1(element, extractedUris, simulationClassName$1, config$1)).toString();
                })).mkString("\n\t\t");
                String string = new StringBuilder(13).append("val chain_").append(i).append(" = ").append(chainContent).toString();
                return string;
            })).mkString("\n\n");
            String chainsList = chains.indices().map((Function1 & Serializable)i -> SimulationTemplate$.$anonfun$render$6(BoxesRunTime.unboxToInt((Object)i))).mkString(", ");
            string = new StringBuilder(35).append(chainElements).append("\n\n\tval scn = scenario(\"").append(scenarioName$1).append("\").exec(\n\t\t").append(chainsList).append(")").toString();
        } else {
            throw new MatchError((Object)either);
        }
        return string;
    }

    private static final Seq flatScenarioElements$1(Either scenarioElements) {
        Seq seq;
        Either either = scenarioElements;
        if (either instanceof Left) {
            Seq elements;
            Left left = (Left)either;
            seq = elements = (Seq)left.value();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq elements = (Seq)right.value();
            seq = (Seq)elements.flatten(Predef$.MODULE$.$conforms());
        } else {
            throw new MatchError((Object)either);
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$render$7(ProtocolDefinition protocol$1, Value extractedUri) {
        String uriWithScheme = extractedUri.value().startsWith("http") ? extractedUri.value() : new StringBuilder(7).append("http://").append(extractedUri.value()).toString();
        String string = Uri.create((String)uriWithScheme).getBaseUrl();
        String string2 = protocol$1.baseUrl();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private SimulationTemplate$() {
    }
}

