/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.convert.template;

import io.gatling.commons.util.StringHelper$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.convert.DumpedBody;
import io.gatling.recorder.convert.RequestBody;
import io.gatling.recorder.convert.RequestBodyParams;
import io.gatling.recorder.convert.RequestElement;
import io.gatling.recorder.convert.template.ExtractedUris;
import io.gatling.recorder.convert.template.Format;
import io.gatling.recorder.convert.template.Format$Kotlin$;
import io.gatling.recorder.convert.template.RequestTemplate$;
import io.gatling.recorder.convert.template.SimulationTemplate$;
import io.gatling.recorder.convert.template.package$;
import io.gatling.recorder.convert.template.package$TemplateString$;
import java.io.Serializable;
import java.util.Locale;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%sAB\r\u001b\u0011\u0003aBE\u0002\u0004'5!\u0005Ad\n\u0005\u0006]\u0005!\t\u0001\r\u0005\u0006c\u0005!\tA\r\u0005\b\u0001\u0006\u0011\r\u0011\"\u0003B\u0011\u0019\t\u0016\u0001)A\u0005\u0005\"9!+\u0001b\u0001\n\u0013\u0019\u0006BB,\u0002A\u0003%AKB\u0003'5\u0001a\u0002\f\u0003\u0005Z\u0011\t\u0005\t\u0015!\u0003[\u0011!\t\u0007B!A!\u0002\u0013Q\u0006\u0002\u00032\t\u0005\u0003\u0005\u000b\u0011B2\t\u000b9BA\u0011\u00015\t\u000f5D!\u0019!C\u0005]\"1!\u000f\u0003Q\u0001\n=Dqa\u001d\u0005C\u0002\u0013%A\u000f\u0003\u0004v\u0011\u0001\u0006IA\u0013\u0005\u0006m\"!Ia\u001e\u0005\b\u0003\u000bAA\u0011BA\u0004\u0011\u001d\tY\u0001\u0003C\u0005\u0003\u001bAq!!\u0005\t\t\u0013\t\u0019\u0002C\u0004\u0002\u0018!!I!!\u0007\t\u000f\u0005\r\u0002\u0002\"\u0003\u0002&!9\u0011\u0011\u0006\u0005\u0005\n\u0005-\u0002bBA\u0018\u0011\u0011\u0005\u0011\u0011G\u0001\u0010%\u0016\fX/Z:u)\u0016l\u0007\u000f\\1uK*\u00111\u0004H\u0001\ti\u0016l\u0007\u000f\\1uK*\u0011QDH\u0001\bG>tg/\u001a:u\u0015\ty\u0002%\u0001\u0005sK\u000e|'\u000fZ3s\u0015\t\t#%A\u0004hCRd\u0017N\\4\u000b\u0003\r\n!![8\u0011\u0005\u0015\nQ\"\u0001\u000e\u0003\u001fI+\u0017/^3tiR+W\u000e\u001d7bi\u0016\u001c\"!\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0013\u0002-M\fg.\u001b;ju\u0016\u0014V-];fgR\u0004vn\u001d;gSb$\"a\r \u0011\u0005QZdBA\u001b:!\t1$&D\u00018\u0015\tAt&\u0001\u0004=e>|GOP\u0005\u0003u)\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!H\u000b\u0005\u0006\u007f\r\u0001\raM\u0001\ba>\u001cHOZ5y\u0003I\u0011U/\u001b7u\u0013:DE\u000f\u001e9NKRDw\u000eZ:\u0016\u0003\t\u00032a\u0011%K\u001b\u0005!%BA#G\u0003%IW.\\;uC\ndWM\u0003\u0002HU\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%#%\u0001\u0002'jgR\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\taD*A\nCk&dG/\u00138IiR\u0004X*\u001a;i_\u0012\u001c\b%\u0001\bNCbd\u0015\u000e^3sC2\u001c\u0016N_3\u0016\u0003Q\u0003\"!K+\n\u0005YS#aA%oi\u0006yQ*\u0019=MSR,'/\u00197TSj,\u0007e\u0005\u0002\tQ\u0005i!/Z9vKN$(i\u001c3jKN\u0004B\u0001N.U;&\u0011A,\u0010\u0002\u0004\u001b\u0006\u0004\bC\u00010`\u001b\u0005a\u0012B\u00011\u001d\u0005)!U/\u001c9fI\n{G-_\u0001\u000fe\u0016\u001c\bo\u001c8tK\n{G-[3t\u0003\u0019\u0019wN\u001c4jOB\u0011AMZ\u0007\u0002K*\u0011!MH\u0005\u0003O\u0016\u0014QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003jU.d\u0007CA\u0013\t\u0011\u0015IF\u00021\u0001[\u0011\u0015\tG\u00021\u0001[\u0011\u0015\u0011G\u00021\u0001d\u0003\u00191wN]7biV\tq\u000e\u0005\u0002&a&\u0011\u0011O\u0007\u0002\u0007\r>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u00059\u0011n]\"iK\u000e\\W#\u0001&\u0002\u0011%\u001c8\t[3dW\u0002\nAB]3oI\u0016\u0014X*\u001a;i_\u0012$2a\r=~\u0011\u0015I\u0018\u00031\u0001{\u0003\u001d\u0011X-];fgR\u0004\"AX>\n\u0005qd\"A\u0004*fcV,7\u000f^#mK6,g\u000e\u001e\u0005\u0006}F\u0001\ra`\u0001\rKb$(/Y2uK\u0012,&/\u001b\t\u0004K\u0005\u0005\u0011bAA\u00025\tiQ\t\u001f;sC\u000e$X\rZ+sSN\fQB]3oI\u0016\u0014\b*Z1eKJ\u001cHcA\u001a\u0002\n!)\u0011P\u0005a\u0001u\u0006\u0011\"/\u001a8eKJ\u0014u\u000eZ=PeB\u000b'/Y7t)\r\u0019\u0014q\u0002\u0005\u0006sN\u0001\rA_\u0001\u001be\u0016tG-\u001a:CCNL7-Q;uQ\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0004g\u0005U\u0001\"B=\u0015\u0001\u0004Q\u0018a\u0004:f]\u0012,'OU3t_V\u00148-Z:\u0015\u000fM\nY\"a\b\u0002\"!1\u0011QD\u000bA\u0002M\nqb]5nk2\fG/[8o\u00072\f7o\u001d\u0005\u0006sV\u0001\rA\u001f\u0005\u0006}V\u0001\ra`\u0001\u0012e\u0016tG-\u001a:Ti\u0006$Xo]\"iK\u000e\\GcA\u001a\u0002(!)\u0011P\u0006a\u0001u\u00069\"/\u001a8eKJ\u0014Vm\u001d9p]N,'i\u001c3z\u0007\",7m\u001b\u000b\u0004g\u00055\u0002\"B=\u0018\u0001\u0004Q\u0018A\u0002:f]\u0012,'\u000fF\u00044\u0003g\t)$a\u000e\t\r\u0005u\u0001\u00041\u00014\u0011\u0015I\b\u00041\u0001{\u0011\u0015q\b\u00041\u0001\u0000Q\u001dA\u00121HA!\u0003\u0007\u00022aSA\u001f\u0013\r\ty\u0004\u0014\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d#!!\u0012\"\u0005\u0005\u001d\u0013aH8sO::\u0018M\u001d;sK6|g/\u001a:/o\u0006\u0014Ho\u001d\u0018SK\u000e,(o]5p]\u0002")
public class RequestTemplate {
    private final Map<Object, DumpedBody> requestBodies;
    private final Map<Object, DumpedBody> responseBodies;
    private final RecorderConfiguration config;
    private final Format format;
    private final String isCheck;

    public static String sanitizeRequestPostfix(String postfix) {
        return RequestTemplate$.MODULE$.sanitizeRequestPostfix(postfix);
    }

    private Format format() {
        return this.format;
    }

    private String isCheck() {
        return this.isCheck;
    }

    private String renderMethod(RequestElement request, ExtractedUris extractedUri) {
        String string = request.printedUrl();
        String string2 = request.uri();
        String renderedUrl = !(string != null ? !string.equals(string2) : string2 != null) ? extractedUri.renderUri(request.uri()) : package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(request.printedUrl()), this.format());
        return RequestTemplate$.MODULE$.io$gatling$recorder$convert$template$RequestTemplate$$BuiltInHttpMethods().contains((Object)request.method()) ? new StringBuilder(2).append(request.method().toLowerCase(Locale.ROOT)).append("(").append(renderedUrl).append(")").toString() : new StringBuilder(17).append("httpRequest(\"").append(request.method()).append("\", ").append(renderedUrl).append(")").toString();
    }

    private String renderHeaders(RequestElement request) {
        String string;
        Option<Object> option = request.filteredHeadersId();
        if (option instanceof Some) {
            Some some = (Some)option;
            int id = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringBuilder(10).append(".headers(").append(SimulationTemplate$.MODULE$.headersBlockName(id)).append(")").toString();
        } else {
            string = "";
        }
        return string;
    }

    private String renderBodyOrParams(RequestElement request) {
        String string;
        Some some;
        RequestBody requestBody;
        Option<RequestBody> option = request.body();
        if (option instanceof Some && (requestBody = (RequestBody)(some = (Some)option).value()) instanceof RequestBodyParams) {
            RequestBodyParams requestBodyParams = (RequestBodyParams)requestBody;
            List<Tuple2<String, String>> params = requestBodyParams.params();
            string = params.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(14).append(".formParam(").append(package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(key), this.format())).append(", ").append(this.renderLongString$1(value)).append(")").toString()));
                return string;
            }).mkString(new StringBuilder(2).append(StringHelper$.MODULE$.Eol()).append("  ").toString());
        } else {
            String string2;
            Option option2 = this.requestBodies.get((Object)BoxesRunTime.boxToInteger((int)request.id()));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                DumpedBody dumpedBody = (DumpedBody)some2.value();
                string2 = new StringBuilder(22).append(".body(RawFileBody(\"").append(dumpedBody.classPathLocation()).append("\"))").toString();
            } else {
                string2 = "";
            }
            string = string2;
        }
        return string;
    }

    private String renderBasicAuthCredentials(RequestElement request) {
        String string;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = request.basicAuthCredentials();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            string = new StringBuilder(13).append(".basicAuth(").append(package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(username), this.format())).append(",").append(package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(password), this.format())).append(")").toString();
        } else {
            string = "";
        }
        return string;
    }

    private String renderResources(String simulationClass, RequestElement request, ExtractedUris extractedUri) {
        return request.nonEmbeddedResources().nonEmpty() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append(".resources(\n         |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(((List)request.nonEmbeddedResources().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RequestElement resource = (RequestElement)tuple2._1();
            String string = this.render(simulationClass, resource, extractedUri);
            return string;
        }).mkString(new StringBuilder(1).append(",").append(StringHelper$.MODULE$.Eol()).toString())), 2)).append("\n         |)").toString())) : "";
    }

    private String renderStatusCheck(RequestElement request) {
        return !HttpHelper$.MODULE$.isOk(request.statusCode()) ? new StringBuilder(17).append(".check(status").append(this.format().parameterlessMethodCall()).append(".").append(this.isCheck()).append("(").append(request.statusCode()).append("))").toString() : "";
    }

    private String renderResponseBodyCheck(RequestElement request) {
        String string;
        Option option = this.responseBodies.get((Object)BoxesRunTime.boxToInteger((int)request.id()));
        if (option instanceof Some) {
            Some some = (Some)option;
            DumpedBody dumpedBody = (DumpedBody)some.value();
            string = new StringBuilder(35).append(".check(bodyBytes").append(this.format().parameterlessMethodCall()).append(".").append(this.isCheck()).append("(RawFileBody(\"").append(dumpedBody.classPathLocation()).append("\")))").toString();
        } else {
            string = "";
        }
        return string;
    }

    public String render(String simulationClass, RequestElement request, ExtractedUris extractedUri) {
        String prefix = this.config.http().useSimulationAsPrefix() ? simulationClass : "request";
        String postfix = this.config.http().useMethodAndUriAsPostfix() ? new StringBuilder(1).append(":").append(RequestTemplate$.MODULE$.sanitizeRequestPostfix(new StringBuilder(1).append(request.method()).append("_").append(request.uri()).toString())).toString() : "";
        return package$TemplateString$.MODULE$.noEmptyLines$extension(package$.MODULE$.TemplateString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("http(\"").append(prefix).append("_").append(request.id()).append(postfix).append("\")\n       |  .").append(this.renderMethod(request, extractedUri)).append("\n       |  ").append(this.renderHeaders(request)).append("\n       |  ").append(this.renderBodyOrParams(request)).append("\n       |  ").append(this.renderBasicAuthCredentials(request)).append("\n       |  ").append(this.renderStatusCheck(request)).append("\n       |  ").append(this.renderResponseBodyCheck(request)).append("\n       |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderResources(simulationClass, request, extractedUri)), 2)).toString()))));
    }

    private final String renderLongString$1(String value) {
        return value.length() > RequestTemplate$.MODULE$.io$gatling$recorder$convert$template$RequestTemplate$$MaxLiteralSize() ? new StringBuilder(14).append("Seq(").append(StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(value), RequestTemplate$.MODULE$.io$gatling$recorder$convert$template$RequestTemplate$$MaxLiteralSize()).map((Function1 & Serializable)x$1 -> package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString((String)x$1), this.format())).mkString(", ")).append(").mkString").toString() : package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(value), this.format());
    }

    public RequestTemplate(Map<Object, DumpedBody> requestBodies, Map<Object, DumpedBody> responseBodies, RecorderConfiguration config) {
        this.requestBodies = requestBodies;
        this.responseBodies = responseBodies;
        this.config = config;
        this.format = config.core().format();
        Format format = this.format();
        String string = Format$Kotlin$.MODULE$.equals(format) ? "`is`" : "is";
        this.isCheck = string;
    }
}

