/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.shared.unstable.util.PathHelper;
import io.gatling.commons.shared.unstable.util.PathHelper$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.core.filter.Filters$;
import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.convert.HttpTraffic;
import io.gatling.recorder.convert.HttpTraffic$;
import io.gatling.recorder.convert.HttpTrafficConverter;
import io.gatling.recorder.convert.RequestElement;
import io.gatling.recorder.convert.RequestElement$;
import io.gatling.recorder.convert.TagElement;
import io.gatling.recorder.convert.TimedScenarioElement;
import io.gatling.recorder.http.Mitm;
import io.gatling.recorder.http.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.SslFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d!B\u000b\u0017\u0001aq\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000be\u0002A\u0011\u0001\u001e\t\u000fy\u0002!\u0019!C\u0005\u007f!1a\t\u0001Q\u0001\n\u0001C\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002%\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u0003J\u0011%9\u0006\u00011AA\u0002\u0013%\u0001\fC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"I!\r\u0001a\u0001\u0002\u0003\u0006K!\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019!\b\u0001)A\u0005K\"9Q\u000f\u0001b\u0001\n\u00131\bB\u0002?\u0001A\u0003%q\u000fC\u0003~\u0001\u0011\u0005a\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0004\u0002d\u0001!\tA \u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u00181\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005eQ\u0012\u0001\u0003:fG>\u0014H-\u001a:\u000b\u0005ma\u0012aB4bi2Lgn\u001a\u0006\u0002;\u0005\u0011\u0011n\\\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'[5\tqE\u0003\u0002)S\u0005a1oY1mC2|wmZ5oO*\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!AL\u0014\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0015\u0019Gn\\2l\u0007\u0001\u0001\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003mi\tqaY8n[>t7/\u0003\u00029g\t)1\t\\8dW\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\f\t\u000b=\u0012\u0001\u0019A\u0019\u0002\u0011\u0019\u0014xN\u001c;F]\u0012,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007b\t!!^5\n\u0005\u0015\u0013%\u0001\u0005*fG>\u0014H-\u001a:Ge>tG/\u00128e\u0003%1'o\u001c8u\u000b:$\u0007%\u0001\u0003nSRlW#A%\u0011\u0005)kU\"A&\u000b\u00051C\u0012\u0001\u00025uiBL!AT&\u0003\t5KG/\\\u0001\t[&$Xn\u0018\u0013fcR\u0011\u0011\u000b\u0016\t\u0003AIK!aU\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b+\u001a\t\t\u00111\u0001J\u0003\rAH%M\u0001\u0006[&$X\u000eI\u0001\nG>tg/\u001a:uKJ,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039b\tqaY8om\u0016\u0014H/\u0003\u0002_7\n!\u0002\n\u001e;q)J\fgMZ5d\u0007>tg/\u001a:uKJ\fQbY8om\u0016\u0014H/\u001a:`I\u0015\fHCA)b\u0011\u001d)\u0016\"!AA\u0002e\u000b!bY8om\u0016\u0014H/\u001a:!\u0003!\u0011X-];fgR\u001cX#A3\u0011\u0007\u0019dg.D\u0001h\u0015\tA\u0017.\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u000e6\u000b\u0003-\fAA[1wC&\u0011Qn\u001a\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\rQv.]\u0005\u0003an\u0013A\u0003V5nK\u0012\u001c6-\u001a8be&|W\t\\3nK:$\bC\u0001.s\u0013\t\u00198L\u0001\bSKF,Xm\u001d;FY\u0016lWM\u001c;\u0002\u0013I,\u0017/^3tiN\u0004\u0013\u0001\u0002;bON,\u0012a\u001e\t\u0004M2D\bc\u0001.psB\u0011!L_\u0005\u0003wn\u0013!\u0002V1h\u000b2,W.\u001a8u\u0003\u0015!\u0018mZ:!\u00039\u0019H/\u0019:u%\u0016\u001cwN\u001d3j]\u001e$\u0012!U\u0001\u000egR|\u0007OU3d_J$\u0017N\\4\u0015\u0007E\u000b\u0019\u0001C\u0004\u0002\u0006A\u0001\r!a\u0002\u0002\tM\fg/\u001a\t\u0004A\u0005%\u0011bAA\u0006C\t9!i\\8mK\u0006t\u0017a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\u000bE\u000b\t\"!\t\t\u000f\u0005M\u0011\u00031\u0001\u0002\u0016\u00059!/Z9vKN$\b\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0001$A\u0003n_\u0012,G.\u0003\u0003\u0002 \u0005e!a\u0003%uiB\u0014V-];fgRDq!a\t\u0012\u0001\u0004\t)#\u0001\u0005sKN\u0004xN\\:f!\u0011\t9\"a\n\n\t\u0005%\u0012\u0011\u0004\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\u0007C\u0012$G+Y4\u0015\u0007E\u000by\u0003C\u0004\u00022I\u0001\r!a\r\u0002\tQ,\u0007\u0010\u001e\t\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005}\u0002cAA\u001dC5\u0011\u00111\b\u0006\u0004\u0003{\u0001\u0014A\u0002\u001fs_>$h(C\u0002\u0002B\u0005\na\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!C\u0005\u00012/Z2ve\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0004#\u00065\u0003bBA('\u0001\u0007\u0011\u0011K\u0001\u000fg\u0016\u001cWO]3e\u0011>\u001cH/\u0016*J!\u0011\t\u0019&a\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n1!\u001e:j\u0015\u0011\tY&!\u0018\u0002\r\rd\u0017.\u001a8u\u0015\ta%$\u0003\u0003\u0002b\u0005U#aA+sS\u0006\u00112\r\\3beJ+7m\u001c:eKJ\u001cF/\u0019;f\u0001")
public class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private Mitm mitm;
    private HttpTrafficConverter converter;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private HttpTrafficConverter converter() {
        return this.converter;
    }

    private void converter_$eq(HttpTrafficConverter x$1) {
        this.converter = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        this.converter_$eq(new HttpTrafficConverter(config));
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        String harFilePath = this.frontEnd().harFilePath();
        Path harFile = Paths.get(harFilePath, new String[0]);
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(harFile))) {
            this.frontEnd().handleMissingHarFile(harFilePath);
        } else {
            boolean proceed;
            boolean bl = proceed = this.converter().simulationFileExists() ? this.frontEnd().askSimulationOverwrite() : true;
            if (proceed) {
                RecorderMode recorderMode2 = selectedMode;
                if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                    Validation<BoxedUnit> validation = this.converter().convertHarFile(harFile);
                    if (validation instanceof Failure) {
                        Failure failure = (Failure)validation;
                        String errMsg = failure.message();
                        this.frontEnd().handleHarExportFailure(errMsg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.frontEnd().handleHarExportSuccess();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                    this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, config));
                    this.frontEnd().recordingStarted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)recorderMode2);
                }
            }
        }
    }

    public void stopRecording(boolean save) {
        this.frontEnd().recordingStopped();
        try {
            if (this.requests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping Simulation generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
                HttpTraffic traffic = HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().toList(), (List<TimedScenarioElement<TagElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.tags()).asScala().toList(), config);
                this.converter().convertHttpTraffic(traffic);
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        block0: {
            RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
            if (!config.filters().filters().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accept(request.uri()))) || !Filters$.MODULE$.BrowserNoiseFilters().accept(request.uri())) break block0;
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, config)));
            Option previousSendTime = CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().lastOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)t -> {
                block0: {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                    if (!delta.$greater((Object)config.core().thresholdForPauseCreation())) break block0;
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, config));
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEvent(new SslFrontEndEvent(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.recorderConfiguration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
        Statics.releaseFence();
    }
}

