/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.convert;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.shared.unstable.util.PathHelper;
import io.gatling.commons.shared.unstable.util.PathHelper$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.convert.DumpedBodies;
import io.gatling.recorder.convert.DumpedBodies$;
import io.gatling.recorder.convert.DumpedBody;
import io.gatling.recorder.convert.HttpTraffic;
import io.gatling.recorder.convert.HttpTraffic$;
import io.gatling.recorder.convert.HttpTrafficElement;
import io.gatling.recorder.convert.ProtocolDefinition;
import io.gatling.recorder.convert.ProtocolDefinition$;
import io.gatling.recorder.convert.RequestBody;
import io.gatling.recorder.convert.RequestBodyBytes;
import io.gatling.recorder.convert.RequestElement;
import io.gatling.recorder.convert.RequestElement$;
import io.gatling.recorder.convert.ResponseBody;
import io.gatling.recorder.convert.ResponseBodyBytes;
import io.gatling.recorder.convert.TagElement;
import io.gatling.recorder.convert.TimedScenarioElement;
import io.gatling.recorder.convert.template.SimulationTemplate$;
import io.gatling.recorder.har.HarReader$;
import io.gatling.recorder.har.HttpTransaction;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.util.HttpUtils$;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!\u0002\u0007\u000e\u0001=)\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b5\u0002A\u0011\u0001\u0018\t\u000fI\u0002!\u0019!C\u0005g!1a\b\u0001Q\u0001\nQBQa\u0010\u0001\u0005\u0002\u0001CQ\u0001\u0012\u0001\u0005\n\u0015CQA\u0014\u0001\u0005\u0002=CQA\u0017\u0001\u0005\u0002mCQ!\u0019\u0001\u0005\n\tDQ\u0001\u001d\u0001\u0005\nEDq!!\u0007\u0001\t\u0013\tYB\u0001\u000bIiR\u0004HK]1gM&\u001c7i\u001c8wKJ$XM\u001d\u0006\u0003\u001d=\tqaY8om\u0016\u0014HO\u0003\u0002\u0011#\u0005A!/Z2pe\u0012,'O\u0003\u0002\u0013'\u00059q-\u0019;mS:<'\"\u0001\u000b\u0002\u0005%|7c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0004\u0001A\u0011\u0011fK\u0007\u0002U)\u0011aeD\u0005\u0003Y)\u0012QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u00035AQA\n\u0002A\u0002!\nab]5nk2\fG/[8o\r&dW-F\u00015!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0003gS2,'BA\u001d;\u0003\rq\u0017n\u001c\u0006\u0002w\u0005!!.\u0019<b\u0013\tidG\u0001\u0003QCRD\u0017aD:j[Vd\u0017\r^5p]\u001aKG.\u001a\u0011\u0002)MLW.\u001e7bi&|gNR5mK\u0016C\u0018n\u001d;t+\u0005\t\u0005CA\fC\u0013\t\u0019\u0005DA\u0004C_>dW-\u00198\u0002\u0011\u0011,X\u000e\u001d\"pIf$\"AR%\u0011\u0005]9\u0015B\u0001%\u0019\u0005\u0011)f.\u001b;\t\u000b)3\u0001\u0019A&\u0002\t\t|G-\u001f\t\u0003a1K!!T\u0007\u0003\u0015\u0011+X\u000e]3e\u0005>$\u00170\u0001\bd_:4XM\u001d;ICJ4\u0015\u000e\\3\u0015\u0005AC\u0006cA)W\r6\t!K\u0003\u0002T)\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005U\u000b\u0012aB2p[6|gn]\u0005\u0003/J\u0013!BV1mS\u0012\fG/[8o\u0011\u0015Iv\u00011\u00015\u0003\u001dA\u0017M\u001d$jY\u0016\f!cY8om\u0016\u0014H\u000f\u0013;uaR\u0013\u0018M\u001a4jGR\u0011a\t\u0018\u0005\u0006;\"\u0001\rAX\u0001\u0011g\u000e,g.\u0019:j_\u0016cW-\\3oiN\u0004\"\u0001M0\n\u0005\u0001l!a\u0003%uiB$&/\u00194gS\u000e\f1D]3oI\u0016\u00148kY3oCJLw.\u00118e\tVl\u0007OQ8eS\u0016\u001cHCA2o!\t!7N\u0004\u0002fSB\u0011a\rG\u0007\u0002O*\u0011\u0001nJ\u0001\u0007yI|w\u000e\u001e \n\u0005)D\u0012A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\r\t\u000b=L\u0001\u0019\u00010\u0002\u0011M\u001cWM\\1sS>\fabZ3u\u0005\u0006\u001cX\rS3bI\u0016\u00148\u000f\u0006\u0002s}B\u00111\u000f`\u0007\u0002i*\u0011QO^\u0001\u0005QR$\bO\u0003\u0002xq\u0006)1m\u001c3fG*\u0011\u0011P_\u0001\bQ\u0006tG\r\\3s\u0015\tY8#A\u0003oKR$\u00180\u0003\u0002~i\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0011\u0019y(\u00021\u0001\u0002\u0002\u0005y!/Z9vKN$X\t\\3nK:$8\u000f\u0005\u0004\u0002\u0004\u00055\u00111\u0003\b\u0005\u0003\u000b\tIAD\u0002g\u0003\u000fI\u0011!G\u0005\u0004\u0003\u0017A\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0002TKFT1!a\u0003\u0019!\r\u0001\u0014QC\u0005\u0004\u0003/i!A\u0004*fcV,7\u000f^#mK6,g\u000e^\u0001\u000bO\u0016$()Y:f+JdGcA2\u0002\u001e!1qp\u0003a\u0001\u0003\u0003\u0001")
public class HttpTrafficConverter
implements StrictLogging {
    private final RecorderConfiguration config;
    private final Path simulationFile;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Path simulationFile() {
        return this.simulationFile;
    }

    public boolean simulationFileExists() {
        return PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(this.simulationFile()));
    }

    private void dumpBody(DumpedBody body) {
        Using$.MODULE$.resource((Object)PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(body.filePath())), (Function1 & Serializable)fw -> {
            HttpTrafficConverter.$anonfun$dumpBody$1(this, body, fw);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Validation<BoxedUnit> convertHarFile(Path harFile) {
        return io.gatling.commons.validation.package$.MODULE$.safely((Function1 & Serializable)error -> new StringBuilder(33).append("Error while processing HAR file: ").append((String)error).toString(), (Function0 & Serializable)() -> {
            Failure failure;
            List<HttpTransaction> transactions = HarReader$.MODULE$.readFile(harFile, $this.config.filters().filters());
            if (transactions.isEmpty()) {
                failure = package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("the selected file doesn't contain any valid HTTP requests"));
            } else {
                List scenarioElements = transactions.map((Function1 & Serializable)x0$1 -> {
                    HttpTransaction httpTransaction = x0$1;
                    if (httpTransaction == null) {
                        throw new MatchError((Object)httpTransaction);
                    }
                    HttpRequest request = httpTransaction.request();
                    HttpResponse response = httpTransaction.response();
                    RequestElement element = RequestElement$.MODULE$.apply(request, response, $this.config);
                    TimedScenarioElement<RequestElement> timedScenarioElement = new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), element);
                    return timedScenarioElement;
                });
                this.convertHttpTraffic(HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)scenarioElements, (List<TimedScenarioElement<TagElement>>)package$.MODULE$.Nil(), $this.config));
                failure = package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)BoxedUnit.UNIT));
            }
            return failure;
        });
    }

    public void convertHttpTraffic(HttpTraffic scenarioElements) {
        Predef$.MODULE$.require(!scenarioElements.isEmpty());
        String output = this.renderScenarioAndDumpBodies(scenarioElements);
        Using$.MODULE$.resource((Object)PathHelper.RichPath$.MODULE$.outputStream$extension(PathHelper$.MODULE$.RichPath(this.simulationFile())), (Function1 & Serializable)x$1 -> {
            x$1.write(output.getBytes(this.config.core().encoding()));
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private String renderScenarioAndDumpBodies(HttpTraffic scenario) {
        Set filteredHeaders = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.COOKIE, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderNames.HOST}))).$plus$plus((IterableOnce)(this.config.http().automaticReferer() ? (IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsciiString[]{HttpHeaderNames.REFERER})) : Predef$.MODULE$.Set().empty()));
        List<HttpTrafficElement> scenarioElements = scenario.elements();
        List mainRequestElements = scenarioElements.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends HttpTrafficElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)A1;
                    object = requestElement;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(HttpTrafficElement x1) {
                HttpTrafficElement httpTrafficElement = x1;
                boolean bl = httpTrafficElement instanceof RequestElement;
                return bl;
            }
        });
        List requestElements = mainRequestElements.flatMap((Function1 & Serializable)req -> {
            RequestElement requestElement = req;
            return req.nonEmbeddedResources().$colon$colon((Object)requestElement);
        });
        requestElements.foreach((Function1 & Serializable)requestElement -> {
            Object object = requestElement.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true) ? requestElement.headers().remove((CharSequence)HttpHeaderNames.CONNECTION) : BoxedUnit.UNIT;
            java.util.List authorizationHeaders = requestElement.headers().getAll((CharSequence)HttpHeaderNames.AUTHORIZATION);
            return requestElement.headers().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (java.lang.Iterable)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(authorizationHeaders).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("Basic ")))).asJava());
        });
        String baseUrl = this.getBaseUrl((Seq<RequestElement>)mainRequestElements);
        HttpHeaders baseHeaders = this.getBaseHeaders((Seq<RequestElement>)requestElements);
        ProtocolDefinition protocolConfigElement = new ProtocolDefinition(baseUrl, baseHeaders);
        List elements = scenarioElements.map((Function1 & Serializable)x0$1 -> {
            HttpTrafficElement httpTrafficElement;
            HttpTrafficElement httpTrafficElement2 = x0$1;
            if (httpTrafficElement2 instanceof RequestElement) {
                RequestElement requestElement = (RequestElement)httpTrafficElement2;
                requestElement.nonEmbeddedResources().foreach((Function1 & Serializable)x$3 -> x$3.makeRelativeTo(baseUrl));
                httpTrafficElement = requestElement.makeRelativeTo(baseUrl);
            } else {
                httpTrafficElement = httpTrafficElement2;
            }
            return httpTrafficElement;
        });
        ((List)requestElements.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RequestElement reqEl = (RequestElement)tuple2._1();
            int index = tuple2._2$mcI$sp();
            RequestElement requestElement = reqEl.setId(index);
            return requestElement;
        });
        DumpedBodies dumpedBodies = DumpedBodies$.MODULE$.apply(this.config);
        Map requestBodies = requestElements.flatMap((Function1 & Serializable)request -> request.body().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RequestBody, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof RequestBodyBytes) {
                    RequestBodyBytes requestBodyBytes = (RequestBodyBytes)A1;
                    byte[] bytes = requestBodyBytes.bytes();
                    object = bytes;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(RequestBody x2) {
                RequestBody requestBody = x2;
                boolean bl = requestBody instanceof RequestBodyBytes;
                return bl;
            }
        }).toList().map((Function1 & Serializable)bytes -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)request.id())), (Object)dumpedBodies.forRequest((RequestElement)request, (byte[])bytes)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map responseBodies = this.config.http().checkResponseBodies() ? requestElements.flatMap((Function1 & Serializable)request -> request.responseBody().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ResponseBody, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof ResponseBodyBytes) {
                    ResponseBodyBytes responseBodyBytes = (ResponseBodyBytes)A1;
                    byte[] bytes = responseBodyBytes.bytes();
                    object = bytes;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResponseBody x3) {
                ResponseBody responseBody = x3;
                boolean bl = responseBody instanceof ResponseBodyBytes;
                return bl;
            }
        }).toList().map((Function1 & Serializable)bytes -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)request.id())), (Object)dumpedBodies.forResponse((RequestElement)request, (byte[])bytes)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
        requestBodies.values().foreach((Function1 & Serializable)body -> {
            this.dumpBody(body);
            return BoxedUnit.UNIT;
        });
        responseBodies.values().foreach((Function1 & Serializable)body -> {
            this.dumpBody(body);
            return BoxedUnit.UNIT;
        });
        Map headers = (Map)SortedMap$.MODULE$.apply(this.generateHeaders$1(requestElements, Predef$.MODULE$.Map().empty(), filteredHeaders, baseHeaders).toSeq(), (Ordering)Ordering.Int$.MODULE$);
        return SimulationTemplate$.MODULE$.apply((Map<Object, DumpedBody>)requestBodies, (Map<Object, DumpedBody>)responseBodies, this.config).render(protocolConfigElement, (Map<Object, Seq<Tuple2<String, String>>>)headers, (Seq<HttpTrafficElement>)elements);
    }

    /*
     * WARNING - void declaration
     */
    private HttpHeaders getBaseHeaders(Seq<RequestElement> requestElements) {
        void var2_2;
        DefaultHttpHeaders baseHeaders = new DefaultHttpHeaders(false);
        CollectionConverters$.MODULE$.SetHasAsScala(ProtocolDefinition$.MODULE$.BaseHeadersAndProtocolMethods().names()).asScala().foreach((Function1 & Serializable)headerName -> {
            BoxedUnit boxedUnit;
            Option option = HttpTrafficConverter.getMostFrequentHeaderValue$1(headerName, requestElements);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mostFrequentValue = (String)some.value();
                boxedUnit = baseHeaders.add(headerName, (Object)mostFrequentValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var2_2;
    }

    private String getBaseUrl(Seq<RequestElement> requestElements) {
        Seq urlsOccurrences = (Seq)((IterableOps)requestElements.map((Function1 & Serializable)x$8 -> x$8.baseUrl())).groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
        return (String)((Tuple2)urlsOccurrences.maxBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    public static final /* synthetic */ void $anonfun$dumpBody$1(HttpTrafficConverter $this, DumpedBody body$1, OutputStream fw) {
        block3: {
            try {
                fw.write(body$1.bytes());
            }
            catch (IOException e) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(new StringBuilder(20).append("Failed to dump body ").append(body$1.filePath()).toString(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$14(Set filteredHeaders$1, HttpHeaders baseHeaders$1, RequestElement element$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var5_4 = x0$1;
                if (var5_4 == null) break block2;
                headerName = (String)var5_4._1();
                headerValue = (String)var5_4._2();
                isFiltered = HttpUtils$.MODULE$.containsIgnoreCase((Iterable<AsciiString>)filteredHeaders$1, headerName) != false || HttpUtils$.MODULE$.isHttp2PseudoHeader(headerName) != false;
                isAlreadyInBaseHeaders = HttpUtils$.MODULE$.getIgnoreCase(baseHeaders$1, headerName).contains((Object)headerValue);
                v0 = element$1.method();
                var11_9 = HttpMethod.POST.name();
                v1 = !(v0 != null ? v0.equals(var11_9) == false : var11_9 != null) && HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEqualsIgnoreCase((CharSequence)headerValue) != false ? true : (isPostWithFormParams = false);
                if (!HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)headerName)) ** GOTO lbl-1000
                v2 = headerValue;
                var13_11 = "0";
                if (!(v2 != null ? v2.equals(var13_11) == false : var13_11 != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                break block3;
            }
            throw new MatchError((Object)var5_4);
        }
        isEmptyContentLength = v3;
        var4_13 = isFiltered != false || isAlreadyInBaseHeaders != false || isPostWithFormParams != false || isEmptyContentLength != false;
        return var4_13;
    }

    public static final /* synthetic */ boolean $anonfun$renderScenarioAndDumpBodies$16(List acceptedHeaders$1, Tuple2 x0$2) {
        List existingHeaders;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List list = existingHeaders = (List)tuple2._2();
        List list2 = acceptedHeaders$1;
        boolean bl = !(list != null ? !list.equals(list2) : list2 != null);
        return bl;
    }

    private final Map generateHeaders$1(List elements, Map headers, Set filteredHeaders$1, HttpHeaders baseHeaders$1) {
        block6: {
            List list;
            while (true) {
                Map newHeaders;
                Map map;
                list = elements;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) break block6;
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                RequestElement element = (RequestElement)colon2.head();
                List others = colon2.next$access$1();
                List acceptedHeaders = (List)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(element.headers().entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), e.getValue()))).toList().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpTrafficConverter.$anonfun$renderScenarioAndDumpBodies$14(filteredHeaders$1, baseHeaders$1, element, x0$1))).sortBy((Function1 & Serializable)x$4 -> (String)x$4._1(), (Ordering)Ordering.String$.MODULE$);
                if (acceptedHeaders.isEmpty()) {
                    element.filteredHeadersId_$eq((Option<Object>)None$.MODULE$);
                    map = headers;
                } else {
                    Seq headersSeq = headers.toSeq();
                    int n = headersSeq.indexWhere((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)HttpTrafficConverter.$anonfun$renderScenarioAndDumpBodies$16(acceptedHeaders, x0$2)));
                    switch (n) {
                        case -1: {
                            element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)element.id())));
                            map = (Map)headers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)element.id())), (Object)acceptedHeaders));
                            break;
                        }
                        default: {
                            element.filteredHeadersId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((Tuple2)headersSeq.apply(n))._1$mcI$sp())));
                            map = headers;
                            break;
                        }
                    }
                }
                headers = newHeaders = map;
                elements = others;
            }
            throw new MatchError((Object)list);
        }
        Map map = headers;
        return map;
    }

    private static final Option getMostFrequentHeaderValue$1(String headerName, Seq requestElements$1) {
        None$ none$;
        Seq headers = (Seq)requestElements$1.flatMap((Function1 & Serializable)x$5 -> CollectionConverters$.MODULE$.ListHasAsScala(x$5.headers().getAll(headerName)).asScala());
        if (headers.isEmpty() || headers.length() != requestElements$1.length()) {
            none$ = None$.MODULE$;
        } else {
            Seq headersValuesOccurrences = (Seq)headers.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
            String mostFrequentValue = (String)((Tuple2)headersValuesOccurrences.maxBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
            none$ = new Some((Object)mostFrequentValue);
        }
        return none$;
    }

    public HttpTrafficConverter(RecorderConfiguration config) {
        this.config = config;
        StrictLogging.$init$((StrictLogging)this);
        Path sourcesFolderPath = PathHelper.RichPath$.MODULE$.mkdirs$extension(PathHelper$.MODULE$.RichPath(Paths.get(new StringBuilder(0).append(config.core().simulationsFolder()).append(File.separator).append(config.core().pkg().replace(".", File.separator)).toString(), new String[0])));
        this.simulationFile = PathHelper.RichPath$.MODULE$.$div$extension(PathHelper$.MODULE$.RichPath(sourcesFolderPath), new StringBuilder(1).append(config.core().className()).append(".").append(config.core().format().fileExtension()).toString());
        Statics.releaseFence();
    }
}

