/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.redis;

import com.redis.RedisClient;
import javax.net.ssl.SSLContext;
import scala.Option;

public class RedisClientPool {
    private final String host;
    private final int port;
    private final int maxIdle;
    private final int database;
    private final Object secret;
    private final int timeout;
    private final int maxConnections;
    private final long poolWaitTimeout;
    private final SSLContext sslContext;
    private final boolean batch;
    private com.redis.RedisClientPool scalaInstance;

    private synchronized void loadScalaInstance() {
        if (this.scalaInstance != null) {
            this.scalaInstance = new com.redis.RedisClientPool(this.host, this.port, this.maxIdle, this.database, Option.apply((Object)this.secret), this.timeout, this.maxConnections, this.poolWaitTimeout, Option.apply((Object)this.sslContext), (RedisClient.Mode)(this.batch ? RedisClient.BATCH$.MODULE$ : RedisClient.SINGLE$.MODULE$));
        }
    }

    public RedisClientPool(String string, int n) {
        this(string, n, 8, 0, null, 0, com.redis.RedisClientPool.UNLIMITED_CONNECTIONS(), 3000L, null, false);
    }

    private RedisClientPool(String string, int n, int n2, int n3, Object object, int n4, int n5, long l, SSLContext sSLContext, boolean bl) {
        this.host = string;
        this.port = n;
        this.maxIdle = n2;
        this.database = n3;
        this.secret = object;
        this.timeout = n4;
        this.maxConnections = n5;
        this.poolWaitTimeout = l;
        this.sslContext = sSLContext;
        this.batch = bl;
    }

    public RedisClientPool withMaxIdle(int n) {
        return new RedisClientPool(this.host, this.port, n, this.database, this.secret, this.timeout, this.maxConnections, this.poolWaitTimeout, this.sslContext, this.batch);
    }

    public RedisClientPool withDatabase(int n) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, n, this.secret, this.timeout, this.maxConnections, this.poolWaitTimeout, this.sslContext, this.batch);
    }

    public RedisClientPool withSecret(Object object) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, object, this.timeout, this.maxConnections, this.poolWaitTimeout, this.sslContext, this.batch);
    }

    public RedisClientPool withTimeout(int n) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, this.secret, n, this.maxConnections, this.poolWaitTimeout, this.sslContext, this.batch);
    }

    public RedisClientPool withMaxConnections(int n) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, this.secret, this.timeout, n, this.poolWaitTimeout, this.sslContext, this.batch);
    }

    public RedisClientPool withPoolWaitTimeout(long l) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, this.secret, this.timeout, this.maxConnections, l, this.sslContext, this.batch);
    }

    public RedisClientPool withSSLContext(SSLContext sSLContext) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, this.secret, this.timeout, this.maxConnections, this.poolWaitTimeout, sSLContext, this.batch);
    }

    public RedisClientPool withBatchMode(boolean bl) {
        return new RedisClientPool(this.host, this.port, this.maxIdle, this.database, this.secret, this.timeout, this.maxConnections, this.poolWaitTimeout, this.sslContext, bl);
    }

    com.redis.RedisClientPool asScala() {
        this.loadScalaInstance();
        return this.scalaInstance;
    }
}

