/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.shared.model.assertion;

import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.AssertionPath$ForAll$;
import io.gatling.commons.stats.assertion.AssertionPath$Global$;
import io.gatling.commons.stats.assertion.Condition;
import io.gatling.commons.stats.assertion.CountMetric;
import io.gatling.commons.stats.assertion.CountMetric$AllRequests$;
import io.gatling.commons.stats.assertion.CountMetric$FailedRequests$;
import io.gatling.commons.stats.assertion.CountMetric$SuccessfulRequests$;
import io.gatling.commons.stats.assertion.Stat;
import io.gatling.commons.stats.assertion.Stat$Max$;
import io.gatling.commons.stats.assertion.Stat$Mean$;
import io.gatling.commons.stats.assertion.Stat$Min$;
import io.gatling.commons.stats.assertion.Stat$StandardDeviation$;
import io.gatling.commons.stats.assertion.Target;
import io.gatling.commons.stats.assertion.Target$MeanRequestsPerSecond$;
import io.gatling.commons.stats.assertion.TimeMetric;
import io.gatling.commons.stats.assertion.TimeMetric$ResponseTime$;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import scala.MatchError;
import scala.collection.immutable.List;

public final class AssertionMessage$ {
    public static final AssertionMessage$ MODULE$ = new AssertionMessage$();

    private String printableCountMetric(CountMetric countMetric) {
        CountMetric countMetric2 = countMetric;
        if (CountMetric$AllRequests$.MODULE$.equals(countMetric2)) {
            return "all events";
        }
        if (CountMetric$FailedRequests$.MODULE$.equals(countMetric2)) {
            return "failed events";
        }
        if (CountMetric$SuccessfulRequests$.MODULE$.equals(countMetric2)) {
            return "successful events";
        }
        throw new MatchError((Object)countMetric2);
    }

    private String printablePath(AssertionPath path) {
        AssertionPath.Details details;
        List<String> parts;
        AssertionPath assertionPath = path;
        if (AssertionPath$Global$.MODULE$.equals(assertionPath)) {
            return "Global";
        }
        if (assertionPath instanceof AssertionPath.Details && (parts = (details = (AssertionPath.Details)assertionPath).parts()) != null) {
            List<String> list = parts;
            if (list.isEmpty()) {
                return "Global";
            }
            return list.mkString(" / ");
        }
        if (AssertionPath$ForAll$.MODULE$.equals(assertionPath)) {
            throw new UnsupportedOperationException("Can't generate message for ForAll");
        }
        throw new MatchError((Object)assertionPath);
    }

    private String printableTarget(Target target) {
        Target target2 = target;
        if (target2 instanceof Target.Count) {
            Target.Count count = (Target.Count)target2;
            CountMetric countMetric = count.metric();
            return "count of " + this.printableCountMetric(countMetric);
        }
        if (target2 instanceof Target.Percent) {
            Target.Percent percent = (Target.Percent)target2;
            CountMetric countMetric = percent.metric();
            return "percentage of " + this.printableCountMetric(countMetric);
        }
        if (target2 instanceof Target.Time) {
            Object object;
            Target.Time time = (Target.Time)target2;
            TimeMetric timeMetric = time.metric();
            Stat stat = time.stat();
            Stat stat2 = stat;
            if (Stat$Min$.MODULE$.equals(stat2)) {
                object = "min";
            } else if (Stat$Max$.MODULE$.equals(stat2)) {
                object = "max";
            } else if (Stat$Mean$.MODULE$.equals(stat2)) {
                object = "mean";
            } else if (Stat$StandardDeviation$.MODULE$.equals(stat2)) {
                object = "standard deviation";
            } else if (stat2 instanceof Stat.Percentile) {
                Stat.Percentile percentile = (Stat.Percentile)stat2;
                double value = percentile.value();
                object = NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(value)) + " percentile";
            } else {
                throw new MatchError((Object)stat2);
            }
            String printableStat = object;
            TimeMetric timeMetric2 = timeMetric;
            if (!TimeMetric$ResponseTime$.MODULE$.equals(timeMetric2)) {
                throw new MatchError((Object)timeMetric2);
            }
            String printableTimeMetric = "response time";
            return printableStat + " of " + printableTimeMetric;
        }
        if (Target$MeanRequestsPerSecond$.MODULE$.equals(target2)) {
            return "mean requests per second";
        }
        throw new MatchError((Object)target2);
    }

    private String printableCondition(Condition condition) {
        Condition condition2 = condition;
        if (condition2 instanceof Condition.Lte) {
            Condition.Lte lte = (Condition.Lte)condition2;
            double expected = lte.value();
            return "is less than or equal to " + expected;
        }
        if (condition2 instanceof Condition.Gte) {
            Condition.Gte gte = (Condition.Gte)condition2;
            double expected = gte.value();
            return "is greater than or equal to " + expected;
        }
        if (condition2 instanceof Condition.Lt) {
            Condition.Lt lt = (Condition.Lt)condition2;
            double expected = lt.value();
            return "is less than " + expected;
        }
        if (condition2 instanceof Condition.Gt) {
            Condition.Gt gt = (Condition.Gt)condition2;
            double expected = gt.value();
            return "is greater than " + expected;
        }
        if (condition2 instanceof Condition.Is) {
            Condition.Is is = (Condition.Is)condition2;
            double expected = is.value();
            return "is " + expected;
        }
        if (condition2 instanceof Condition.Between) {
            Condition.Between between = (Condition.Between)condition2;
            double lowerBound = between.lowerBound();
            double upperBound = between.upperBound();
            boolean inclusive = between.inclusive();
            return "is between " + lowerBound + " and " + upperBound + (inclusive ? " inclusive" : "");
        }
        if (condition2 instanceof Condition.In) {
            Condition.In in = (Condition.In)condition2;
            List<Object> expected = in.elements();
            return "is in " + expected;
        }
        throw new MatchError((Object)condition2);
    }

    public String message(Assertion assertion) {
        return this.printablePath(assertion.path()) + ": " + this.printableTarget(assertion.target()) + " " + this.printableCondition(assertion.condition());
    }

    private AssertionMessage$() {
    }
}

