/*
 * Copyright 2011-2024 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.shared.util;

public final class StringBuilderPool {

  public static final StringBuilderPool DEFAULT = new StringBuilderPool();

  private final ThreadLocal<StringBuilder> pool =
      ThreadLocal.withInitial(() -> new StringBuilder(512));

  /**
   * BEWARE: MUSN'T APPEND TO ITSELF!
   *
   * @return a pooled StringBuilder
   */
  public StringBuilder get() {
    StringBuilder sb = pool.get();
    sb.setLength(0);
    return sb;
  }
}
