/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000513QAC\u0006\u0003\u001bUA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tS\u0001\u0011\t\u0011)A\u00059!A!\u0006\u0001B\u0001B\u0003%A\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002%\u0001\t\u0003J\u0005\"\u0002&\u0001\t\u0013I\u0005\"B&\u0001\t\u0003J%a\u0007)fe\u000e,g\u000e^5mKN|e/\u001a:US6,G+Z7qY\u0006$XM\u0003\u0002\r\u001b\u0005AA/Z7qY\u0006$XM\u0003\u0002\u000f\u001f\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005A\t\u0012AB2iCJ$8O\u0003\u0002\u0013'\u00059q-\u0019;mS:<'\"\u0001\u000b\u0002\u0005%|7C\u0001\u0001\u0017!\t9\u0002$D\u0001\f\u0013\tI2B\u0001\u0005UK6\u0004H.\u0019;f\u0003-\u0019wN\u001c;bS:,'/\u00133\u0004\u0001A\u0011QD\n\b\u0003=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R!!I\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0012\u0013!\u0002;ji2,\u0017!C=Bq&\u001ch*Y7f\u0003!\u0011XO\\*uCJ$\bCA\u0017/\u001b\u0005\u0011\u0013BA\u0018#\u0005\u0011auN\\4\u0002\t\u0011\fG/\u0019\t\u0004e]RdBA\u001a6\u001d\tyB'C\u0001$\u0013\t1$%A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$aA*fc*\u0011aG\t\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{=\tQa\u001d;biNL!a\u0010\u001f\u0003+A+'oY3oi&dWm\u001d,t)&lW\r\u00157pi\u00061A(\u001b8jiz\"bAQ\"E\u000b\u001a;\u0005CA\f\u0001\u0011\u0015Qb\u00011\u0001\u001d\u0011\u0015Ic\u00011\u0001\u001d\u0011\u0015Qc\u00011\u0001\u001d\u0011\u0015Yc\u00011\u0001-\u0011\u0015\u0001d\u00011\u00012\u0003\tQ7/F\u0001\u001d\u0003]\u0011XM\u001c3feB+'oY3oi&dWm]*fe&,7/\u0001\u0003ii6d\u0007")
public final class PercentilesOverTimeTemplate
extends Template {
    private final String containerId;
    private final String title;
    private final String yAxisName;
    private final long runStart;
    private final Seq<PercentilesVsTimePlot> data;

    @Override
    public String js() {
        return "\nnew Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    zoomType: 'x',\n    marginBottom: 60\n  },\n  colors: [" + Color.Requests$.MODULE$.Percentiles().map((Function1 & Serializable)color -> "'" + color + "'").mkString(", ") + "],\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: -65,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title chart_title_\">" + this.title + "</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false,\n    baseSeries: 9\n  },\n  rangeSelector: {\n    rangeSelector: { align: \"left\" },\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis:[\n    {\n      min: 0,\n      title: { text: '" + this.yAxisName + " (ms)' },\n      opposite: false\n    }\n  ],\n  plotOptions: {\n    arearange: { lineWidth: 1 },\n    series: {\n      dataGrouping: { enabled: false }\n    }\n  },\n  series: [\n  " + this.renderPercentilesSeries() + "\n  ]\n});\n";
    }

    private String renderPercentilesSeries() {
        if (this.data.nonEmpty()) {
            return "\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.percentile0()), "min", 10) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.percentile25()), "25%", 9) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.percentile50()), "50%", 8) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.percentile75()), "75%", 7) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.percentile80()), "80%", 6) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.percentile85()), "85%", 5) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.percentile90()), "90%", 4) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.percentile95()), "95%", 3) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.percentile99()), "99%", 2) + "},\n         {" + this.renderPercentileSeries$1((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.percentile100()), "max", 1) + "}";
        }
        return "";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }

    private final String renderPercentileSeries$1(Function1 f, String name, int zIndex) {
        return "\npointInterval: 1000,\nname: '" + name + "',\ndata: " + ((IterableOnceOps)this.data.map((Function1 & Serializable)plot -> "[" + this.truncateTimestampToSecond($this.runStart + (long)plot.time()) + ", " + plot.percentiles().map((Function1 & Serializable)percentiles -> f.apply(percentiles).toString()).getOrElse((Function0 & Serializable)() -> "null") + "]")).mkString("[", ", ", "]") + ",\ntooltip: { yDecimals: 0, ySuffix: 'ms' },\ntype : 'area',\nyAxis: 0,\nzIndex: " + zIndex + "\n";
    }

    public PercentilesOverTimeTemplate(String containerId, String title, String yAxisName, long runStart, Seq<PercentilesVsTimePlot> data) {
        this.containerId = containerId;
        this.title = title;
        this.yAxisName = yAxisName;
        this.runStart = runStart;
        this.data = data;
    }
}

