/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.highcharts.component.HighchartsComponent;
import io.gatling.charts.highcharts.template.CountsPerSecTemplate;
import io.gatling.charts.highcharts.template.DistributionTemplate;
import io.gatling.charts.highcharts.template.PercentilesOverTimeTemplate;
import io.gatling.charts.highcharts.template.RangesTemplate;
import io.gatling.charts.highcharts.template.RequestCountPolarTemplate;
import io.gatling.charts.highcharts.template.ResponseTimeScatterTemplate;
import io.gatling.charts.highcharts.template.UsersChartTemplate;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.UserSeries;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\u0006\r\u0005]AQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005B!BQ!\u0015\u0001\u0005BICQa\u0016\u0001\u0005BaCQ\u0001\u001b\u0001\u0005B%DQA\u001d\u0001\u0005BMDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011\u0011\b\u0001\u0005B\u0005m\"\u0001F\"p[B|g.\u001a8u\u0019&\u0014'/\u0019:z\u00136\u0004HN\u0003\u0002\u000e\u001d\u0005I1m\\7q_:,g\u000e\u001e\u0006\u0003\u001fA\t!\u0002[5hQ\u000eD\u0017M\u001d;t\u0015\t\t\"#\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003'Q\tqaZ1uY&twMC\u0001\u0016\u0003\tIwn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0005j\u0011\u0001\t\u0006\u0003\u001bAI!A\t\u0011\u0003!\r{W\u000e]8oK:$H*\u001b2sCJL\u0018A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\r\u0003e9W\r^+tKJ\u001cF/\u0019:u%\u0006$XmQ8na>tWM\u001c;\u0015\u000b%b\u0013H\u0010$\u0011\u0005}Q\u0013BA\u0016!\u0005%\u0019u.\u001c9p]\u0016tG\u000fC\u0003.\u0005\u0001\u0007a&A\u0006d_:$\u0018-\u001b8fe&#\u0007CA\u00187\u001d\t\u0001D\u0007\u0005\u0002255\t!G\u0003\u00024-\u00051AH]8pizJ!!\u000e\u000e\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kiAQA\u000f\u0002A\u0002m\n\u0001B];o'R\f'\u000f\u001e\t\u00033qJ!!\u0010\u000e\u0003\t1{gn\u001a\u0005\u0006\u007f\t\u0001\r\u0001Q\u0001\u000fC2dWk]3sgN+'/[3t!\t\tE)D\u0001C\u0015\t\u0019\u0005#A\u0003ti\u0006$8/\u0003\u0002F\u0005\nQQk]3s'\u0016\u0014\u0018.Z:\t\u000b\u001d\u0013\u0001\u0019\u0001%\u0002\u001dM\u001cWM\\1sS>\u001cVM]5fgB\u0019\u0011J\u0014!\u000f\u0005)ceBA\u0019L\u0013\u0005Y\u0012BA'\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u0007M+\u0017O\u0003\u0002N5\u0005qr-\u001a;NCb\u001cuN\\2veJ,g\u000e^+tKJ\u001c8i\\7q_:,g\u000e\u001e\u000b\u0006SM#VK\u0016\u0005\u0006[\r\u0001\rA\f\u0005\u0006u\r\u0001\ra\u000f\u0005\u0006\u007f\r\u0001\r\u0001\u0011\u0005\u0006\u000f\u000e\u0001\r\u0001S\u0001\u0013O\u0016$(+\u00198hKN\u001cu.\u001c9p]\u0016tG\u000f\u0006\u0004*3jcfl\u0019\u0005\u0006[\u0011\u0001\rA\f\u0005\u00067\u0012\u0001\rAL\u0001\u000bG\"\f'\u000f\u001e+ji2,\u0007\"B/\u0005\u0001\u0004q\u0013!C3wK:$h*Y7f\u0011\u0015yF\u00011\u0001a\u0003\u0019\u0011\u0018M\\4fgB\u0011\u0011)Y\u0005\u0003E\n\u0013aAU1oO\u0016\u001c\b\"\u00023\u0005\u0001\u0004)\u0017!\u00027be\u001e,\u0007CA\rg\u0013\t9'DA\u0004C_>dW-\u00198\u0002;\u001d,GOU3rk\u0016\u001cHoQ8v]R\u0004v\u000e\\1s\u0007>l\u0007o\u001c8f]R$\"!\u000b6\t\u000b-,\u0001\u0019\u00017\u0002\u001bI|w\u000e^\"p]R\f\u0017N\\3s!\ti\u0007/D\u0001o\u0015\ty\u0007#\u0001\u0004sKB|'\u000f^\u0005\u0003c:\u0014ab\u0012:pkB\u001cuN\u001c;bS:,'/\u0001\rhKR$\u0015n\u001d;sS\n,H/[8o\u0007>l\u0007o\u001c8f]R$b!\u000b;vof|\b\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002<\u0007\u0001\u0004q\u0013!\u0002;ji2,\u0007\"\u0002=\u0007\u0001\u0004q\u0013!C=Bq&\u001ch*Y7f\u0011\u0015Qh\u00011\u0001|\u0003Q\u0011Xm\u001d9p]N,G+[7fgN+8mY3tgB\u0019\u0011J\u0014?\u0011\u0005\u0005k\u0018B\u0001@C\u0005E\u0001VM]2f]R46\u000fV5nKBcw\u000e\u001e\u0005\u0007\u0003\u00031\u0001\u0019A>\u0002+I,7\u000f]8og\u0016$\u0016.\\3t\r\u0006LG.\u001e:fg\u0006yr-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cxJ^3s)&lWmQ8na>tWM\u001c;\u0015\u0017%\n9!!\u0003\u0002\f\u00055\u0011q\u0002\u0005\u0006[\u001d\u0001\rA\f\u0005\u0006m\u001e\u0001\rA\f\u0005\u0006q\u001e\u0001\rA\f\u0005\u0006u\u001d\u0001\ra\u000f\u0005\b\u0003#9\u0001\u0019AA\n\u0003\u0011!\u0017\r^1\u0011\t%s\u0015Q\u0003\t\u0004\u0003\u0006]\u0011bAA\r\u0005\n)\u0002+\u001a:dK:$\u0018\u000e\\3t-N$\u0016.\\3QY>$\u0018\u0001F4fiJ+\u0017/^3tiN\u001cu.\u001c9p]\u0016tG\u000fF\u0004*\u0003?\t\t#a\t\t\u000b5B\u0001\u0019\u0001\u0018\t\u000biB\u0001\u0019A\u001e\t\u000f\u0005\u0015\u0002\u00021\u0001\u0002(\u000511m\\;oiN\u0004B!\u0013(\u0002*A\u0019\u0011)a\u000b\n\u0007\u00055\"I\u0001\tD_VtGo\u001d,t)&lW\r\u00157pi\u0006)r-\u001a;SKN\u0004xN\\:fg\u000e{W\u000e]8oK:$HcB\u0015\u00024\u0005U\u0012q\u0007\u0005\u0006[%\u0001\rA\f\u0005\u0006u%\u0001\ra\u000f\u0005\b\u0003KI\u0001\u0019AA\u0014\u0003}9W\r\u001e*fgB|gn]3US6,7kY1ui\u0016\u00148i\\7q_:,g\u000e\u001e\u000b\bS\u0005u\u0012qHA&\u0011\u0015i#\u00021\u0001/\u0011\u001d\t\tE\u0003a\u0001\u0003\u0007\n\u0011b];dG\u0016\u001c8/Z:\u0011\t%s\u0015Q\t\t\u0004\u0003\u0006\u001d\u0013bAA%\u0005\ni\u0011J\u001c;WgRKW.\u001a)m_RDq!!\u0014\u000b\u0001\u0004\t\u0019%\u0001\u0005gC&dWO]3t\u0001")
public final class ComponentLibraryImpl
implements ComponentLibrary {
    public Component getUserStartRateComponent(String containerId, long runStart, UserSeries allUsersSeries, Seq<UserSeries> scenarioSeries) {
        return new HighchartsComponent(new UsersChartTemplate(containerId, "Number of users started per second", "Number of users started", runStart, allUsersSeries, scenarioSeries));
    }

    public Component getMaxConcurrentUsersComponent(String containerId, long runStart, UserSeries allUsersSeries, Seq<UserSeries> scenarioSeries) {
        return new HighchartsComponent(new UsersChartTemplate(containerId, "Number of concurrent users", "Number of concurrent users", runStart, allUsersSeries, scenarioSeries));
    }

    public Component getRangesComponent(String containerId, String chartTitle, String eventName, Ranges ranges, boolean large) {
        return new HighchartsComponent(new RangesTemplate(containerId, chartTitle, eventName, ranges, large));
    }

    public Component getRequestCountPolarComponent(GroupContainer rootContainer) {
        return new HighchartsComponent(new RequestCountPolarTemplate(rootContainer));
    }

    public Component getDistributionComponent(String containerId, String title, String yAxisName, Seq<PercentVsTimePlot> responseTimesSuccess, Seq<PercentVsTimePlot> responseTimesFailures) {
        return new HighchartsComponent(new DistributionTemplate(containerId, title, yAxisName, responseTimesSuccess, responseTimesFailures));
    }

    public Component getPercentilesOverTimeComponent(String containerId, String title, String yAxisName, long runStart, Seq<PercentilesVsTimePlot> data) {
        return new HighchartsComponent(new PercentilesOverTimeTemplate(containerId, title, yAxisName, runStart, data));
    }

    public Component getRequestsComponent(String containerId, long runStart, Seq<CountsVsTimePlot> counts) {
        return new HighchartsComponent(new CountsPerSecTemplate(containerId, "Number of requests per second", "Number of requests", runStart, counts, false));
    }

    public Component getResponsesComponent(String containerId, long runStart, Seq<CountsVsTimePlot> counts) {
        return new HighchartsComponent(new CountsPerSecTemplate(containerId, "Number of responses per second", "Number of responses", runStart, counts, true));
    }

    public Component getResponseTimeScatterComponent(String containerId, Seq<IntVsTimePlot> successes, Seq<IntVsTimePlot> failures) {
        return new HighchartsComponent(new ResponseTimeScatterTemplate(containerId, successes, failures, "Response Time against Global Throughput", "Response Time (ms)"));
    }
}

