/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q3Q\u0001D\u0007\u0003\u001f]A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tW\u0001\u0011\t\u0011)A\u0005=!AA\u0006\u0001B\u0001B\u0003%a\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!i\u0004A!A!\u0002\u0013q\u0003\"\u0002 \u0001\t\u0003y\u0004b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u0010\t\u000b%\u0003A\u0011I$\t\u000b)\u0003A\u0011B&\t\u000bm\u0003A\u0011I$\u0003)\u0011K7\u000f\u001e:jEV$\u0018n\u001c8UK6\u0004H.\u0019;f\u0015\tqq\"\u0001\u0005uK6\u0004H.\u0019;f\u0015\t\u0001\u0012#\u0001\u0006iS\u001eD7\r[1siNT!AE\n\u0002\r\rD\u0017M\u001d;t\u0015\t!R#A\u0004hCRd\u0017N\\4\u000b\u0003Y\t!![8\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005i\u0011BA\u000e\u000e\u0005!!V-\u001c9mCR,\u0017aC2p]R\f\u0017N\\3s\u0013\u0012\u001c\u0001\u0001\u0005\u0002 Q9\u0011\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0003Gu\ta\u0001\u0010:p_Rt$\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"\u0013A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\u0013\u0002\u000bQLG\u000f\\3\u0002\u0013e\f\u00050[:OC6,\u0017!D:vG\u000e,7o]*fe&,7\u000fE\u00020i]r!\u0001\r\u001a\u000f\u0005\u0005\n\u0014\"A\u0013\n\u0005M\"\u0013a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u0019D\u0005\u0005\u00029w5\t\u0011H\u0003\u0002;#\u0005)1\u000f^1ug&\u0011A(\u000f\u0002\u0012!\u0016\u00148-\u001a8u-N$\u0016.\\3QY>$\u0018!\u00044bS2,(/Z*fe&,7/\u0001\u0004=S:LGO\u0010\u000b\u0007\u0001\u0006\u00135\tR#\u0011\u0005e\u0001\u0001\"\u0002\u000f\u0007\u0001\u0004q\u0002\"B\u0016\u0007\u0001\u0004q\u0002\"\u0002\u0017\u0007\u0001\u0004q\u0002\"B\u0017\u0007\u0001\u0004q\u0003\"B\u001f\u0007\u0001\u0004q\u0013AC2bi\u0016<wN]5fgV\ta$A\u0006dCR,wm\u001c:jKN\u0004\u0013A\u00016t\u0003e\u0011XM\u001c3feN#\u0018mY6fI\u000e{G.^7o'\u0016\u0014\u0018.Z:\u0015\tya\u0015k\u0015\u0005\u0006\u001b*\u0001\rAT\u0001\u0007g\u0016\u0014\u0018.Z:\u0011\u0007=zu'\u0003\u0002Qm\tA\u0011\n^3sC\ndW\rC\u0003S\u0015\u0001\u0007a$\u0001\u0003oC6,\u0007\"\u0002+\u000b\u0001\u0004)\u0016!B2pY>\u0014\bC\u0001,Z\u001b\u00059&B\u0001-\u0012\u0003\u0011)H/\u001b7\n\u0005i;&!B\"pY>\u0014\u0018\u0001\u00025u[2\u0004")
public final class DistributionTemplate
extends Template {
    private final String containerId;
    private final String title;
    private final String yAxisName;
    private final Seq<PercentVsTimePlot> successSeries;
    private final Seq<PercentVsTimePlot> failureSeries;
    private final String categories;

    private String categories() {
        return this.categories;
    }

    @Override
    public String js() {
        return "\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerId + "',\n    type: 'column',\n    marginBottom: 60\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 5,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.title + " Distribution</span>',\n    useHTML: true\n  },\n  navigator: {\n    maskInside: false\n  },\n  xAxis: {\n    categories: " + this.categories() + ",\n    tickInterval: 20\n  },\n  yAxis: {\n    min: 0,\n    title: { text: 'Percentage of " + this.yAxisName + "' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      return '<b>'+ this.x +' ms</b><br/>'+\n      this.series.name +': '+ this.y +' %<br/>'+\n      'Total: '+ this.point.stackTotal + ' %';\n    }\n  },\n  plotOptions: {\n    series: {\n      groupPadding: 0,\n      stacking: 'normal',\n\t    shadow: true\n    }\n  },\n  series: [\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.successSeries, Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok()) + "},\n  \t{" + this.renderStackedColumnSeries((Iterable<PercentVsTimePlot>)this.failureSeries, Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko()) + "}\n  ]\n});\n";
    }

    private String renderStackedColumnSeries(Iterable<PercentVsTimePlot> series, String name, Color color) {
        return "\ntype: 'column',\ncolor: '" + color + "',\nname: '" + name + "',\ndata: [\n  " + ((IterableOnceOps)series.map((Function1 & Serializable)plot -> BoxesRunTime.boxToDouble((double)DistributionTemplate.$anonfun$renderStackedColumnSeries$1(plot)))).mkString(",") + "\n],\ntooltip: { yDecimals: 0, ySuffix: 'ms' }\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public static final /* synthetic */ double $anonfun$renderStackedColumnSeries$1(PercentVsTimePlot plot) {
        return (double)((int)(plot.value() * (double)100)) / 100.0;
    }

    public DistributionTemplate(String containerId, String title, String yAxisName, Seq<PercentVsTimePlot> successSeries, Seq<PercentVsTimePlot> failureSeries) {
        this.containerId = containerId;
        this.title = title;
        this.yAxisName = yAxisName;
        this.successSeries = successSeries;
        this.failureSeries = failureSeries;
        this.categories = ((IterableOnceOps)(successSeries.nonEmpty() ? successSeries : failureSeries).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.time()))).mkString("['", "', '", "']");
    }
}

