package io.gatling.macros

import scala.reflect.macros.blackbox

object StripMarginMacro {

  def stripMacro(c: blackbox.Context)(expr: c.Expr[String]): c.Expr[String] = {
    import c.universe._

    expr.tree match {
      case Literal(Constant(str: String)) =>
        c.Expr[String](Literal(Constant(str.stripMargin)))
      case _ =>
        c.abort(c.enclosingPosition, "You can only use the strip macro on constant Strings.")
    }
  }
}
