/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.SitemapException;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.URL;

abstract class AbstractSitemapGeneratorOptions<T extends AbstractSitemapGeneratorOptions<T>> {
    File baseDir;
    URL baseUrl;
    String fileNamePrefix = "sitemap";
    boolean allowEmptySitemap = false;
    boolean allowMultipleSitemaps = true;
    String suffixStringPattern;
    W3CDateFormat dateFormat;
    int maxUrls = 50000;
    boolean autoValidate = false;
    boolean gzip = false;

    AbstractSitemapGeneratorOptions(URL baseUrl, File baseDir) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl may not be null");
        }
        this.baseDir = baseDir;
        this.baseUrl = baseUrl;
    }

    AbstractSitemapGeneratorOptions(URL baseUrl) {
        this(baseUrl, null);
    }

    public T fileNamePrefix(String fileNamePrefix) {
        if (fileNamePrefix == null) {
            throw new NullPointerException("fileNamePrefix may not be null");
        }
        this.fileNamePrefix = fileNamePrefix;
        return this.getThis();
    }

    public T suffixStringPattern(String pattern) {
        this.suffixStringPattern = pattern;
        return this.getThis();
    }

    public T allowEmptySitemap(boolean allowEmpty) {
        this.allowEmptySitemap = allowEmpty;
        return this.getThis();
    }

    public T allowMultipleSitemaps(boolean allowMultipleSitemaps) {
        this.allowMultipleSitemaps = allowMultipleSitemaps;
        return this.getThis();
    }

    public T dateFormat(W3CDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this.getThis();
    }

    public T maxUrls(int maxUrls) {
        if (maxUrls > 50000) {
            throw new SitemapException(String.format("You can only have %d URLs per sitemap; to use more, allowMultipleSitemaps and generate a sitemap index. You asked for %d", 50000, maxUrls));
        }
        this.maxUrls = maxUrls;
        return this.getThis();
    }

    public T autoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
        return this.getThis();
    }

    public T gzip(boolean gzip) {
        this.gzip = gzip;
        return this.getThis();
    }

    T getThis() {
        return (T)this;
    }
}

