/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.ChangeFreq;
import com.redfin.sitemapgenerator.SitemapException;
import com.redfin.sitemapgenerator.W3CDateFormat;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

abstract class AbstractSitemapUrlOptions<U extends WebSitemapUrl, T extends AbstractSitemapUrlOptions<U, T>> {
    Date lastMod;
    ChangeFreq changeFreq;
    Double priority;
    URL url;
    Class<U> clazz;

    AbstractSitemapUrlOptions(String url, Class<U> clazz) throws MalformedURLException {
        this(new URL(url), clazz);
    }

    AbstractSitemapUrlOptions(URL url, Class<U> clazz) {
        if (url == null) {
            throw new NullPointerException("URL may not be null");
        }
        this.url = url;
        this.clazz = clazz;
    }

    public T lastMod(Date lastMod) {
        this.lastMod = lastMod;
        return this.getThis();
    }

    public T lastMod(String lastMod) throws ParseException {
        this.lastMod = new W3CDateFormat().parse(lastMod);
        return this.getThis();
    }

    public T changeFreq(ChangeFreq changeFreq) {
        this.changeFreq = changeFreq;
        return this.getThis();
    }

    public T priority(Double priority) {
        if (priority > 1.0) {
            throw new IllegalArgumentException("Priority may not be greater than 1.0: " + priority);
        }
        if (priority < 0.0) {
            throw new IllegalArgumentException("Priority may not be less than 0: " + priority);
        }
        this.priority = priority;
        return this.getThis();
    }

    T getThis() {
        return (T)this;
    }

    public U build() {
        try {
            return (U)((WebSitemapUrl)this.clazz.getConstructor(this.getClass()).newInstance(this));
        }
        catch (Exception e) {
            throw new SitemapException(e);
        }
    }
}

