/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapUrlOptions;
import com.redfin.sitemapgenerator.Image;
import com.redfin.sitemapgenerator.SitemapException;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoogleImageSitemapUrl
extends WebSitemapUrl {
    private final List<Image> images;
    private static final String ERROR_MORE_1000_IMG = "A URL cannot have more than 1000 image tags";

    public GoogleImageSitemapUrl(String url) throws MalformedURLException {
        this(new Options(url));
    }

    public GoogleImageSitemapUrl(URL url) {
        this(new Options(url));
    }

    public GoogleImageSitemapUrl(Options options) {
        super(options);
        this.images = options.images;
    }

    public void addImage(Image image) {
        this.images.add(image);
        if (this.images.size() > 1000) {
            throw new SitemapException(ERROR_MORE_1000_IMG);
        }
    }

    public List<Image> getImages() {
        return this.images;
    }

    public static class Options
    extends AbstractSitemapUrlOptions<GoogleImageSitemapUrl, Options> {
        private List<Image> images = new ArrayList<Image>();

        public Options(URL url) {
            super(url, GoogleImageSitemapUrl.class);
        }

        public Options(String url) throws MalformedURLException {
            super(url, GoogleImageSitemapUrl.class);
        }

        public Options images(List<Image> images) {
            if (images != null && images.size() > 1000) {
                throw new SitemapException(GoogleImageSitemapUrl.ERROR_MORE_1000_IMG);
            }
            this.images = images;
            return this;
        }

        public Options images(Image ... images) {
            if (images.length > 1000) {
                throw new SitemapException(GoogleImageSitemapUrl.ERROR_MORE_1000_IMG);
            }
            return this.images(Arrays.asList(images));
        }
    }
}

