/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapUrlOptions;
import com.redfin.sitemapgenerator.GoogleNewsPublication;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;

public class GoogleNewsSitemapUrl
extends WebSitemapUrl {
    private final Date publicationDate;
    private final String keywords;
    private final String genres;
    private final String title;
    private final GoogleNewsPublication publication;

    public GoogleNewsSitemapUrl(URL url, Date publicationDate, String title, String name, String language) {
        this(new Options(url, publicationDate, title, name, language));
    }

    public GoogleNewsSitemapUrl(URL url, Date publicationDate, String title, GoogleNewsPublication publication) {
        this(new Options(url, publicationDate, title, publication));
    }

    public GoogleNewsSitemapUrl(String url, Date publicationDate, String title, String name, String language) throws MalformedURLException {
        this(new Options(url, publicationDate, title, name, language));
    }

    public GoogleNewsSitemapUrl(String url, Date publicationDate, String title, GoogleNewsPublication publication) throws MalformedURLException {
        this(new Options(url, publicationDate, title, publication));
    }

    public GoogleNewsSitemapUrl(Options options) {
        super(options);
        this.publicationDate = options.publicationDate;
        this.keywords = options.keywords;
        this.genres = options.genres;
        this.title = options.title;
        this.publication = options.publication;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getGenres() {
        return this.genres;
    }

    public String getTitle() {
        return this.title;
    }

    public GoogleNewsPublication getPublication() {
        return this.publication;
    }

    public static class Options
    extends AbstractSitemapUrlOptions<GoogleNewsSitemapUrl, Options> {
        private final Date publicationDate;
        private String keywords;
        private String genres;
        private final String title;
        private final GoogleNewsPublication publication;

        public Options(String url, Date publicationDate, String title, GoogleNewsPublication publication) throws MalformedURLException {
            this(new URL(url), publicationDate, title, publication);
        }

        public Options(String url, Date publicationDate, String title, String name, String language) throws MalformedURLException {
            this(new URL(url), publicationDate, title, new GoogleNewsPublication(name, language));
        }

        public Options(URL url, Date publicationDate, String title, String name, String language) {
            this(url, publicationDate, title, new GoogleNewsPublication(name, language));
        }

        public Options(URL url, Date publicationDate, String title, GoogleNewsPublication publication) {
            super(url, GoogleNewsSitemapUrl.class);
            if (publicationDate == null) {
                throw new NullPointerException("publicationDate must not be null");
            }
            this.publicationDate = publicationDate;
            if (title == null) {
                throw new NullPointerException("title must not be null");
            }
            this.title = title;
            if (publication == null) {
                throw new NullPointerException("publication must not be null");
            }
            if (publication.getName() == null) {
                throw new NullPointerException("publication name must not be null");
            }
            if (publication.getLanguage() == null) {
                throw new NullPointerException("publication language must not be null");
            }
            this.publication = publication;
        }

        public Options keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public Options keywords(Iterable<String> keywords) {
            this.keywords = this.getListAsCommaSeparatedString(keywords);
            return this;
        }

        public Options genres(String genres) {
            this.genres = genres;
            return this;
        }

        public Options genres(Iterable<String> genres) {
            this.genres = this.getListAsCommaSeparatedString(genres);
            return this;
        }

        private String getListAsCommaSeparatedString(Iterable<String> values) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(value);
            }
            return sb.toString();
        }

        public Options keywords(String ... keywords) {
            return this.keywords(Arrays.asList(keywords));
        }

        public Options genres(String ... genres) {
            return this.genres(Arrays.asList(genres));
        }
    }
}

