/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapUrlOptions;
import com.redfin.sitemapgenerator.SitemapException;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GoogleVideoSitemapUrl
extends WebSitemapUrl {
    private final URL playerUrl;
    private final URL contentUrl;
    private final URL thumbnailUrl;
    private final String title;
    private final String description;
    private final Double rating;
    private final Integer viewCount;
    private final Date publicationDate;
    private final List<String> tags;
    private final String category;
    private final String familyFriendly;
    private final Integer durationInSeconds;
    private final String allowEmbed;

    public GoogleVideoSitemapUrl(URL url, URL playerUrl, boolean allowEmbed) {
        this(new Options(url, playerUrl, allowEmbed));
    }

    public GoogleVideoSitemapUrl(URL url, URL contentUrl) {
        this(new Options(url, contentUrl));
    }

    public GoogleVideoSitemapUrl(Options options) {
        super(options);
        this.contentUrl = options.contentUrl;
        this.playerUrl = options.playerUrl;
        if (this.playerUrl == null && this.contentUrl == null) {
            throw new SitemapException("You must specify either contentUrl or playerUrl or both; neither were specified");
        }
        this.allowEmbed = GoogleVideoSitemapUrl.convertBooleanToYesOrNo(options.allowEmbed);
        if (this.playerUrl != null && this.allowEmbed == null) {
            throw new SitemapException("allowEmbed must be specified if playerUrl is specified");
        }
        this.category = options.category;
        this.description = options.description;
        this.durationInSeconds = options.durationInSeconds;
        this.familyFriendly = GoogleVideoSitemapUrl.convertBooleanToYesOrNo(options.familyFriendly);
        this.publicationDate = options.publicationDate;
        this.rating = options.rating;
        this.tags = options.tags;
        if (this.tags != null && this.tags.size() > 32) {
            throw new SitemapException("A maximum of 32 tags is permitted");
        }
        this.thumbnailUrl = options.thumbnailUrl;
        this.title = options.title;
        this.viewCount = options.viewCount;
    }

    private static String convertBooleanToYesOrNo(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Yes" : "No";
    }

    public URL getPlayerUrl() {
        return this.playerUrl;
    }

    public URL getContentUrl() {
        return this.contentUrl;
    }

    public URL getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getRating() {
        return this.rating;
    }

    public Integer getViewCount() {
        return this.viewCount;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFamilyFriendly() {
        return this.familyFriendly;
    }

    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public String getAllowEmbed() {
        return this.allowEmbed;
    }

    public static class Options
    extends AbstractSitemapUrlOptions<GoogleVideoSitemapUrl, Options> {
        private URL playerUrl;
        private URL contentUrl;
        private URL thumbnailUrl;
        private String title;
        private String description;
        private Double rating;
        private Integer viewCount;
        private Date publicationDate;
        private List<String> tags;
        private String category;
        private Boolean familyFriendly;
        private Integer durationInSeconds;
        private Boolean allowEmbed;

        public Options(URL url, URL playerUrl, boolean allowEmbed) {
            super(url, GoogleVideoSitemapUrl.class);
            this.playerUrl = playerUrl;
            this.allowEmbed = allowEmbed;
        }

        public Options(URL url, URL contentUrl) {
            super(url, GoogleVideoSitemapUrl.class);
            this.contentUrl = contentUrl;
        }

        public Options playerUrl(URL playerUrl, boolean allowEmbed) {
            this.playerUrl = playerUrl;
            this.allowEmbed = allowEmbed;
            return this;
        }

        public Options contentUrl(URL contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public Options thumbnailUrl(URL thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public Options title(String title) {
            if (title != null && title.length() > 100) {
                throw new SitemapException("Video title is limited to 100 characters: " + title);
            }
            this.title = title;
            return this;
        }

        public Options description(String description) {
            if (description != null && description.length() > 2048) {
                throw new SitemapException("Truncate video descriptions to 2048 characters: " + description);
            }
            this.description = description;
            return this;
        }

        public Options rating(Double rating) {
            if (rating != null && (rating < 0.0 || rating > 5.0)) {
                throw new SitemapException("Rating must be between 0.0 and 5.0:" + rating);
            }
            this.rating = rating;
            return this;
        }

        public Options viewCount(int viewCount) {
            this.viewCount = viewCount;
            return this;
        }

        public Options publicationDate(Date publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        public Options tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Options tags(Iterable<String> tags) {
            this.tags = new ArrayList<String>();
            for (String tag : tags) {
                this.tags.add(tag);
            }
            return this;
        }

        public Options tags(String ... tags) {
            return this.tags(Arrays.asList(tags));
        }

        public Options category(String category) {
            if (category != null && category.length() > 256) {
                throw new SitemapException("Video category is limited to 256 characters: " + this.title);
            }
            this.category = category;
            return this;
        }

        public Options familyFriendly(boolean familyFriendly) {
            this.familyFriendly = familyFriendly;
            return this;
        }

        public Options durationInSeconds(int durationInSeconds) {
            if (durationInSeconds < 0 || durationInSeconds > 28800) {
                throw new SitemapException("Duration must be between 0 and 28800 (8 hours):" + durationInSeconds);
            }
            this.durationInSeconds = durationInSeconds;
            return this;
        }
    }
}

